/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.GradlePluginDevelopmentCompatibilityExtension;
import dev.gradleplugins.GradlePluginDevelopmentTestSuite;
import dev.gradleplugins.internal.GradlePluginDevelopmentDependencyExtensionInternal;
import dev.gradleplugins.internal.GradlePluginDevelopmentTestSuiteInternal;
import dev.gradleplugins.internal.plugins.GradlePluginDevelopmentTestingBasePlugin;
import java.util.HashSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;

public abstract class GradlePluginDevelopmentUnitTestingPlugin
implements Plugin<Project> {
    private static final String TEST_NAME = "test";

    public void apply(Project project) {
        project.getPluginManager().apply(GradlePluginDevelopmentTestingBasePlugin.class);
        project.getPluginManager().withPlugin("dev.gradleplugins.java-gradle-plugin", appliedPlugin -> this.createUnitTestSuite(project));
        project.getPluginManager().withPlugin("dev.gradleplugins.groovy-gradle-plugin", appliedPlugin -> this.createUnitTestSuite(project));
    }

    private void createUnitTestSuite(Project project) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet sourceSet = (SourceSet)sourceSets.maybeCreate(TEST_NAME);
        GradlePluginDevelopmentTestSuiteInternal testSuite = (GradlePluginDevelopmentTestSuiteInternal)project.getObjects().newInstance(GradlePluginDevelopmentTestSuiteInternal.class, new Object[]{TEST_NAME, sourceSet});
        testSuite.getTestedSourceSet().convention(project.provider(() -> (SourceSet)sourceSets.getByName("main")));
        testSuite.getTestedGradlePlugin().set((Object)((GradlePluginDevelopmentCompatibilityExtension)((ExtensionAware)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class)).getExtensions().getByName("compatibility")));
        testSuite.getTestedGradlePlugin().disallowChanges();
        GradlePluginDevelopmentExtension gradlePlugin = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
        HashSet testSourceSets = new HashSet();
        testSourceSets.addAll(gradlePlugin.getTestSourceSets());
        testSourceSets.remove(sourceSet);
        gradlePlugin.testSourceSets(testSourceSets.toArray(new SourceSet[0]));
        GradlePluginDevelopmentDependencyExtensionInternal dependencies = GradlePluginDevelopmentDependencyExtensionInternal.of(project.getDependencies());
        dependencies.add(testSuite.getSourceSet().getImplementationConfigurationName(), (Provider<Object>)((GradlePluginDevelopmentCompatibilityExtension)testSuite.getTestedGradlePlugin().get()).getMinimumGradleVersion().map(dependencies::gradleApi));
        project.getComponents().add((Object)testSuite);
        project.getExtensions().add(GradlePluginDevelopmentTestSuite.class, TEST_NAME, (Object)testSuite);
    }
}

