/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import javax.inject.Inject;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;

public abstract class GroovySpockFrameworkTestSuite
implements SoftwareComponent {
    private String name;
    private final SourceSet sourceSet;
    private final TaskProvider<Test> testTask;

    @Inject
    public GroovySpockFrameworkTestSuite(String name, SourceSet sourceSet, TaskContainer tasks) {
        this.name = name;
        this.sourceSet = sourceSet;
        this.testTask = tasks.register(sourceSet.getName(), Test.class, it -> {
            it.setDescription("Runs the functional tests");
            it.setGroup("verification");
            it.setTestClassesDirs(sourceSet.getOutput().getClassesDirs());
            it.setClasspath(sourceSet.getRuntimeClasspath());
        });
    }

    public String getName() {
        return this.name;
    }

    public SourceSet getSourceSet() {
        return this.sourceSet;
    }

    public TaskProvider<Test> getTestTask() {
        return this.testTask;
    }

    public abstract Property<SourceSet> getTestedSourceSet();

    public abstract Property<String> getSpockVersion();
}

