/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins;

import java.util.Optional;
import org.gradle.api.JavaVersion;
import org.gradle.util.VersionNumber;

public class GradleRuntimeCompatibility {
    public static String groovyVersionOf(String gradleVersion) {
        return GradleRuntimeCompatibility.groovyVersionOf(VersionNumber.parse((String)gradleVersion));
    }

    public static String groovyVersionOf(VersionNumber gradleVersion) {
        switch (String.format("%d.%d", gradleVersion.getMajor(), gradleVersion.getMinor())) {
            case "1.12": {
                return "1.8.6";
            }
            case "2.0": {
                return "2.3.3";
            }
            case "2.1": 
            case "2.2": {
                return "2.3.6";
            }
            case "2.3": {
                return "2.3.9";
            }
            case "2.4": 
            case "2.5": 
            case "2.6": 
            case "2.7": {
                return "2.3.10";
            }
            case "2.8": 
            case "2.9": 
            case "2.10": 
            case "2.11": 
            case "2.12": 
            case "2.13": 
            case "2.14": {
                return "2.4.4";
            }
            case "3.0": 
            case "3.1": 
            case "3.2": 
            case "3.3": 
            case "3.4": {
                return "2.4.7";
            }
            case "3.5": {
                return "2.4.10";
            }
            case "4.0": 
            case "4.1": {
                return "2.4.11";
            }
            case "4.2": 
            case "4.3": 
            case "4.4": 
            case "4.5": 
            case "4.6": 
            case "4.7": 
            case "4.8": 
            case "4.9": {
                return "2.4.12";
            }
            case "4.10": {
                return "2.4.15";
            }
            case "5.0": 
            case "5.1": 
            case "5.2": 
            case "5.3": 
            case "5.4": 
            case "5.5": {
                return "2.5.4";
            }
            case "5.6": {
                return "2.5.4";
            }
            case "6.0": 
            case "6.1": 
            case "6.2": {
                return "2.5.8";
            }
            case "6.3": 
            case "6.4": {
                return "2.5.10";
            }
            case "6.5": {
                return "2.5.11";
            }
            case "6.6": {
                return "2.5.12";
            }
        }
        throw new IllegalArgumentException(String.format("Unknown Groovy version for Gradle '%s', please open an issue on https://github.com/gradle-plugins/toolbox.", gradleVersion.toString()));
    }

    public static JavaVersion minimumJavaVersionFor(String gradleVersion) {
        return GradleRuntimeCompatibility.minimumJavaVersionFor(VersionNumber.parse((String)gradleVersion));
    }

    public static JavaVersion minimumJavaVersionFor(VersionNumber gradleVersion) {
        switch (gradleVersion.getMajor()) {
            case 0: {
                throw new UnsupportedOperationException("Minimum Java version for Gradle version below 1.0 is unavailable, please open an issue on https://github.com/gradle-plugins/toolbox.");
            }
            case 1: {
                return JavaVersion.VERSION_1_5;
            }
            case 2: {
                return JavaVersion.VERSION_1_6;
            }
            case 3: 
            case 4: {
                return JavaVersion.VERSION_1_7;
            }
            case 5: 
            case 6: {
                return JavaVersion.VERSION_1_8;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown minimum Java version for Gradle '%s', please open an issue on https://github.com/gradle-plugins/toolbox.", gradleVersion.toString()));
    }

    public static Optional<String> kotlinVersionOf(String gradleVersion) {
        return GradleRuntimeCompatibility.kotlinVersionOf(VersionNumber.parse((String)gradleVersion));
    }

    public static Optional<String> kotlinVersionOf(VersionNumber gradleVersion) {
        switch (String.format("%d.%d", gradleVersion.getMajor(), gradleVersion.getMinor())) {
            case "2.0": 
            case "2.1": 
            case "2.2": 
            case "2.3": 
            case "2.4": 
            case "2.5": 
            case "2.6": 
            case "2.7": 
            case "2.8": 
            case "2.9": 
            case "2.10": 
            case "2.11": 
            case "2.12": 
            case "2.13": 
            case "2.14": {
                return Optional.empty();
            }
            case "3.0": {
                return Optional.of("1.1-M01");
            }
            case "3.1": 
            case "3.2": {
                return Optional.of("1.1.0-dev-2053");
            }
            case "3.3": 
            case "3.4": {
                return Optional.of("1.1-M02-8");
            }
            case "3.5": 
            case "4.0": {
                return Optional.of("1.1.0");
            }
            case "4.1": {
                return Optional.of("1.1.3-2");
            }
            case "4.2": {
                return Optional.of("1.1.4-3");
            }
            case "4.3": 
            case "4.4": {
                return Optional.of("1.1.51");
            }
            case "4.5": {
                return Optional.of("1.2.0");
            }
            case "4.6": {
                return Optional.of("1.2.21");
            }
            case "4.7": {
                return Optional.of("1.2.31");
            }
            case "4.8": 
            case "4.9": {
                return Optional.of("1.2.41");
            }
            case "4.10": {
                return Optional.of("1.2.61");
            }
            case "5.0": {
                return Optional.of("1.3.10");
            }
            case "5.1": {
                return Optional.of("1.3.11");
            }
            case "5.2": {
                return Optional.of("1.3.20");
            }
            case "5.3": 
            case "5.4": {
                return Optional.of("1.3.21");
            }
            case "5.5": {
                return Optional.of("1.3.31");
            }
            case "5.6": {
                return Optional.of("1.3.41");
            }
            case "6.0": {
                return Optional.of("1.3.50");
            }
            case "6.1": 
            case "6.2": {
                return Optional.of("1.3.61");
            }
            case "6.3": {
                return Optional.of("1.3.70");
            }
            case "6.4": {
                return Optional.of("1.3.71");
            }
            case "6.5": 
            case "6.6": {
                return Optional.of("1.3.72");
            }
        }
        throw new IllegalArgumentException(String.format("Unknown Kotlin version for Gradle '%s', please open an issue on https://github.com/gradle-plugins/toolbox.", gradleVersion.toString()));
    }
}

