/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.GradlePluginDevelopmentCompatibilityExtension;
import dev.gradleplugins.GradlePluginTestingStrategy;
import dev.gradleplugins.internal.DeferredRepositoryFactory;
import dev.gradleplugins.internal.GradlePluginSpockFrameworkTestSuiteInternal;
import dev.gradleplugins.internal.GradlePluginTestingStrategyInternal;
import dev.gradleplugins.internal.ReleasedVersionDistributions;
import dev.gradleplugins.internal.plugins.SpockFrameworkTestSuiteBasePlugin;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;

public abstract class GradlePluginDevelopmentFunctionalTestingPlugin
implements Plugin<Project> {
    private static final String FUNCTIONAL_TEST_NAME = "functionalTest";

    @Inject
    protected abstract TaskContainer getTasks();

    public void apply(Project project) {
        DeferredRepositoryFactory repositoryFactory = (DeferredRepositoryFactory)project.getObjects().newInstance(DeferredRepositoryFactory.class, new Object[]{project});
        project.getPluginManager().apply("groovy-base");
        project.getComponents().withType(GradlePluginSpockFrameworkTestSuiteInternal.class).configureEach(testSuite -> {
            project.afterEvaluate(proj -> {
                testSuite.getTestedSourceSet().disallowChanges();
                if (testSuite.getTestedSourceSet().isPresent()) {
                    SourceSet sourceSet = testSuite.getSourceSet();
                    SourceSet testedSourceSet = (SourceSet)testSuite.getTestedSourceSet().get();
                    sourceSet.setCompileClasspath(sourceSet.getCompileClasspath().plus((FileCollection)testedSourceSet.getOutput()));
                    sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().plus((FileCollection)sourceSet.getOutput()).plus(sourceSet.getCompileClasspath()));
                }
            });
            testSuite.getSpockVersion().convention((Object)"1.2-groovy-2.5").finalizeValueOnRead();
            SpockFrameworkTestSuiteBasePlugin.configureSpockFrameworkProjectDependency(testSuite.getSpockVersion(), testSuite.getSourceSet(), project);
            repositoryFactory.spock();
            SourceSet sourceSet = testSuite.getSourceSet();
            GradlePluginDevelopmentExtension gradlePlugin = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
            gradlePlugin.testSourceSets(new SourceSet[]{sourceSet});
            GradlePluginDevelopmentFunctionalTestingPlugin.configureTestKitProjectDependency(testSuite, project);
            GradlePluginDevelopmentFunctionalTestingPlugin.configureGradleFixturesProjectDependency(testSuite, project, repositoryFactory);
            project.afterEvaluate(proj -> {
                testSuite.getTestingStrategies().disallowChanges();
                Set strategies = (Set)testSuite.getTestingStrategies().get();
                if (strategies.isEmpty()) {
                    TaskProvider<Test> testTask = this.createTestTask((GradlePluginSpockFrameworkTestSuiteInternal)testSuite);
                    testTask.configure(this.applyTestActions((GradlePluginSpockFrameworkTestSuiteInternal)testSuite));
                    this.getTasks().named("check", it -> it.dependsOn(new Object[]{testTask}));
                } else if (strategies.size() == 1) {
                    TaskProvider<Test> testTask = this.createTestTask((GradlePluginSpockFrameworkTestSuiteInternal)testSuite);
                    testTask.configure(this.applyTestActions((GradlePluginSpockFrameworkTestSuiteInternal)testSuite));
                    testTask.configure(this.testingStrategy((GradlePluginSpockFrameworkTestSuiteInternal)testSuite, (GradlePluginTestingStrategyInternal)strategies.iterator().next()));
                    this.getTasks().named("check", it -> it.dependsOn(new Object[]{testTask}));
                } else {
                    for (GradlePluginTestingStrategy strategy : strategies) {
                        TaskProvider<Test> testTask = this.createTestTask((GradlePluginSpockFrameworkTestSuiteInternal)testSuite, ((GradlePluginTestingStrategyInternal)strategy).getName());
                        testTask.configure(this.applyTestActions((GradlePluginSpockFrameworkTestSuiteInternal)testSuite));
                        testTask.configure(this.testingStrategy((GradlePluginSpockFrameworkTestSuiteInternal)testSuite, (GradlePluginTestingStrategyInternal)strategy));
                        this.getTasks().named("check", it -> it.dependsOn(new Object[]{testTask}));
                    }
                }
            });
        });
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        GradlePluginSpockFrameworkTestSuiteInternal functionalTestSuite = (GradlePluginSpockFrameworkTestSuiteInternal)project.getObjects().newInstance(GradlePluginSpockFrameworkTestSuiteInternal.class, new Object[]{FUNCTIONAL_TEST_NAME, sourceSets.maybeCreate(FUNCTIONAL_TEST_NAME)});
        functionalTestSuite.getTestedSourceSet().convention(project.provider(() -> (SourceSet)sourceSets.getByName("main")));
        functionalTestSuite.getTestedGradlePlugin().set((Object)((GradlePluginDevelopmentCompatibilityExtension)((ExtensionAware)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class)).getExtensions().getByName("compatibility")));
        functionalTestSuite.getTestedGradlePlugin().disallowChanges();
        project.getComponents().add((Object)functionalTestSuite);
    }

    private Action<Test> applyTestActions(GradlePluginSpockFrameworkTestSuiteInternal testSuite) {
        return task -> {
            for (Action<? super Test> action : testSuite.getTestTaskActions()) {
                action.execute(task);
            }
        };
    }

    private Action<Test> testingStrategy(GradlePluginSpockFrameworkTestSuiteInternal testSuite, GradlePluginTestingStrategyInternal strategy) {
        return task -> {
            String version;
            switch (strategy.getName()) {
                case "minimumGradle": {
                    version = (String)((GradlePluginDevelopmentCompatibilityExtension)testSuite.getTestedGradlePlugin().get()).getMinimumGradleVersion().get();
                    break;
                }
                case "latestNightly": {
                    version = new ReleasedVersionDistributions().getMostRecentSnapshot().getVersion();
                    break;
                }
                case "latestGlobalAvailable": {
                    version = new ReleasedVersionDistributions().getMostRecentRelease().getVersion();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown testing strategy");
                }
            }
            task.systemProperty("dev.gradleplugins.defaultGradleVersion", (Object)version);
        };
    }

    private TaskProvider<Test> createTestTask(GradlePluginSpockFrameworkTestSuiteInternal testSuite) {
        return this.createTestTask(testSuite, "");
    }

    private TaskProvider<Test> createTestTask(GradlePluginSpockFrameworkTestSuiteInternal testSuite, String variant) {
        SourceSet sourceSet = testSuite.getSourceSet();
        return this.getTasks().register(sourceSet.getName() + StringUtils.capitalize((String)variant), Test.class, it -> {
            it.setDescription("Runs the functional tests");
            it.setGroup("verification");
            it.setTestClassesDirs(sourceSet.getOutput().getClassesDirs());
            it.setClasspath(sourceSet.getRuntimeClasspath());
        });
    }

    private static void configureTestKitProjectDependency(GradlePluginSpockFrameworkTestSuiteInternal testSuite, Project project) {
        project.getDependencies().add(testSuite.getSourceSet().getCompileOnlyConfigurationName(), (Object)project.getDependencies().gradleTestKit());
    }

    private static void configureGradleFixturesProjectDependency(GradlePluginSpockFrameworkTestSuiteInternal testSuite, Project project, DeferredRepositoryFactory repositoryFactory) {
        ModuleDependency dep = (ModuleDependency)project.getDependencies().add(testSuite.getSourceSet().getImplementationConfigurationName(), (Object)"dev.gradleplugins:gradle-fixtures:0.0.74");
        dep.capabilities(h -> h.requireCapability((Object)"dev.gradleplugins:gradle-fixtures-spock-support"));
        repositoryFactory.gradleFixtures();
    }
}

