/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.internal.DeferredRepositoryFactory;
import dev.gradleplugins.internal.GradlePluginDevelopmentExtensionInternal;
import dev.gradleplugins.internal.plugins.GroovyGradlePluginDevelopmentPlugin;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.artifacts.dependencies.SelfResolvingDependencyInternal;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.util.VersionNumber;

public abstract class AbstractGradlePluginDevelopmentPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        AbstractGradlePluginDevelopmentPlugin.assertOtherGradlePluginDevelopmentPluginsAreNeverApplied(project.getPluginManager(), this.getPluginId());
        AbstractGradlePluginDevelopmentPlugin.assertJavaGradlePluginIsNotPreviouslyApplied(project.getPluginManager(), this.getPluginId());
        AbstractGradlePluginDevelopmentPlugin.assertKotlinDslPluginIsNeverApplied(project.getPluginManager(), this.getPluginId());
        this.doApply(project);
    }

    protected abstract void doApply(Project var1);

    protected abstract String getPluginId();

    public static void assertOtherGradlePluginDevelopmentPluginsAreNeverApplied(PluginManager pluginManager, String currentPluginId) {
        AbstractGradlePluginDevelopmentPlugin.getOtherGradlePluginDevelopmentPlugins(currentPluginId).stream().filter(arg_0 -> ((PluginManager)pluginManager).hasPlugin(arg_0)).findAny().ifPresent(id -> {
            throw new GradleException("The '" + currentPluginId + "' cannot be applied with '" + id + "', please apply just one of them.");
        });
    }

    private static List<String> getOtherGradlePluginDevelopmentPlugins(String pluginId) {
        return Stream.of("dev.gradleplugins.java-gradle-plugin", "dev.gradleplugins.groovy-gradle-plugin", "dev.gradleplugins.kotlin-gradle-plugin").filter(it -> !it.equals(pluginId)).collect(Collectors.toList());
    }

    public static void assertJavaGradlePluginIsNotPreviouslyApplied(PluginManager pluginManager, String currentPluginId) {
        if (pluginManager.hasPlugin("java-gradle-plugin") && !pluginManager.hasPlugin("org.gradle.kotlin.kotlin-dsl")) {
            throw new GradleException("The Gradle core plugin 'java-gradle-plugin' should not be applied within your build when using '" + currentPluginId + "'.");
        }
    }

    public static void assertKotlinDslPluginIsNeverApplied(PluginManager pluginManager, String currentPluginId) {
        pluginManager.withPlugin("org.gradle.kotlin.kotlin-dsl", appliedPlugin -> {
            throw new GradleException("The Gradle plugin 'kotlin-dsl' should not be applied within your build when using '" + currentPluginId + "'.");
        });
    }

    private static JavaVersion toMinimumJavaVersion(VersionNumber version) {
        switch (version.getMajor()) {
            case 0: {
                throw new UnsupportedOperationException("I didn't have time to figure out what is the minimum Java version for Gradle version below 1.0. Feel free to open an issue and look into that for me.");
            }
            case 1: {
                return JavaVersion.VERSION_1_5;
            }
            case 2: {
                return JavaVersion.VERSION_1_6;
            }
            case 3: 
            case 4: {
                return JavaVersion.VERSION_1_7;
            }
            case 5: 
            case 6: {
                return JavaVersion.VERSION_1_8;
            }
        }
        throw new IllegalArgumentException("Version not known at the time, please check what Java version is supported");
    }

    public static void configureDefaultJavaCompatibility(JavaPluginExtension java, VersionNumber minimumGradleVersion) {
        JavaVersion minimumJavaVersion = AbstractGradlePluginDevelopmentPlugin.toMinimumJavaVersion(minimumGradleVersion);
        java.setSourceCompatibility(minimumJavaVersion);
        java.setTargetCompatibility(minimumJavaVersion);
    }

    public static <T> GradlePluginDevelopmentExtensionInternal registerExtraExtension(Project project, Class<T> type) {
        GradlePluginDevelopmentExtension gradlePlugin = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
        GradlePluginDevelopmentExtensionInternal extension = (GradlePluginDevelopmentExtensionInternal)project.getObjects().newInstance(GradlePluginDevelopmentExtensionInternal.class, new Object[]{project.getExtensions().getByType(JavaPluginExtension.class)});
        ((ExtensionAware)gradlePlugin).getExtensions().add("extra", (Object)extension);
        return extension;
    }

    public static void removeGradleApiProjectDependency(Project project) {
        project.getConfigurations().getByName("api").getDependencies().removeIf(it -> {
            if (it instanceof SelfResolvingDependencyInternal) {
                return ((SelfResolvingDependencyInternal)it).getTargetComponentId().getDisplayName().equals("Gradle API");
            }
            return false;
        });
    }

    public static void configureGradleApiDependencies(Project project, Provider<String> minimumGradleVersion) {
        project.afterEvaluate(proj -> {
            project.getDependencies().constraints(constraints -> constraints.create((Object)("org.codehaus.groovy:groovy-all:" + GroovyGradlePluginDevelopmentPlugin.toGroovyVersion(VersionNumber.parse((String)((String)minimumGradleVersion.get()))))));
            project.getDependencies().add("compileOnly", (Object)("dev.gradleplugins:gradle-api:" + (String)minimumGradleVersion.get()));
        });
    }

    public static void configureExtension(GradlePluginDevelopmentExtensionInternal extension, Project project, DeferredRepositoryFactory repositoryFactory) {
        project.afterEvaluate(proj -> {
            if (extension.getMinimumGradleVersion().isPresent()) {
                AbstractGradlePluginDevelopmentPlugin.configureDefaultJavaCompatibility((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class), VersionNumber.parse((String)((String)extension.getMinimumGradleVersion().get())));
            } else {
                extension.getMinimumGradleVersion().set((Object)project.getGradle().getGradleVersion());
            }
            extension.getMinimumGradleVersion().disallowChanges();
        });
        AbstractGradlePluginDevelopmentPlugin.configureGradleApiDependencies(project, extension.getMinimumGradleVersion());
        repositoryFactory.gradleApi();
    }
}

