/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.GroovyGradlePluginDevelopmentExtension;
import dev.gradleplugins.internal.DeferredRepositoryFactory;
import dev.gradleplugins.internal.GradlePluginDevelopmentExtensionInternal;
import dev.gradleplugins.internal.plugins.AbstractGradlePluginDevelopmentPlugin;
import dev.gradleplugins.internal.plugins.GradlePluginDevelopmentFunctionalTestingPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.util.VersionNumber;

public class GroovyGradlePluginDevelopmentPlugin
implements Plugin<Project> {
    private static final String PLUGIN_ID = "dev.gradleplugins.groovy-gradle-plugin";

    public void apply(Project project) {
        AbstractGradlePluginDevelopmentPlugin.assertOtherGradlePluginDevelopmentPluginsAreNeverApplied(project.getPluginManager(), PLUGIN_ID);
        AbstractGradlePluginDevelopmentPlugin.assertJavaGradlePluginIsNotPreviouslyApplied(project.getPluginManager(), PLUGIN_ID);
        AbstractGradlePluginDevelopmentPlugin.assertKotlinDslPluginIsNeverApplied(project.getPluginManager(), PLUGIN_ID);
        DeferredRepositoryFactory repositoryFactory = (DeferredRepositoryFactory)project.getObjects().newInstance(DeferredRepositoryFactory.class, new Object[]{project});
        project.getPluginManager().apply("java-gradle-plugin");
        AbstractGradlePluginDevelopmentPlugin.removeGradleApiProjectDependency(project);
        project.getPluginManager().apply("groovy-base");
        GradlePluginDevelopmentExtensionInternal extension = AbstractGradlePluginDevelopmentPlugin.registerExtraExtension(project, GroovyGradlePluginDevelopmentExtension.class);
        AbstractGradlePluginDevelopmentPlugin.configureExtension(extension, project, repositoryFactory);
        project.getPluginManager().apply(GradlePluginDevelopmentFunctionalTestingPlugin.class);
        project.afterEvaluate(proj -> project.getDependencies().add("compileOnly", (Object)("org.codehaus.groovy:groovy-all:" + (String)extension.getMinimumGradleVersion().map(VersionNumber::parse).map(GroovyGradlePluginDevelopmentPlugin::toGroovyVersion).get())));
        repositoryFactory.groovy();
    }

    public static String toGroovyVersion(VersionNumber version) {
        switch (String.format("%d.%d", version.getMajor(), version.getMinor())) {
            case "1.12": {
                return "1.8.6";
            }
            case "2.14": {
                return "2.4.4";
            }
            case "3.0": {
                return "2.4.7";
            }
            case "3.5": {
                return "2.4.10";
            }
            case "4.0": {
                return "2.4.11";
            }
            case "4.3": {
                return "2.4.12";
            }
            case "5.0": 
            case "5.1": 
            case "5.2": 
            case "5.3": 
            case "5.4": 
            case "5.5": {
                return "2.5.4";
            }
            case "5.6": {
                return "2.5.4";
            }
            case "6.0": 
            case "6.1": 
            case "6.2": {
                return "2.5.8";
            }
            case "6.3": 
            case "6.4": {
                return "2.5.10";
            }
            case "6.5": {
                return "2.5.11";
            }
        }
        throw new IllegalArgumentException("Version not known at the time, please check groovy-all version");
    }
}

