/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.internal.DeferredRepositoryFactory;
import dev.gradleplugins.internal.GroovySpockFrameworkTestSuite;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class SpockFrameworkTestSuiteBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        TaskContainer tasks = project.getTasks();
        DeferredRepositoryFactory repositoryFactory = (DeferredRepositoryFactory)project.getObjects().newInstance(DeferredRepositoryFactory.class, new Object[]{project});
        project.getPluginManager().apply("groovy-base");
        project.getComponents().withType(GroovySpockFrameworkTestSuite.class, testSuite -> {
            tasks.named("check", it -> it.dependsOn(new Object[]{testSuite.getTestTask()}));
            project.afterEvaluate(proj -> {
                testSuite.getTestedSourceSet().disallowChanges();
                if (testSuite.getTestedSourceSet().isPresent()) {
                    SourceSet sourceSet = testSuite.getSourceSet();
                    SourceSet testedSourceSet = (SourceSet)testSuite.getTestedSourceSet().get();
                    sourceSet.setCompileClasspath(sourceSet.getCompileClasspath().plus((FileCollection)testedSourceSet.getOutput()));
                    sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().plus((FileCollection)sourceSet.getOutput()).plus(sourceSet.getCompileClasspath()));
                }
            });
            testSuite.getSpockVersion().convention((Object)"1.2-groovy-2.5");
            SpockFrameworkTestSuiteBasePlugin.configureSpockFrameworkProjectDependency(testSuite, project);
            repositoryFactory.spock();
        });
    }

    private static void configureSpockFrameworkProjectDependency(GroovySpockFrameworkTestSuite testSuite, Project project) {
        project.afterEvaluate(proj -> {
            testSuite.getSpockVersion().disallowChanges();
            project.getDependencies().add(testSuite.getSourceSet().getImplementationConfigurationName(), (Object)"org.codehaus.groovy:groovy-all:2.5.10");
            project.getDependencies().add(testSuite.getSourceSet().getImplementationConfigurationName(), (Object)project.getDependencies().platform((Object)("org.spockframework:spock-bom:" + (String)testSuite.getSpockVersion().get())));
            project.getDependencies().add(testSuite.getSourceSet().getImplementationConfigurationName(), (Object)"org.spockframework:spock-core");
        });
    }
}

