/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.internal.DeferredRepositoryFactory;
import dev.gradleplugins.internal.GroovyGradlePluginSpockTestSuite;
import dev.gradleplugins.internal.plugins.SpockFrameworkTestSuiteBasePlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;

public class GradlePluginDevelopmentFunctionalTestingPlugin
implements Plugin<Project> {
    private static final String FUNCTIONAL_TEST_NAME = "functionalTest";

    public void apply(Project project) {
        DeferredRepositoryFactory repositoryFactory = (DeferredRepositoryFactory)project.getObjects().newInstance(DeferredRepositoryFactory.class, new Object[]{project});
        project.getPluginManager().apply("groovy-base");
        project.getPluginManager().apply(SpockFrameworkTestSuiteBasePlugin.class);
        project.getComponents().withType(GroovyGradlePluginSpockTestSuite.class, testSuite -> {
            SourceSet sourceSet = testSuite.getSourceSet();
            GradlePluginDevelopmentExtension gradlePlugin = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
            gradlePlugin.testSourceSets(new SourceSet[]{sourceSet});
            GradlePluginDevelopmentFunctionalTestingPlugin.configureTestKitProjectDependency(testSuite, project);
            GradlePluginDevelopmentFunctionalTestingPlugin.configureGradleFixturesProjectDependency(testSuite, project, repositoryFactory);
        });
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        GroovyGradlePluginSpockTestSuite functionalTestSuite = (GroovyGradlePluginSpockTestSuite)project.getObjects().newInstance(GroovyGradlePluginSpockTestSuite.class, new Object[]{FUNCTIONAL_TEST_NAME, sourceSets.maybeCreate(FUNCTIONAL_TEST_NAME)});
        functionalTestSuite.getTestedSourceSet().convention(project.provider(() -> (SourceSet)sourceSets.getByName("main")));
        project.getComponents().add((Object)functionalTestSuite);
    }

    private static void configureTestKitProjectDependency(GroovyGradlePluginSpockTestSuite testSuite, Project project) {
        project.getDependencies().add(testSuite.getSourceSet().getCompileOnlyConfigurationName(), (Object)project.getDependencies().gradleTestKit());
    }

    private static void configureGradleFixturesProjectDependency(GroovyGradlePluginSpockTestSuite testSuite, Project project, DeferredRepositoryFactory repositoryFactory) {
        ModuleDependency dep = (ModuleDependency)project.getDependencies().add(testSuite.getSourceSet().getImplementationConfigurationName(), (Object)"dev.gradleplugins:gradle-fixtures:0.0.36");
        dep.capabilities(h -> h.requireCapability((Object)"dev.gradleplugins:gradle-fixtures-spock-support"));
        repositoryFactory.gradleFixtures();
    }
}

