/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.internal.GroovyGradlePluginSpockTestSuite;
import dev.gradleplugins.internal.GroovySpockFrameworkTestSuite;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;

public class SpockFrameworkTestSuiteBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply("groovy-base");
        project.getComponents().withType(GroovySpockFrameworkTestSuite.class, testSuite -> {
            SourceSet sourceSet = this.maybeCreateSourceSet((GroovySpockFrameworkTestSuite)testSuite, project);
            this.createAndAttachTestTask((GroovySpockFrameworkTestSuite)testSuite, sourceSet, project);
            SpockFrameworkTestSuiteBasePlugin.configureSpockFrameworkProjectDependency(testSuite, sourceSet, project);
        });
        project.getComponents().withType(GroovyGradlePluginSpockTestSuite.class, testSuite -> {
            SourceSet sourceSet = this.maybeCreateSourceSet((GroovySpockFrameworkTestSuite)testSuite, project);
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            sourceSet.setCompileClasspath(sourceSet.getCompileClasspath().plus((FileCollection)((SourceSet)sourceSets.getByName("main")).getOutput()));
            sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().plus((FileCollection)sourceSet.getOutput()).plus(sourceSet.getCompileClasspath()));
            GradlePluginDevelopmentExtension gradlePlugin = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
            gradlePlugin.testSourceSets(new SourceSet[]{sourceSet});
            SpockFrameworkTestSuiteBasePlugin.configureTestKitProjectDependency(testSuite, sourceSet, project);
            SpockFrameworkTestSuiteBasePlugin.configureGradleFixturesProjectDependency(testSuite, sourceSet, project);
        });
    }

    private static void configureTestKitProjectDependency(GroovyGradlePluginSpockTestSuite testSuite, SourceSet sourceSet, Project project) {
        project.getConfigurations().matching(it -> it.getName().equals(sourceSet.getImplementationConfigurationName())).configureEach(it -> project.getDependencies().add(it.getName(), (Object)project.getDependencies().gradleTestKit()));
    }

    private static void configureSpockFrameworkProjectDependency(GroovySpockFrameworkTestSuite testSuite, SourceSet sourceSet, Project project) {
        String groupId = "org.spockframework";
        String artifactId = "spock-core";
        String version = "1.2-groovy-2.5";
        project.getConfigurations().matching(it -> it.getName().equals(sourceSet.getImplementationConfigurationName())).configureEach(it -> {});
        project.getDependencies().add(sourceSet.getImplementationConfigurationName(), (Object)(groupId + ":" + artifactId + ":" + version));
        project.getRepositories().mavenCentral(repository -> {
            repository.setName("Gradle Plugin Development - Spock Framework");
            repository.mavenContent(content -> {
                content.includeVersion("org.spockframework", "spock-core", "1.2-groovy-2.5");
                content.includeVersion("junit", "junit", "4.12");
                content.includeVersion("org.hamcrest", "hamcrest-core", "1.3");
                content.includeVersionByRegex("org.codehaus.groovy", "groovy.*", "2\\.5\\.2");
            });
        });
    }

    private static void configureGradleFixturesProjectDependency(GroovyGradlePluginSpockTestSuite testSuite, SourceSet sourceSet, Project project) {
        SpockFrameworkTestSuiteBasePlugin.configureProjectDependency(project, "Gradle Fixtures", sourceSet.getImplementationConfigurationName(), "dev.gradleplugins", "gradle-fixtures", "0.0.22");
        SpockFrameworkTestSuiteBasePlugin.configureProjectDependency(project, "Spock Fixtures for Gradle", sourceSet.getImplementationConfigurationName(), "dev.gradleplugins", "spock-gradle-fixtures", "0.0.22");
    }

    private static void configureProjectDependency(Project project, String repositoryDisplayName, String configurationName, String groupId, String artifactId, String version) {
        project.getConfigurations().matching(it -> it.getName().equals(configurationName)).configureEach(it -> project.getDependencies().add(it.getName(), (Object)(groupId + ":" + artifactId + ":" + version)));
        project.getRepositories().maven(repository -> {
            repository.setName("Gradle Plugins Development - " + repositoryDisplayName);
            repository.setUrl(project.uri((Object)"https://dl.bintray.com/gradle-plugins/maven"));
            repository.mavenContent(content -> content.includeVersion(groupId, artifactId, version));
        });
    }

    private SourceSet maybeCreateSourceSet(GroovySpockFrameworkTestSuite testSuite, Project project) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet sourceSet = (SourceSet)sourceSets.findByName(testSuite.getName());
        if (sourceSet == null) {
            sourceSet = (SourceSet)sourceSets.create(testSuite.getName(), it -> {
                GroovySourceSet groovyIt = (GroovySourceSet)new DslObject(it).getConvention().getPlugin(GroovySourceSet.class);
                groovyIt.getGroovy().srcDir((Object)("src/" + testSuite.getName() + "/groovy"));
                it.getResources().srcDir((Object)("src/" + testSuite.getName() + "/resources"));
                it.setRuntimeClasspath(it.getRuntimeClasspath().plus((FileCollection)it.getOutput()).plus(it.getCompileClasspath()));
            });
        }
        return sourceSet;
    }

    private TaskProvider<Test> createAndAttachTestTask(GroovySpockFrameworkTestSuite testSuite, SourceSet sourceSet, Project project) {
        TaskProvider testTask = project.getTasks().register(sourceSet.getName(), Test.class, it -> {
            it.setDescription("Runs the functional tests");
            it.setGroup("verification");
            it.setTestClassesDirs(sourceSet.getOutput().getClassesDirs());
            it.setClasspath(sourceSet.getRuntimeClasspath());
        });
        project.getTasks().named("check", it -> it.dependsOn(new Object[]{testTask}));
        return testTask;
    }
}

