/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import dev.gradleplugins.test.fixtures.Pair;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.DependencyResolutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.DetailedExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.LogContent;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.OutputScrapingExecutionResult;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import org.gradle.util.TextUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class OutputScrapingExecutionFailure
extends OutputScrapingExecutionResult
implements ExecutionFailure {
    private static final Pattern FAILURE_PATTERN = Pattern.compile("FAILURE: (.+)");
    private static final Pattern CAUSE_PATTERN = Pattern.compile("(?m)(^\\s*> )");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(?ms)^\\* What went wrong:$(.+?)^\\* Try:$");
    private static final Pattern LOCATION_PATTERN = Pattern.compile("(?ms)^\\* Where:((.+?)'.+?') line: (\\d+)$");
    private static final Pattern RESOLUTION_PATTERN = Pattern.compile("(?ms)^\\* Try:$(.+?)^\\* Exception is:$");
    private final String summary;
    private final List<Problem> problems = new ArrayList<Problem>();
    private final List<Problem> problemsNotChecked = new ArrayList<Problem>();
    private final List<String> lineNumbers = new ArrayList<String>();
    private final List<String> fileNames = new ArrayList<String>();
    private final String resolution;
    private final LogContent mainContent;

    static boolean hasFailure(String error) {
        return FAILURE_PATTERN.matcher(error).find();
    }

    public static OutputScrapingExecutionFailure from(String output, String error) {
        return new OutputScrapingExecutionFailure(output, error, true);
    }

    protected OutputScrapingExecutionFailure(String output, String error, boolean includeBuildSrc) {
        super(LogContent.of(output), LogContent.of(error), includeBuildSrc);
        LogContent withoutDebug = LogContent.of(output).ansiCharsToPlainText().removeDebugPrefix();
        Pair<LogContent, LogContent> match = withoutDebug.splitOnFirstMatchingLine(FAILURE_PATTERN);
        if (match == null) {
            match = LogContent.of(error).ansiCharsToPlainText().removeDebugPrefix().splitOnFirstMatchingLine(FAILURE_PATTERN);
            match = match != null ? Pair.of(withoutDebug, match.getRight()) : Pair.of(withoutDebug, LogContent.empty());
        } else if (match.getRight().countMatches(FAILURE_PATTERN) != 1) {
            throw new IllegalArgumentException("Found multiple failure sections in log output: " + output);
        }
        LogContent failureContent = match.getRight();
        this.mainContent = (LogContent)match.getLeft();
        String failureText = failureContent.withNormalizedEol();
        java.util.regex.Matcher matcher = FAILURE_PATTERN.matcher(failureText);
        this.summary = matcher.lookingAt() ? matcher.group(1) : "";
        matcher = LOCATION_PATTERN.matcher(failureText);
        while (matcher.find()) {
            this.fileNames.add(matcher.group(1).trim());
            this.lineNumbers.add(matcher.group(3));
        }
        matcher = DESCRIPTION_PATTERN.matcher(failureText);
        while (matcher.find()) {
            String problemStr = matcher.group(1);
            Problem problem = this.extract(problemStr);
            this.problems.add(problem);
            this.problemsNotChecked.add(problem);
        }
        matcher = RESOLUTION_PATTERN.matcher(failureText);
        this.resolution = !matcher.find() ? "" : matcher.group(1).trim();
    }

    @Override
    public ExecutionFailure getIgnoreBuildSrc() {
        return new OutputScrapingExecutionFailure(this.getOutput(), this.getError(), false);
    }

    @Override
    public LogContent getMainContent() {
        return this.mainContent;
    }

    private Problem extract(String problem) {
        String description;
        java.util.regex.Matcher matcher = CAUSE_PATTERN.matcher(problem);
        ArrayList<String> causes = new ArrayList<String>();
        if (!matcher.find()) {
            description = TextUtil.normaliseLineSeparators((String)problem.trim());
        } else {
            String cause;
            String prefixPattern;
            int pos;
            description = TextUtil.normaliseLineSeparators((String)problem.substring(0, matcher.start()).trim());
            while (true) {
                pos = matcher.end();
                int prefix = matcher.group(1).length();
                prefixPattern = this.toPrefixPattern(prefix);
                if (!matcher.find(pos)) break;
                cause = TextUtil.normaliseLineSeparators((String)problem.substring(pos, matcher.start()).trim().replaceAll(prefixPattern, ""));
                causes.add(cause);
            }
            cause = TextUtil.normaliseLineSeparators((String)problem.substring(pos).trim().replaceAll(prefixPattern, ""));
            causes.add(cause);
        }
        return new Problem(description, causes);
    }

    private String toPrefixPattern(int prefix) {
        StringBuilder builder = new StringBuilder("(?m)^");
        for (int i = 0; i < prefix; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    public ExecutionFailure assertHasLineNumber(int lineNumber) {
        Assert.assertThat(this.lineNumbers, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.equalTo((Object)String.valueOf(lineNumber))));
        return this;
    }

    public ExecutionFailure assertHasFileName(String filename) {
        Assert.assertThat(this.fileNames, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.equalTo((Object)filename)));
        return this;
    }

    public ExecutionFailure assertHasFailures(int count) {
        this.problemsNotChecked.clear();
        Assert.assertThat((Object)this.problems.size(), (Matcher)CoreMatchers.equalTo((Object)count));
        if (count == 1) {
            MatcherAssert.assertThat((Object)this.summary, (Matcher)CoreMatchers.equalTo((Object)"Build failed with an exception."));
        } else {
            Assert.assertThat((Object)this.summary, (Matcher)CoreMatchers.equalTo((Object)String.format("Build completed with %s failures.", count)));
        }
        return this;
    }

    @Override
    public ExecutionFailure assertHasCause(String description) {
        this.assertThatCause((Matcher<? super String>)CoreMatchers.startsWith((String)description));
        return this;
    }

    @Override
    public ExecutionFailure assertThatCause(Matcher<? super String> matcher) {
        LinkedHashSet<String> seen = new LinkedHashSet<String>();
        for (Problem problem : this.problems) {
            for (String cause : problem.causes) {
                if (matcher.matches((Object)cause)) {
                    this.problemsNotChecked.remove(problem);
                    return this;
                }
                seen.add(cause);
            }
        }
        this.failureOnUnexpectedOutput(String.format("No matching cause found in %s", seen));
        return this;
    }

    public ExecutionFailure assertHasResolution(String resolution) {
        Assert.assertThat((Object)this.resolution, (Matcher)CoreMatchers.containsString((String)resolution));
        return this;
    }

    public ExecutionFailure assertHasNoCause(String description) {
        Matcher matcher = CoreMatchers.containsString((String)description);
        for (Problem problem : this.problems) {
            for (String cause : problem.causes) {
                if (!matcher.matches((Object)cause)) continue;
                this.failureOnUnexpectedOutput(String.format("Expected no failure with description '%s', found: %s", description, cause));
            }
        }
        return this;
    }

    public ExecutionFailure assertHasNoCause() {
        for (Problem problem : this.problems) {
            if (problem.causes.isEmpty()) continue;
            this.failureOnUnexpectedOutput(String.format("Expected no failure with a cause, found: %s", problem.causes.get(0)));
        }
        return this;
    }

    @Override
    public ExecutionFailure assertHasDescription(String context) {
        this.assertThatDescription((Matcher<? super String>)CoreMatchers.startsWith((String)context));
        return this;
    }

    public ExecutionFailure assertThatDescription(Matcher<? super String> matcher) {
        this.assertHasFailure(matcher, (? super ExecutionFailure.Failure f) -> {});
        return this;
    }

    public ExecutionFailure assertHasFailure(String description, Consumer<? super ExecutionFailure.Failure> action) {
        this.assertHasFailure((Matcher<? super String>)CoreMatchers.startsWith((String)description), action);
        return this;
    }

    private void assertHasFailure(Matcher<? super String> matcher, Consumer<? super ExecutionFailure.Failure> action) {
        LinkedHashSet<String> seen = new LinkedHashSet<String>();
        for (Problem problem : this.problems) {
            if (matcher.matches((Object)problem.description)) {
                this.problemsNotChecked.remove(problem);
                action.accept(problem);
                return;
            }
            seen.add(problem.description);
        }
        this.failureOnUnexpectedOutput(String.format("No matching failure description found in %s", seen));
    }

    public ExecutionFailure assertTestsFailed() {
        new DetailedExecutionFailure(this).assertTestsFailed();
        return this;
    }

    public DependencyResolutionFailure assertResolutionFailure(String configurationPath) {
        return new DependencyResolutionFailure(this, configurationPath);
    }

    @Override
    public void assertResultVisited() {
        super.assertResultVisited();
        if (this.problems.size() > 1 && !this.problemsNotChecked.isEmpty()) {
            throw new AssertionFailedError("The build failed with multiple exceptions, however not all exceptions where checked during the test. This can be done using assertHasFailures(n), assertHasDescription() or assertHasCause() or one of the variants of these methods.");
        }
    }

    private static class Problem
    implements ExecutionFailure.Failure {
        final String description;
        final List<String> causes;

        private Problem(String description, List<String> causes) {
            this.description = description;
            this.causes = causes;
        }

        @Override
        public void assertHasCauses(int count) {
            assert (this.causes.size() == count);
        }
    }
}

