/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import dev.gradleplugins.test.fixtures.Pair;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.rubygrapefruit.ansi.AnsiParser;
import net.rubygrapefruit.ansi.Visitor;
import net.rubygrapefruit.ansi.console.AnsiConsole;
import net.rubygrapefruit.ansi.console.DiagnosticConsole;
import net.rubygrapefruit.ansi.token.NewLine;
import net.rubygrapefruit.ansi.token.Text;
import net.rubygrapefruit.ansi.token.Token;

public class LogContent {
    private static final Pattern DEBUG_PREFIX = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}\\+\\d{4} \\[\\w+] \\[.+?] ");
    private static final Pattern JAVA_ILLEGAL_ACCESS_WARNING_PATTERN = Pattern.compile("(?ms)WARNING: An illegal reflective access operation has occurred$.+?^WARNING: All illegal access operations will be denied in a future release\r?\n");
    private final List<String> lines;
    private final boolean definitelyNoDebugPrefix;
    private final boolean definitelyNoAnsiChars;
    private final LogContent rawContent;

    private LogContent(List<String> lines, boolean definitelyNoDebugPrefix, boolean definitelyNoAnsiChars, LogContent rawContent) {
        this.lines = lines;
        this.rawContent = rawContent == null ? this : rawContent;
        this.definitelyNoDebugPrefix = definitelyNoDebugPrefix || lines.isEmpty();
        this.definitelyNoAnsiChars = definitelyNoAnsiChars || lines.isEmpty();
    }

    public static LogContent of(String chars) {
        LogContent raw = new LogContent(LogContent.toLines(chars), false, false, null);
        return new LogContent(LogContent.toLines(LogContent.stripJavaIllegalAccessWarnings(chars)), false, false, raw);
    }

    private static List<String> toLines(String chars) {
        ArrayList<String> lines = new ArrayList<String>();
        int pos = 0;
        while (pos < chars.length()) {
            int next = chars.indexOf(10, pos);
            if (next < 0) {
                lines.add(chars.substring(pos));
                pos = chars.length();
                continue;
            }
            if (next > pos && chars.charAt(next - 1) == '\r') {
                lines.add(chars.substring(pos, next - 1));
                pos = next + 1;
            } else {
                lines.add(chars.substring(pos, next));
                pos = next + 1;
            }
            if (pos != chars.length()) continue;
            lines.add("");
        }
        return Collections.unmodifiableList(lines);
    }

    public static LogContent of(List<String> lines) {
        return new LogContent(Collections.unmodifiableList(lines), false, false, null);
    }

    public static LogContent empty() {
        return new LogContent(Collections.emptyList(), true, true, null);
    }

    public String toString() {
        return this.lines.toString();
    }

    public String withNormalizedEol() {
        if (this.lines.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"\n", this.lines);
    }

    public List<String> getLines() {
        return this.lines;
    }

    public void eachLine(Consumer<? super String> action) {
        for (String line : this.lines) {
            action.accept(line);
        }
    }

    @Nullable
    public Pair<LogContent, LogContent> splitOnFirstMatchingLine(Pattern pattern) {
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            if (!pattern.matcher(line).matches()) continue;
            LogContent before = new LogContent(this.lines.subList(0, i), this.definitelyNoDebugPrefix, this.definitelyNoAnsiChars, this.rawContent);
            LogContent after = new LogContent(this.lines.subList(i, this.lines.size()), this.definitelyNoDebugPrefix, this.definitelyNoAnsiChars, this.rawContent);
            return Pair.of(before, after);
        }
        return null;
    }

    public int countMatches(Pattern pattern) {
        int count = 0;
        for (String line : this.lines) {
            if (!pattern.matcher(line).matches()) continue;
            ++count;
        }
        return count;
    }

    public LogContent drop(int i) {
        return new LogContent(this.lines.subList(i, this.lines.size()), this.definitelyNoDebugPrefix, this.definitelyNoAnsiChars, this.rawContent);
    }

    public LogContent removeDebugPrefix() {
        if (this.definitelyNoDebugPrefix) {
            return this;
        }
        ArrayList<String> result = new ArrayList<String>(this.lines.size());
        for (String line : this.lines) {
            Matcher matcher = DEBUG_PREFIX.matcher(line);
            if (matcher.lookingAt()) {
                result.add(line.substring(matcher.end()));
                continue;
            }
            result.add(line);
        }
        return new LogContent(Collections.unmodifiableList(result), true, this.definitelyNoAnsiChars, this.rawContent);
    }

    public LogContent ansiCharsToPlainText() {
        if (this.definitelyNoAnsiChars) {
            return this;
        }
        try {
            AnsiConsole console = this.interpretAnsiChars();
            StringBuilder result = new StringBuilder();
            console.contents(token -> {
                if (token instanceof Text) {
                    result.append(((Text)token).getText());
                } else if (token instanceof NewLine) {
                    result.append("\n");
                }
            });
            return new LogContent(LogContent.toLines(result.toString()), this.definitelyNoDebugPrefix, true, this.rawContent);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public LogContent ansiCharsToColorText() {
        if (this.definitelyNoAnsiChars) {
            return this;
        }
        try {
            AnsiConsole console = this.interpretAnsiChars();
            DiagnosticConsole diagnosticConsole = new DiagnosticConsole();
            for (int i = 0; i < console.getRows().size(); ++i) {
                AnsiConsole.Row row = (AnsiConsole.Row)console.getRows().get(i);
                if (i > 0) {
                    diagnosticConsole.visit((Token)NewLine.INSTANCE);
                }
                row.visit((Visitor)diagnosticConsole);
            }
            return new LogContent(LogContent.toLines(diagnosticConsole.toString()), this.definitelyNoDebugPrefix, true, this.rawContent);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private AnsiConsole interpretAnsiChars() throws IOException {
        AnsiConsole console = new AnsiConsole();
        AnsiParser parser = new AnsiParser();
        OutputStreamWriter writer = new OutputStreamWriter(parser.newParser("utf-8", (Visitor)console));
        for (int i = 0; i < this.lines.size(); ++i) {
            if (i > 0) {
                writer.write("\n");
            }
            writer.write(this.lines.get(i));
        }
        ((Writer)writer).flush();
        return console;
    }

    public static String stripJavaIllegalAccessWarnings(String result) {
        return JAVA_ILLEGAL_ACCESS_WARNING_PATTERN.matcher(result).replaceAll("");
    }
}

