/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionResult;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.AbstractGradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecuterBuildContext;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecuterConfiguration;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.LogContent;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.OutputCapturer;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.OutputScrapingExecutionResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;

public class GradleWrapperExecuter
extends AbstractGradleExecuter {
    public GradleWrapperExecuter(GradleDistribution distribution, TestFile testDirectory, GradleExecuterBuildContext buildContext) {
        super(distribution, testDirectory, buildContext);
    }

    private GradleWrapperExecuter(TestFile testDirectory, GradleExecuterConfiguration configuration) {
        super(testDirectory, configuration);
    }

    @Override
    protected GradleExecuter newInstance(TestFile testDirectory, GradleExecuterConfiguration configuration) {
        return new GradleWrapperExecuter(testDirectory, configuration);
    }

    @Override
    public GradleExecuter requireGradleDistribution() {
        return this;
    }

    @Override
    public boolean usesGradleDistribution() {
        return true;
    }

    @Override
    protected ExecutionResult doRun() {
        try {
            ArrayList<String> command = new ArrayList<String>();
            if (SystemUtils.IS_OS_WINDOWS) {
                command.addAll(Arrays.asList("cmd", "/c", "gradlew.bat"));
            } else {
                command.add("./gradlew");
            }
            command.addAll(this.getAllArguments());
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(command).directory(this.getWorkingDirectory());
            if (!this.configuration.getEnvironment().isEmpty()) {
                processBuilder.environment().putAll(this.configuration.getEnvironment().entrySet().stream().map(it -> new AbstractMap.SimpleEntry(it.getKey(), it.getValue().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
            OutputCapturer standardOutputCapturer = GradleWrapperExecuter.outputCapturerFor(System.out, Charset.defaultCharset());
            OutputCapturer errorOutputCapturer = GradleWrapperExecuter.outputCapturerFor(System.err, Charset.defaultCharset());
            Process process = processBuilder.start();
            Thread outStream = new Thread(new StreamRunner(process.getInputStream(), standardOutputCapturer.getOutputStream()));
            Thread inStream = new Thread(new StreamRunner(process.getErrorStream(), errorOutputCapturer.getOutputStream()));
            outStream.start();
            inStream.start();
            if (0 != process.waitFor()) {
                throw new RuntimeException("Build failure (" + process.exitValue() + ")");
            }
            outStream.join();
            inStream.join();
            return new OutputScrapingExecutionResult(LogContent.of(standardOutputCapturer.getOutputAsString()), LogContent.of(errorOutputCapturer.getOutputAsString()), true);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static OutputCapturer outputCapturerFor(PrintStream stream, Charset outputEncoding) {
        return new OutputCapturer(stream, outputEncoding);
    }

    @Override
    protected ExecutionFailure doRunWithFailure() {
        return null;
    }

    @Override
    public GradleExecuter withDebuggerAttached() {
        return null;
    }

    @Override
    public GradleExecuter withPluginClasspath() {
        return null;
    }

    private static class StreamRunner
    implements Runnable {
        private final InputStream inputStream;
        private final OutputStream outputStream;

        public StreamRunner(InputStream inputStream, OutputStream outputStream) {
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            try {
                IOUtils.copy((InputStream)this.inputStream, (OutputStream)this.outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

