/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonLogsAnalyzer;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionResult;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecuterBuildContext;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecuterConfiguration;
import dev.gradleplugins.test.fixtures.gradle.logging.ConsoleOutput;
import dev.gradleplugins.test.fixtures.scan.GradleEnterpriseBuildScan;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;

public abstract class AbstractGradleExecuter
implements GradleExecuter {
    protected GradleExecuterConfiguration configuration;
    private final TestFile testDirectory;

    public AbstractGradleExecuter(@NonNull GradleDistribution distribution, @NonNull TestFile testDirectory, @NonNull GradleExecuterBuildContext buildContext) {
        this(testDirectory, new GradleExecuterConfiguration(distribution, buildContext).withGradleUserHomeDirectory(buildContext.getGradleUserHomeDirectory()).withDaemonBaseDirectory(buildContext.getDaemonBaseDirectory()));
        if (distribution == null) {
            throw new NullPointerException("distribution is marked non-null but is null");
        }
        if (testDirectory == null) {
            throw new NullPointerException("testDirectory is marked non-null but is null");
        }
        if (buildContext == null) {
            throw new NullPointerException("buildContext is marked non-null but is null");
        }
    }

    protected AbstractGradleExecuter(TestFile testDirectory, GradleExecuterConfiguration configuration) {
        this.configuration = configuration;
        this.testDirectory = testDirectory;
    }

    protected GradleExecuter newInstance(GradleExecuterConfiguration configuration) {
        return this.newInstance(this.testDirectory, configuration);
    }

    protected abstract GradleExecuter newInstance(TestFile var1, GradleExecuterConfiguration var2);

    @Override
    public GradleDistribution getDistribution() {
        return this.configuration.getDistribution();
    }

    @Override
    public TestFile getTestDirectory() {
        return this.testDirectory;
    }

    @Override
    public File getWorkingDirectory() {
        return Optional.ofNullable(this.configuration.getWorkingDirectory()).orElse(this.testDirectory);
    }

    @Override
    public GradleExecuter inDirectory(File directory) {
        return this.newInstance(this.configuration.withWorkingDirectory(directory));
    }

    @Override
    public GradleExecuter withUserHomeDirectory(File userHomeDirectory) {
        return this.newInstance(this.configuration.withUserHomeDirectory(userHomeDirectory));
    }

    @Override
    public GradleExecuter withGradleUserHomeDirectory(File gradleUserHomeDirectory) {
        return this.newInstance(this.configuration.withGradleUserHomeDirectory(gradleUserHomeDirectory));
    }

    @Override
    public GradleExecuter requireOwnGradleUserHomeDirectory() {
        return this.newInstance(this.configuration.withGradleUserHomeDirectory(this.testDirectory.createDirectory("user-home")));
    }

    @Override
    public GradleExecuter withStacktraceDisabled() {
        return this.newInstance(this.configuration.withShowStacktrace(false));
    }

    @Override
    public GradleExecuter usingSettingsFile(File settingsFile) {
        return this.newInstance(this.configuration.withSettingsFile(settingsFile));
    }

    private void ensureSettingsFileAvailable() {
        TestFile workingDirectory;
        for (TestFile directory = workingDirectory = new TestFile(this.getWorkingDirectory(), new Object[0]); directory != null && this.getTestDirectory().isSelfOrDescendent(directory); directory = directory.getParentFile()) {
            if (!this.hasSettingsFile(directory)) continue;
            return;
        }
        workingDirectory.createFile("settings.gradle");
    }

    private boolean hasSettingsFile(TestFile directory) {
        if (directory.isDirectory()) {
            return directory.file("settings.gradle").isFile() || directory.file("settings.gradle.kts").isFile();
        }
        return false;
    }

    @Override
    public GradleExecuter usingBuildScript(File buildScript) {
        return this.newInstance(this.configuration.withBuildScript(buildScript));
    }

    @Override
    public GradleExecuter usingInitScript(File initScript) {
        return this.newInstance(this.configuration.withInitScripts((List<File>)ImmutableList.builder().addAll(this.configuration.getInitScripts()).add((Object)initScript).build()));
    }

    @Override
    public GradleExecuter usingProjectDirectory(File projectDirectory) {
        return this.newInstance(this.configuration.withProjectDirectory(projectDirectory));
    }

    @Override
    public GradleExecuter withBuildCacheEnabled() {
        return this.withArgument("--build-cache");
    }

    @Override
    public GradleExecuter withArguments(String ... args) {
        return this.withArguments(Arrays.asList(args));
    }

    @Override
    public GradleExecuter withArguments(List<String> args) {
        return this.newInstance(this.configuration.withArguments(args));
    }

    @Override
    public GradleExecuter withArgument(String arg) {
        return this.newInstance(this.configuration.withArguments((List<String>)ImmutableList.builder().addAll(this.configuration.getArguments()).add((Object)arg).build()));
    }

    @Override
    public GradleExecuter withTasks(String ... tasks) {
        return this.withTasks(Arrays.asList(tasks));
    }

    @Override
    public GradleExecuter withTasks(List<String> tasks) {
        return this.newInstance(this.configuration.withTasks((List<String>)ImmutableList.builder().addAll(this.configuration.getTasks()).addAll(tasks).build()));
    }

    @Override
    public GradleExecuter beforeExecute(Function<? super GradleExecuter, GradleExecuter> action) {
        return this.newInstance(this.configuration.withBeforeExecute((List<Function<? super GradleExecuter, GradleExecuter>>)ImmutableList.builder().addAll(this.configuration.getBeforeExecute()).add(action).build()));
    }

    private GradleExecuter fireBeforeExecute() {
        GradleExecuter executer = this.newInstance(this.configuration.withBeforeExecute((List<Function<? super GradleExecuter, GradleExecuter>>)ImmutableList.of()));
        for (Function<? super GradleExecuter, GradleExecuter> it : this.configuration.getBeforeExecute()) {
            executer = it.apply(executer);
        }
        return executer;
    }

    @Override
    public GradleExecuter afterExecute(Consumer<? super GradleExecuter> action) {
        return this.newInstance(this.configuration.withAfterExecute((List<Consumer<? super GradleExecuter>>)ImmutableList.builder().addAll(this.configuration.getAfterExecute()).add(action).build()));
    }

    private void fireAfterExecute() {
        this.configuration.getAfterExecute().forEach(it -> it.accept(this));
    }

    @Override
    public GradleExecuter withConsole(ConsoleOutput consoleType) {
        return this.newInstance(this.configuration.withConsoleType(consoleType));
    }

    @Override
    public GradleExecuter withEnvironmentVars(Map<String, ?> environment) {
        HashMap env = Maps.newHashMap(this.configuration.getEnvironment());
        env.putAll(environment);
        return this.newInstance(this.configuration.withEnvironment(env));
    }

    @Override
    public GradleExecuter withoutDeprecationChecks() {
        return this.newInstance(this.configuration.withAllowDeprecations(true));
    }

    @Override
    public GradleExecuter requireIsolatedDaemons() {
        return this.withDaemonBaseDirectory(this.getTestDirectory().file("daemon"));
    }

    @Override
    public GradleExecuter withDaemonBaseDirectory(File daemonBaseDirectory) {
        return this.newInstance(this.configuration.withDaemonBaseDirectory(daemonBaseDirectory));
    }

    @Override
    public GradleExecuter withDaemonIdleTimeout(Duration daemonIdleTimeout) {
        return this.newInstance(this.configuration.withDaemonIdleTimeout(daemonIdleTimeout));
    }

    @Override
    public GradleExecuter requireDaemon() {
        return this.newInstance(this.configuration.withRequireDaemon(true));
    }

    @Override
    public boolean usesDaemon() {
        CliDaemonArgument cliDaemonArgument = this.resolveCliDaemonArgument();
        if (cliDaemonArgument == CliDaemonArgument.NO_DAEMON || cliDaemonArgument == CliDaemonArgument.FOREGROUND) {
            return false;
        }
        return this.configuration.isRequireDaemon() || cliDaemonArgument == CliDaemonArgument.DAEMON;
    }

    protected CliDaemonArgument resolveCliDaemonArgument() {
        for (int i = this.configuration.getArguments().size() - 1; i >= 0; --i) {
            String arg = this.configuration.getArguments().get(i);
            if (arg.equals("--daemon")) {
                return CliDaemonArgument.DAEMON;
            }
            if (arg.equals("--no-daemon")) {
                return CliDaemonArgument.NO_DAEMON;
            }
            if (!arg.equals("--foreground")) continue;
            return CliDaemonArgument.FOREGROUND;
        }
        return CliDaemonArgument.NOT_DEFINED;
    }

    private boolean noDaemonArgumentGiven() {
        return this.resolveCliDaemonArgument() == CliDaemonArgument.NOT_DEFINED;
    }

    @Override
    public boolean usesSharedDaemons() {
        return this.isSharedDaemons();
    }

    protected boolean isSharedDaemons() {
        return this.configuration.getDaemonBaseDirectory().equals(this.configuration.getBuildContext().getDaemonBaseDirectory());
    }

    @Override
    public GradleExecuter withoutDaemonCrashChecks() {
        return this.newInstance(this.configuration.withDaemonCrashChecks(false));
    }

    public void cleanup() {
        this.cleanupIsolatedDaemons();
        for (ExecutionResult result : this.configuration.getExecutionResults()) {
            result.assertResultVisited();
        }
    }

    private void cleanupIsolatedDaemons() {
        ArrayList<DaemonLogsAnalyzer> analyzers = new ArrayList<DaemonLogsAnalyzer>();
        for (File directory : this.configuration.getIsolatedDaemonBaseDirectories()) {
            try {
                DaemonLogsAnalyzer analyzer = new DaemonLogsAnalyzer(directory, this.configuration.getDistribution().getVersion().getVersion());
                analyzers.add(analyzer);
                analyzer.killAll();
            }
            catch (Exception e) {
                System.out.println("Problem killing isolated daemons of Gradle version " + this.configuration.getDistribution().getVersion().getVersion() + " in " + directory);
                e.printStackTrace();
            }
        }
        if (this.configuration.isDaemonCrashChecks()) {
            analyzers.forEach(DaemonLogsAnalyzer::assertNoCrashedDaemon);
        }
    }

    @Override
    public GradleExecuter withoutExplicitTemporaryDirectory() {
        return this.newInstance(this.configuration.withExplicitTemporaryDirectory(false));
    }

    @Override
    public GradleExecuter withDefaultCharacterEncoding(Charset defaultCharacterEncoding) {
        return this.newInstance(this.configuration.withDefaultCharacterEncoding(defaultCharacterEncoding));
    }

    @Override
    public GradleExecuter withDefaultLocale(Locale defaultLocale) {
        return this.newInstance(this.configuration.withDefaultLocale(defaultLocale));
    }

    @Override
    public GradleExecuter withWelcomeMessageEnabled() {
        return this.newInstance(this.configuration.withRenderWelcomeMessage(true));
    }

    @Override
    public GradleExecuter withBuildScanEnabled() {
        return new GradleEnterpriseBuildScan().apply(this);
    }

    @Override
    public ExecutionResult run() {
        this.beforeBuildSetup();
        if (this.configuration.getBeforeExecute().isEmpty()) {
            try {
                ExecutionResult result = this.doRun();
                this.afterBuildCleanup(result);
                ExecutionResult executionResult = result;
                return executionResult;
            }
            finally {
                this.finished();
            }
        }
        return this.fireBeforeExecute().run();
    }

    private void afterBuildCleanup(ExecutionResult result) {
        this.fireAfterExecute();
        this.configuration = this.configuration.withExecutionResults((List<ExecutionResult>)ImmutableList.builder().addAll(this.configuration.getExecutionResults()).add((Object)result).build());
    }

    protected abstract ExecutionResult doRun();

    @Override
    public ExecutionFailure runWithFailure() {
        this.beforeBuildSetup();
        if (this.configuration.getBeforeExecute().isEmpty()) {
            try {
                ExecutionFailure result = this.doRunWithFailure();
                this.afterBuildCleanup(result);
                ExecutionFailure executionFailure = result;
                return executionFailure;
            }
            finally {
                this.finished();
            }
        }
        return this.fireBeforeExecute().runWithFailure();
    }

    private void beforeBuildSetup() {
        this.collectStateBeforeExecution();
    }

    private void collectStateBeforeExecution() {
        if (!this.isSharedDaemons()) {
            this.configuration = this.configuration.withIsolatedDaemonBaseDirectories((List<File>)ImmutableList.builder().addAll(this.configuration.getIsolatedDaemonBaseDirectories()).add((Object)this.configuration.getDaemonBaseDirectory()).build());
        }
    }

    protected abstract ExecutionFailure doRunWithFailure();

    private void finished() {
    }

    protected List<String> getAllArguments() {
        ArrayList<String> allArguments = new ArrayList<String>();
        allArguments.addAll(this.getImplicitJvmSystemProperties().entrySet().stream().map(entry -> String.format("-D%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.toList()));
        allArguments.addAll(Optional.ofNullable(this.configuration.getBuildScript()).map(it -> Arrays.asList("--build-file", it.getAbsolutePath())).orElse(Collections.emptyList()));
        allArguments.addAll(Optional.ofNullable(this.configuration.getBuildScript()).map(it -> Arrays.asList("--project-dir", it.getAbsolutePath())).orElse(Collections.emptyList()));
        allArguments.addAll(Optional.ofNullable(this.configuration.getInitScripts()).map(it -> it.stream().flatMap(initScript -> Stream.of("--init-script", initScript.getAbsolutePath())).collect(Collectors.toList())).orElse(Collections.emptyList()));
        allArguments.addAll(Optional.ofNullable(this.configuration.getSettingsFile()).map(it -> Arrays.asList("--settings-file", it.getAbsolutePath())).orElse(Collections.emptyList()));
        if (this.noDaemonArgumentGiven()) {
            allArguments.addAll(this.getDaemonArguments());
        }
        allArguments.addAll(this.configuration.isShowStacktrace() ? Collections.singletonList("--stacktrace") : Collections.emptyList());
        if (this.configuration.getSettingsFile() == null) {
            this.ensureSettingsFileAvailable();
        }
        allArguments.addAll(Optional.ofNullable(this.configuration.getGradleUserHomeDirectory()).map(it -> Arrays.asList("--gradle-user-home", it.getAbsolutePath())).orElse(Collections.emptyList()));
        allArguments.addAll(Optional.ofNullable(this.configuration.getConsoleType()).map(it -> Arrays.asList("--console", it.toString().toLowerCase())).orElse(Collections.emptyList()));
        allArguments.addAll(this.configuration.isAllowDeprecations() ? Collections.emptyList() : Arrays.asList("--warning-mode", "fail"));
        allArguments.addAll(this.configuration.getArguments());
        allArguments.addAll(this.configuration.getTasks());
        return allArguments;
    }

    protected List<String> getDaemonArguments() {
        if (this.usesDaemon()) {
            return ImmutableList.of((Object)"--daemon");
        }
        return ImmutableList.of((Object)"--no-daemon");
    }

    protected Map<String, String> getImplicitJvmSystemProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.putAll(Optional.ofNullable(this.configuration.getUserHomeDirectory()).map(it -> Collections.singletonMap("user.home", it.getAbsolutePath())).orElse(Collections.emptyMap()));
        properties.put("org.gradle.daemon.idletimeout", String.valueOf(this.configuration.getDaemonIdleTimeout().toMillis()));
        properties.put("org.gradle.daemon.registry.base", this.configuration.getDaemonBaseDirectory().getAbsolutePath());
        if (this.configuration.isExplicitTemporaryDirectory()) {
            File temporaryDirectory = this.configuration.getBuildContext().getTemporaryDirectory();
            temporaryDirectory.mkdirs();
            String temporaryDirectoryPath = temporaryDirectory.getAbsolutePath();
            if (!temporaryDirectoryPath.contains(" ") || this.getDistribution().isSupportsSpacesInGradleAndJavaOpts() && this.supportsWhiteSpaceInEnvVars()) {
                properties.put("java.io.tmpdir", temporaryDirectoryPath);
            }
        }
        properties.put("file.encoding", this.configuration.getDefaultCharacterEncoding().name());
        properties.putAll(Optional.ofNullable(this.configuration.getDefaultLocale()).map(locale -> {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("user.language", locale.getLanguage());
            result.put("user.country", locale.getCountry());
            result.put("user.variant", locale.getVariant());
            return result;
        }).orElse(Collections.emptyMap()));
        properties.put("org.gradle.internal.launcher.welcomeMessageEnabled", Boolean.toString(this.configuration.isRenderWelcomeMessage()));
        File welcomeMessageFile = new File(this.configuration.getGradleUserHomeDirectory(), "notifications/" + this.configuration.getDistribution().getVersion().getVersion() + "/release-features.rendered");
        if (this.configuration.isRenderWelcomeMessage()) {
            welcomeMessageFile.delete();
        } else {
            try {
                FileUtils.touch((File)welcomeMessageFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not ensure render message is properly rendered", e);
            }
        }
        return properties;
    }

    protected boolean supportsWhiteSpaceInEnvVars() {
        return true;
    }

    static enum CliDaemonArgument {
        NOT_DEFINED,
        DAEMON,
        NO_DAEMON,
        FOREGROUND;

    }
}

