/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.daemon;

import com.google.common.collect.Iterables;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonStateProbe;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.junit.Assert;

public class DaemonLogFileStateProbe
implements DaemonStateProbe {
    private final DaemonContext context;
    private final File log;
    private final String startBuildMessage;
    private final String finishBuildMessage;

    public DaemonLogFileStateProbe(File daemonLog, DaemonContext context) {
        this(daemonLog, context, "The daemon has started executing the build.");
    }

    public DaemonLogFileStateProbe(File daemonLog, DaemonContext context, String startBuildMessage) {
        this(daemonLog, context, startBuildMessage, "The daemon has finished executing the build.");
    }

    public DaemonLogFileStateProbe(File daemonLog, DaemonContext context, String startBuildMessage, String finishBuildMessage) {
        this.finishBuildMessage = finishBuildMessage;
        this.startBuildMessage = startBuildMessage;
        this.log = daemonLog;
        this.context = context;
    }

    public String toString() {
        return String.format("DaemonLogFile{file: %s, context: %s}", this.log, this.context);
    }

    public DaemonContext getContext() {
        return this.context;
    }

    @Override
    public DaemonStateControl.State getCurrentState() {
        return (DaemonStateControl.State)Iterables.getLast(this.getStates());
    }

    public List<DaemonStateControl.State> getStates() {
        LinkedList<DaemonStateControl.State> states = new LinkedList<DaemonStateControl.State>();
        states.add(DaemonStateControl.State.Idle);
        try {
            FileUtils.readLines((File)this.log, (Charset)Charset.defaultCharset()).forEach(it -> {
                if (it.contains(this.startBuildMessage)) {
                    states.add(DaemonStateControl.State.Busy);
                } else if (it.contains(this.finishBuildMessage)) {
                    states.add(DaemonStateControl.State.Idle);
                } else if (it.contains("The daemon has received a build cancellation request.")) {
                    states.add(DaemonStateControl.State.Canceled);
                } else if (it.contains("Daemon vm is shutting down... The daemon has exited normally or was terminated in response to a user interrupt.")) {
                    states.add(DaemonStateControl.State.Stopped);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return states;
    }

    public String getLog() {
        try {
            return FileUtils.readFileToString((File)this.log, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public File getLogFile() {
        return this.log;
    }

    public int getPort() {
        Pattern pattern = Pattern.compile("^.*Advertising the daemon address to the clients: .*port:(\\d+).*", 40);
        Matcher matcher = pattern.matcher(this.getLog());
        Assert.assertTrue((String)("Unable to find daemon address in the daemon log. Daemon: " + this.context), (boolean)matcher.matches());
        try {
            return Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Unexpected format of the port number found in the daemon log. Daemon: " + this.context);
        }
    }
}

