/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.daemon;

import dev.gradleplugins.test.fixtures.ProcessFixture;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonContextParser;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonFixture;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;

public abstract class AbstractDaemonFixture
implements DaemonFixture {
    public static final int STATE_CHANGE_TIMEOUT = 20000;
    public final DaemonContext context;

    public AbstractDaemonFixture(File daemonLog) {
        this.context = DaemonContextParser.parseFromFile(daemonLog);
        if (this.context.getPid() == null) {
            try {
                System.out.println(String.format("PID in daemon log (%s) is null.", daemonLog.getAbsolutePath()));
                System.out.println(String.format("daemon.log exists: %s", daemonLog.exists()));
                System.out.println("start daemon.log content: ");
                String daemonLogContent = FileUtils.readFileToString((File)daemonLog, (Charset)Charset.defaultCharset());
                System.out.println(String.format("{daemonLog.text.isEmpty()} = %s", daemonLogContent.isEmpty()));
                System.out.println(daemonLogContent);
                System.out.println("end daemon.log content");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public DaemonContext getContext() {
        return this.context;
    }

    @Override
    public boolean logContains(String searchString) {
        return this.logContains(0L, searchString);
    }

    @Override
    public boolean logContains(long fromLine, String searchString) {
        return Files.lines(this.getLogFile().toPath()).skip(fromLine).anyMatch(it -> it.contains(searchString));
    }

    @Override
    public void becomesIdle() {
        this.waitForState(DaemonStateControl.State.Idle);
    }

    @Override
    public void stops() {
        this.waitForState(DaemonStateControl.State.Stopped);
    }

    @Override
    public void assertIdle() {
        this.assertHasState(DaemonStateControl.State.Idle);
    }

    @Override
    public void assertBusy() {
        this.assertHasState(DaemonStateControl.State.Busy);
    }

    @Override
    public void assertStopped() {
        this.assertHasState(DaemonStateControl.State.Stopped);
    }

    @Override
    public void assertCanceled() {
        this.assertHasState(DaemonStateControl.State.Canceled);
    }

    @Override
    public void becomesCanceled() {
        this.waitForState(DaemonStateControl.State.Canceled);
    }

    protected abstract void waitForState(DaemonStateControl.State var1) throws InterruptedException;

    protected abstract void assertHasState(DaemonStateControl.State var1);

    @Override
    public void kill() {
        new ProcessFixture(this.context.getPid()).kill(true);
    }

    @Override
    public void killDaemonOnly() {
        new ProcessFixture(this.context.getPid()).kill(false);
    }

    public String toString() {
        return "Daemon with context " + this.context;
    }
}

