/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.util;

import org.apache.commons.lang3.exception.ExceptionUtils;

public final class RetryUtil {
    private RetryUtil() {
    }

    public static int retry(Runnable closure) throws InterruptedException {
        return RetryUtil.retry(3, closure);
    }

    public static int retry(int retries, Runnable closure) throws InterruptedException {
        return RetryUtil.retry(retries, 0, closure);
    }

    public static int retry(int retries, int waitMsBetweenRetries, Runnable closure) throws InterruptedException {
        int retryCount = 0;
        Throwable lastException = null;
        while (retryCount++ < retries) {
            try {
                closure.run();
                return retryCount;
            }
            catch (Throwable e) {
                lastException = e;
                Thread.sleep(waitMsBetweenRetries);
            }
        }
        return (Integer)ExceptionUtils.rethrow(lastException);
    }
}

