/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.maven;

import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.maven.MavenLocalRepository;
import java.io.File;
import java.util.Collections;
import java.util.function.Consumer;

public class M2Installation
implements Consumer<GradleExecuter> {
    private final TestFile testDirectory;
    private boolean initialized = false;
    private TestFile userHomeDirectory;
    private TestFile userM2Directory;
    private TestFile userSettingsFile;
    private TestFile globalMavenDirectory;
    private TestFile globalSettingsFile;
    private TestFile isolatedMavenRepoForLeakageChecks;
    private boolean isolateMavenLocal = true;

    public M2Installation(TestFile testDirectory) {
        this.testDirectory = testDirectory;
    }

    private void init() {
        if (!this.initialized) {
            this.userHomeDirectory = this.testDirectory.createDirectory("maven_home");
            this.userM2Directory = this.userHomeDirectory.createDirectory(".m2");
            this.userSettingsFile = this.userM2Directory.file("settings.xml");
            this.globalMavenDirectory = this.userHomeDirectory.createDirectory("m2_home");
            this.globalSettingsFile = this.globalMavenDirectory.file("conf/settings.xml");
            System.out.println("M2 home: " + this.userHomeDirectory);
            this.initialized = true;
        }
    }

    public TestFile getUserHomeDir() {
        this.init();
        return this.userHomeDirectory;
    }

    public TestFile getUserM2Directory() {
        this.init();
        return this.userM2Directory;
    }

    public TestFile getUserSettingsFile() {
        this.init();
        return this.userSettingsFile;
    }

    public TestFile getGlobalMavenDirectory() {
        this.init();
        return this.globalMavenDirectory;
    }

    public TestFile getGlobalSettingsFile() {
        this.init();
        return this.globalSettingsFile;
    }

    public MavenLocalRepository mavenRepo() {
        this.init();
        return new MavenLocalRepository(this.userM2Directory.file("repository"));
    }

    public M2Installation generateUserSettingsFile(MavenLocalRepository userRepository) {
        this.init();
        this.userSettingsFile.write("<settings>\n    <localRepository>${userRepository.rootDir.absolutePath}</localRepository>\n</settings>");
        return this;
    }

    public M2Installation generateGlobalSettingsFile() {
        return this.generateGlobalSettingsFile(this.mavenRepo());
    }

    public M2Installation generateGlobalSettingsFile(MavenLocalRepository globalRepository) {
        this.init();
        this.globalSettingsFile.createFile().write("<settings>\n    <localRepository>${globalRepository.rootDir.absolutePath}</localRepository>\n</settings>");
        return this;
    }

    @Override
    public void accept(GradleExecuter gradleExecuter) {
        this.init();
        gradleExecuter.withUserHomeDirectory(this.userHomeDirectory);
        this.isolateMavenLocal = false;
        if (this.globalMavenDirectory.exists()) {
            gradleExecuter.withEnvironmentVars(Collections.singletonMap("M2_HOME", this.globalMavenDirectory.getAbsolutePath()));
        }
    }

    public void isolateMavenLocalRepo(GradleExecuter gradleExecuter) {
        gradleExecuter.beforeExecute(executer -> {
            if (this.isolateMavenLocal) {
                this.isolatedMavenRepoForLeakageChecks = executer.getTestDirectory().createDirectory("m2-home-should-not-be-filled");
                M2Installation.setMavenLocalLocation(gradleExecuter, this.isolatedMavenRepoForLeakageChecks);
            }
        });
        gradleExecuter.afterExecute(executer -> {
            if (this.isolateMavenLocal) {
                this.isolatedMavenRepoForLeakageChecks.assertIsEmptyDirectory();
            }
        });
    }

    private static void setMavenLocalLocation(GradleExecuter gradleExecuter, File destination) {
        gradleExecuter.withArgument("-Dmaven.repo.local=" + destination.getAbsolutePath());
    }
}

