/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.integtests.fixtures.nativeplatform;

import com.google.common.base.Preconditions;
import dev.gradleplugins.test.fixtures.file.ExecOutput;
import dev.gradleplugins.test.fixtures.file.TestFile;
import java.io.File;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.gradle.internal.os.OperatingSystem;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class NativeInstallationFixture {
    private final TestFile installDirectory;
    private final OperatingSystem os;

    public NativeInstallationFixture(TestFile installDirectory, OperatingSystem os) {
        this.installDirectory = installDirectory;
        this.os = os;
    }

    public ExecOutput exec(Object ... args) {
        this.assertInstalled();
        return this.scriptFile().get().exec(args);
    }

    private Optional<TestFile> scriptFile() {
        File[] files = this.installDirectory.listFiles(File::isFile);
        Preconditions.checkNotNull((Object)files, (String)"Couldn't list files inside '%s'", (Object)this.installDirectory.getAbsolutePath());
        Stream<TestFile> fileStream = Arrays.stream(files).map(x$0 -> TestFile.of((File)x$0, (LinkOption[])new LinkOption[0]));
        if (this.os.isWindows()) {
            fileStream = fileStream.filter(it -> FilenameUtils.isExtension((String)it.getName(), (String)"bat"));
        }
        return fileStream.findFirst();
    }

    public NativeInstallationFixture assertInstalled() {
        this.installDirectory.assertIsDirectory();
        Optional<TestFile> script = this.scriptFile();
        assert (script.isPresent());
        TestFile libDir = this.installDirectory.file(new Object[]{"lib"});
        libDir.assertIsDirectory();
        libDir.file(new Object[]{this.os.getExecutableName(script.get().getName())}).assertIsFile();
        return this;
    }

    public NativeInstallationFixture assertNotInstalled() {
        this.installDirectory.assertDoesNotExist();
        return this;
    }

    public NativeInstallationFixture assertIncludesLibraries(String ... names) {
        Set expected = Arrays.asList(names).stream().map(arg_0 -> ((OperatingSystem)this.os).getSharedLibraryName(arg_0)).collect(Collectors.toSet());
        Assert.assertThat(this.getLibraryFiles().stream().map(File::getName).collect(Collectors.toSet()), (Matcher)CoreMatchers.equalTo(expected));
        return this;
    }

    private List<File> getLibraryFiles() {
        this.installDirectory.assertIsDirectory();
        TestFile libDir = this.installDirectory.file(new Object[]{"lib"});
        libDir.assertIsDirectory();
        List<File> libFiles = this.os.isWindows() ? Arrays.stream(libDir.listFiles()).filter(it -> it.isFile() && !it.getName().endsWith(".exe")).collect(Collectors.toList()) : Arrays.stream(libDir.listFiles()).filter(it -> it.isFile() && !it.getName().contains(".")).collect(Collectors.toList());
        return libFiles;
    }
}

