/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.versions;

import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistributionFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.com.google.gson.Gson;
import org.gradle.util.GradleVersion;

public class ReleasedVersionDistributions {
    private Properties properties;
    private List<GradleDistribution> distributions;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GradleDistribution getMostRecentRelease() {
        try (InputStreamReader reader = new InputStreamReader(new URL("https://services.gradle.org/versions/current").openConnection().getInputStream());){
            GradleRelease gradleRelease = (GradleRelease)new Gson().fromJson((Reader)reader, GradleRelease.class);
            GradleDistribution gradleDistribution = GradleDistributionFactory.distribution(gradleRelease.version);
            return gradleDistribution;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the last version", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GradleDistribution getMostRecentReleaseSnapshot() {
        try (InputStreamReader reader = new InputStreamReader(new URL("https://services.gradle.org/versions/release-nightly").openConnection().getInputStream());){
            GradleRelease gradleRelease = (GradleRelease)new Gson().fromJson((Reader)reader, GradleRelease.class);
            GradleDistribution gradleDistribution = GradleDistributionFactory.distribution(gradleRelease.version);
            return gradleDistribution;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the last snapshot version", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GradleDistribution getMostRecentSnapshot() {
        try (InputStreamReader reader = new InputStreamReader(new URL("https://services.gradle.org/versions/nightly").openConnection().getInputStream());){
            GradleRelease gradleRelease = (GradleRelease)new Gson().fromJson((Reader)reader, GradleRelease.class);
            GradleDistribution gradleDistribution = GradleDistributionFactory.distribution(gradleRelease.version);
            return gradleDistribution;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the last snapshot version", e);
        }
    }

    public List<GradleDistribution> getAll() {
        if (this.distributions == null) {
            try (InputStreamReader reader = new InputStreamReader(new URL("https://services.gradle.org/versions/all").openConnection().getInputStream());){
                List<Object> gradleReleases = Arrays.asList((Object[])new Gson().fromJson((Reader)reader, GradleRelease[].class));
                gradleReleases = gradleReleases.stream().filter(it -> !it.snapshot && it.rcFor.isEmpty()).collect(Collectors.toList());
                this.distributions = gradleReleases.stream().map(it -> GradleDistributionFactory.distribution(it.version)).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.distributions;
    }

    public List<GradleDistribution> getSupported() {
        GradleVersion firstSupported = GradleVersion.version((String)"1.0");
        return this.getAll().stream().filter(element -> element.getVersion().compareTo(firstSupported) >= 0).collect(Collectors.toList());
    }

    public GradleDistribution getDistribution(GradleVersion gradleVersion) {
        return this.getAll().stream().filter(element -> element.getVersion().equals((Object)gradleVersion)).findFirst().get();
    }

    public GradleDistribution getDistribution(String gradleVersion) {
        return this.getAll().stream().filter(element -> element.getVersion().getVersion().equals(gradleVersion)).findFirst().get();
    }

    public GradleDistribution getPrevious(GradleVersion gradleVersion) {
        GradleDistribution distribution = this.getDistribution(gradleVersion);
        List sortedDistributions = this.distributions.stream().sorted(new Comparator<GradleDistribution>(){

            @Override
            public int compare(GradleDistribution dist1, GradleDistribution dist2) {
                return dist1.getVersion().compareTo(dist2.getVersion());
            }
        }).collect(Collectors.toList());
        int distributionIndex = sortedDistributions.indexOf(distribution) - 1;
        return distributionIndex >= 0 ? (GradleDistribution)sortedDistributions.get(distributionIndex) : null;
    }

    private static class GradleRelease {
        String version;
        boolean snapshot;
        boolean current;
        String rcFor;

        private GradleRelease() {
        }
    }
}

