/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.sources;

import dev.gradleplugins.test.fixtures.file.TestFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SourceFile {
    private final String path;
    private final String name;
    private final String content;

    public SourceFile(String path, String name, String content) {
        this.content = content;
        this.path = path;
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public TestFile writeToDir(TestFile base) {
        return this.writeToDir(base, this.name);
    }

    public TestFile writeToDir(TestFile base, String name) {
        TestFile file = base.file(this.path, name);
        this.writeToFile(file);
        return file;
    }

    public void writeToFile(TestFile file) {
        if (file.exists()) {
            file.write("");
        }
        file.write(this.content);
    }

    public String withPath(String basePath) {
        return Stream.of(basePath, this.path, this.name).collect(Collectors.joining("/"));
    }
}

