/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.file;

import dev.gradleplugins.test.fixtures.file.TestFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class TestFileHelper {
    private final TestFile file;

    TestFileHelper(TestFile file) {
        this.file = file;
    }

    public void unzipTo(File target, boolean nativeTools) {
        try (FileInputStream instr = new FileInputStream(this.file);){
            HashSet<String> dirs = new HashSet<String>();
            try (ZipInputStream zipStr = new ZipInputStream(instr);){
                ZipEntry entry;
                while ((entry = zipStr.getNextEntry()) != null) {
                    if (entry.isDirectory()) {
                        Assert.assertTrue((String)("Duplicate directory '" + entry.getName() + "'"), (boolean)dirs.add(entry.getName()));
                    }
                    if (!entry.getName().contains("/")) continue;
                    String parent = StringUtils.substringBeforeLast((String)entry.getName(), (String)"/") + "/";
                    Assert.assertTrue((String)("Missing dir '" + parent + "'"), (boolean)dirs.contains(parent));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (nativeTools && this.isUnix()) {
            try {
                Process process = new ProcessBuilder(new String[0]).command("unzip", "-q", "-o", this.file.getAbsolutePath(), "-d", target.getAbsolutePath()).inheritIO().start();
                Assert.assertThat((Object)process.waitFor(), (Matcher)CoreMatchers.equalTo((Object)0));
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        Expand unzip = new Expand();
        unzip.setSrc((File)this.file);
        unzip.setDest(target);
        unzip.setProject(new Project());
        unzip.execute();
    }

    private boolean isUnix() {
        return !SystemUtils.IS_OS_WINDOWS;
    }
}

