/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.integtests.fixtures;

import dev.gradleplugins.integtests.fixtures.AbstractMultiTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractMultiVersionSpecRunner<T extends VersionedTool>
extends AbstractMultiTestRunner {
    public static final CoverageContext UNKNOWN = new CoverageContext(null);
    private final Set<CoverageContext> coverageContexts;

    protected abstract Collection<T> getAllVersions();

    protected abstract boolean isAvailable(T var1);

    protected abstract Collection<AbstractMultiTestRunner.Execution> createExecutionsFor(T var1);

    public AbstractMultiVersionSpecRunner(Class<?> target, Set<CoverageContext> coverageContexts) {
        super(target);
        this.coverageContexts = coverageContexts;
    }

    protected abstract String getVersions();

    @Override
    protected void createExecutions() {
        String versions = this.getVersions();
        CoverageContext coverageContext = this.from(versions);
        if (coverageContext == UNKNOWN) {
            ArrayList<String> selectionCriteria = new ArrayList<String>(Arrays.asList(versions.split(",")));
            this.createSelectedExecutions(selectionCriteria);
        } else {
            this.createExecutionsForContext(coverageContext);
        }
    }

    protected abstract Collection<T> versionUnderTestForContext(CoverageContext var1);

    protected void createExecutionsForContext(CoverageContext coverageContext) {
        if (coverageContext == UNKNOWN) {
            throw new IllegalArgumentException();
        }
        Collection<T> versionsUnderTest = this.versionUnderTestForContext(coverageContext);
        for (VersionedTool version : versionsUnderTest) {
            for (AbstractMultiTestRunner.Execution execution : this.createExecutionsFor(version)) {
                this.add(execution);
            }
        }
    }

    private void createSelectedExecutions(List<String> selectionCriteria) {
        Collection<T> possibleVersions = this.getAllVersions();
        HashSet<Object> versionsUnderTest = new HashSet<Object>();
        for (String string : selectionCriteria) {
            CoverageContext candidateCoverageContext = this.from(string);
            if (candidateCoverageContext != UNKNOWN) {
                versionsUnderTest.addAll(this.versionUnderTestForContext(candidateCoverageContext));
                continue;
            }
            for (VersionedTool version : possibleVersions) {
                if (!this.isAvailable(version) || !version.matches(string)) continue;
                versionsUnderTest.add(version);
            }
        }
        for (VersionedTool versionedTool : versionsUnderTest) {
            for (AbstractMultiTestRunner.Execution execution : this.createExecutionsFor(versionedTool)) {
                this.add(execution);
            }
        }
    }

    private CoverageContext from(String requested) {
        for (CoverageContext context : this.coverageContexts) {
            if (!context.selector.equals(requested)) continue;
            return context;
        }
        return UNKNOWN;
    }

    public static interface VersionedTool {
        public boolean matches(String var1);
    }

    protected static final class CoverageContext {
        private final String selector;

        CoverageContext(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CoverageContext)) {
                return false;
            }
            CoverageContext other = (CoverageContext)o;
            String this$selector = this.getSelector();
            String other$selector = other.getSelector();
            return !(this$selector == null ? other$selector != null : !this$selector.equals(other$selector));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $selector = this.getSelector();
            result = result * 59 + ($selector == null ? 43 : $selector.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractMultiVersionSpecRunner.CoverageContext(selector=" + this.getSelector() + ")";
        }
    }
}

