/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.sources.cpp;

import dev.gradleplugins.test.fixtures.sources.SourceElement;
import dev.gradleplugins.test.fixtures.sources.SourceFile;
import dev.gradleplugins.test.fixtures.sources.cpp.CppSourceElement;
import java.util.ArrayList;

public abstract class CppLibraryElement
extends CppSourceElement {
    public abstract SourceElement getPublicHeaders();

    public SourceElement getPrivateHeaders() {
        return CppLibraryElement.empty();
    }

    @Override
    public SourceElement getHeaders() {
        return CppLibraryElement.ofElements(this.getPublicHeaders(), this.getPrivateHeaders());
    }

    public CppLibraryElement asLib() {
        final CppLibraryElement delegate = this;
        return new CppLibraryElement(){

            @Override
            public SourceElement getPublicHeaders() {
                ArrayList<SourceFile> headers = new ArrayList<SourceFile>();
                for (SourceFile sourceFile : delegate.getPublicHeaders().getFiles()) {
                    headers.add(this.sourceFile("public", sourceFile.getName(), sourceFile.getContent()));
                }
                return SourceElement.ofFiles(headers);
            }

            @Override
            public SourceElement getPrivateHeaders() {
                return delegate.getPrivateHeaders();
            }

            @Override
            public SourceElement getSources() {
                return delegate.getSources();
            }
        };
    }
}

