/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer;

import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.AbstractGradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionResult;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.OutputScrapingExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.OutputScrapingExecutionResult;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecuterConfiguration;
import dev.gradleplugins.test.fixtures.logging.GroupedOutputFixture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.GradleRunner;
import org.gradle.testkit.runner.TaskOutcome;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class GradleRunnerExecuter
extends AbstractGradleExecuter {
    public GradleRunnerExecuter(TestFile testDirectory) {
        super(testDirectory);
    }

    private GradleRunnerExecuter(TestFile testDirectory, GradleExecuterConfiguration configuration) {
        super(testDirectory, configuration);
    }

    @Override
    protected GradleExecuter newInstance(TestFile testDirectory, GradleExecuterConfiguration configuration) {
        return new GradleRunnerExecuter(testDirectory, configuration);
    }

    @Override
    public GradleExecuter withDebuggerAttached() {
        return this.newInstance(this.configuration.withDebuggerAttached(true));
    }

    @Override
    public GradleExecuter withPluginClasspath() {
        return this.newInstance(this.configuration.withPluginClasspath(true));
    }

    @Override
    public ExecutionResult doRun() {
        return new GradleRunnerExecutionResult(this.configureExecuter().build());
    }

    @Override
    public ExecutionFailure doRunWithFailure() {
        return new GradleRunnerExecutionFailure(this.configureExecuter().buildAndFail());
    }

    private GradleRunner configureExecuter() {
        GradleRunner runner = GradleRunner.create();
        runner.forwardOutput();
        if (this.configuration.isPluginClasspath()) {
            runner.withPluginClasspath();
        }
        runner.withProjectDir(this.getWorkingDirectory());
        if (this.configuration.isDebuggerAttached()) {
            System.out.println("WARNING: Gradle TestKit has some class loader issue that may result in runtime failures - such as NoClassDefFoundError for groovy/util/AntBuilder (see https://github.com/gradle/gradle/issues/1687).");
            runner.withDebug(true);
        }
        if (this.configuration.getGradleVersion() != null) {
            runner.withGradleVersion(this.configuration.getGradleVersion());
        }
        if (!this.configuration.getEnvironment().isEmpty()) {
            HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
            environment.putAll(this.configuration.getEnvironment().entrySet().stream().map(it -> new AbstractMap.SimpleImmutableEntry(it.getKey(), it.getValue().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            runner.withEnvironment(environment);
        }
        runner.withArguments(this.getAllArguments());
        return runner;
    }

    public GradleExecuter usingGradleVersion(String gradleVersion) {
        return this.newInstance(this.configuration.withGradleVersion(gradleVersion));
    }

    private static class GradleRunnerExecutionFailure
    extends GradleRunnerExecutionResult
    implements ExecutionFailure {
        private final OutputScrapingExecutionFailure delegate;

        GradleRunnerExecutionFailure(BuildResult result) {
            super(result);
            this.delegate = OutputScrapingExecutionFailure.from(result.getOutput(), result.getOutput());
        }

        @Override
        public ExecutionFailure assertHasCause(String description) {
            return this.delegate.assertHasCause(description);
        }

        @Override
        public ExecutionFailure assertThatCause(Matcher<? super String> matcher) {
            return this.delegate.assertThatCause(matcher);
        }

        @Override
        public ExecutionFailure assertHasDescription(String context) {
            return this.delegate.assertHasDescription(context);
        }
    }

    private static class GradleRunnerExecutionResult
    implements ExecutionResult {
        private final BuildResult result;
        private final OutputScrapingExecutionResult delegate;
        private static final List<TaskOutcome> SKIPPED_TASK_OUTCOMES = Arrays.asList(TaskOutcome.FROM_CACHE, TaskOutcome.NO_SOURCE, TaskOutcome.SKIPPED, TaskOutcome.UP_TO_DATE);

        GradleRunnerExecutionResult(BuildResult result) {
            this.result = result;
            this.delegate = OutputScrapingExecutionResult.from(result.getOutput(), "");
        }

        private static List<String> flattenTaskPaths(Object[] taskPaths) {
            ArrayList<String> result = new ArrayList<String>();
            GradleRunnerExecutionResult.flattenTaskPaths(Arrays.asList(taskPaths), result);
            return result;
        }

        private static void flattenTaskPaths(Collection<? super Object> taskPaths, List<String> flattenTaskPaths) {
            taskPaths.stream().forEach(it -> {
                if (it instanceof Collection) {
                    GradleRunnerExecutionResult.flattenTaskPaths((Collection)it, flattenTaskPaths);
                } else {
                    flattenTaskPaths.add(it.toString());
                }
            });
        }

        @Override
        public GroupedOutputFixture getGroupedOutput() {
            return this.delegate.getGroupedOutput();
        }

        @Override
        public String getPlainTextOutput() {
            return this.delegate.getPlainTextOutput();
        }

        @Override
        public String getOutput() {
            return this.result.getOutput();
        }

        @Override
        public ExecutionResult assertTaskNotExecuted(String taskPath) {
            Set<String> actualTasks = this.findExecutedTasksInOrderStarted();
            if (actualTasks.contains(taskPath)) {
                this.failOnMissingElement("Build output does contains unexpected task.", taskPath, actualTasks);
            }
            return this;
        }

        private void failOnMissingElement(String message, String expected, Set<String> actual) {
            this.failureOnUnexpectedOutput(String.format("%s%nExpected: %s%nActual: %s", message, expected, actual));
        }

        @Override
        public ExecutionResult assertTasksExecuted(Object ... taskPaths) {
            Set<String> actualTasks;
            TreeSet<String> expectedTasks = new TreeSet<String>(GradleRunnerExecutionResult.flattenTaskPaths(taskPaths));
            if (!expectedTasks.equals(actualTasks = this.findExecutedTasksInOrderStarted())) {
                this.failOnDifferentSets("Build output does not contain the expected tasks.", expectedTasks, actualTasks);
            }
            return this;
        }

        @Override
        public ExecutionResult assertTasksExecutedAndNotSkipped(Object ... taskPaths) {
            this.assertTasksExecuted(taskPaths);
            return this.assertTasksNotSkipped(taskPaths);
        }

        @Override
        public ExecutionResult assertTasksNotSkipped(Object ... taskPaths) {
            TreeSet<String> tasks;
            TreeSet<String> expectedTasks = new TreeSet<String>(GradleRunnerExecutionResult.flattenTaskPaths(taskPaths));
            if (!expectedTasks.equals(tasks = new TreeSet<String>(this.getNotSkippedTasks()))) {
                this.failOnDifferentSets("Build output does not contain the expected non skipped tasks.", expectedTasks, tasks);
            }
            return this;
        }

        @Override
        public ExecutionResult assertTasksSkipped(Object ... taskPaths) {
            Set<String> skippedTasks;
            TreeSet<String> expectedTasks = new TreeSet<String>(GradleRunnerExecutionResult.flattenTaskPaths(taskPaths));
            if (!expectedTasks.equals(skippedTasks = this.getSkippedTasks())) {
                this.failOnDifferentSets("Build output does not contain the expected skipped tasks.", expectedTasks, skippedTasks);
            }
            return this;
        }

        private void failOnDifferentSets(String message, Set<String> expected, Set<String> actual) {
            this.failureOnUnexpectedOutput(String.format("%s%nExpected: %s%nActual: %s", message, expected, actual));
        }

        private void failureOnUnexpectedOutput(String message) {
            throw new AssertionError((Object)this.unexpectedOutputMessage(message));
        }

        private String unexpectedOutputMessage(String message) {
            return String.format("%s%nOutput:%n=======%n%s%nError:%n======%n%s", message, this.getOutput(), "Using TestKit Runner which mixin both error output");
        }

        @Override
        public ExecutionResult assertOutputContains(String expectedOutput) {
            assert (this.result.getOutput().contains(expectedOutput.trim()));
            return this;
        }

        @Override
        public ExecutionResult assertNotOutput(String expectedOutput) {
            assert (!this.result.getOutput().contains(expectedOutput.trim()));
            return this;
        }

        @Override
        public ExecutionResult assertHasPostBuildOutput(String expectedOutput) {
            return this;
        }

        private Set<String> findExecutedTasksInOrderStarted() {
            return this.result.getTasks().stream().map(BuildTask::getPath).collect(Collectors.toCollection(TreeSet::new));
        }

        private Set<String> getSkippedTasks() {
            return this.result.getTasks().stream().filter(it -> SKIPPED_TASK_OUTCOMES.contains(it.getOutcome())).map(BuildTask::getPath).collect(Collectors.toCollection(TreeSet::new));
        }

        private List<String> getExecutedTasks() {
            return new ArrayList<String>(this.findExecutedTasksInOrderStarted());
        }

        private Collection<String> getNotSkippedTasks() {
            TreeSet<String> all = new TreeSet<String>(this.getExecutedTasks());
            Set<String> skipped = this.getSkippedTasks();
            all.removeAll(skipped);
            return all;
        }

        @Override
        public ExecutionResult assertTaskNotSkipped(String taskPath) {
            Assert.assertThat(this.getExecutedTasks(), (Matcher)CoreMatchers.hasItem((Object)taskPath));
            return this;
        }

        @Override
        public ExecutionResult assertTaskSkipped(String taskPath) {
            Assert.assertThat(this.getSkippedTasks(), (Matcher)CoreMatchers.hasItem((Object)taskPath));
            return this;
        }
    }
}

