/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.file;

import dev.gradleplugins.test.fixtures.file.ExecOutput;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.util.TeeOutputStream;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.HashingOutputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class TestFile
extends File {
    public TestFile(File file, Object ... path) {
        super(TestFile.join(file, path).getAbsolutePath());
    }

    public TestFile(String path) {
        this(new File(path), new Object[0]);
    }

    private TestFile(File file, boolean followLinks) {
        super(file.getAbsolutePath());
    }

    public static TestFile of(File file, LinkOption ... options) {
        if (Arrays.asList(options).contains(LinkOption.NOFOLLOW_LINKS)) {
            return new TestFile(file, false);
        }
        return new TestFile(file, new Object[0]);
    }

    public TestFile assertExists() {
        Assert.assertTrue((String)String.format("%s does not exist", this), (boolean)this.exists());
        return this;
    }

    public TestFile assertDoesNotExist() {
        Assert.assertFalse((String)String.format("%s should not exist", this), (boolean)this.exists());
        return this;
    }

    public TestFile assertHasDescendants(String ... descendants) {
        TreeSet<String> actual = new TreeSet<String>();
        this.assertIsDirectory();
        this.visit(actual, "", this);
        TreeSet<String> expected = new TreeSet<String>(Arrays.asList(descendants));
        TreeSet<String> extras = new TreeSet<String>((Collection<String>)actual);
        extras.removeAll(expected);
        TreeSet<String> missing = new TreeSet<String>((Collection<String>)expected);
        missing.removeAll(actual);
        Assert.assertEquals((String)String.format("For dir: %s\n extra files: %s, missing files: %s, expected: %s", this, extras, missing, expected), expected, actual);
        return this;
    }

    private void visit(Set<String> names, String prefix, File file) {
        for (File child : file.listFiles()) {
            if (child.isFile()) {
                names.add(prefix + child.getName());
                continue;
            }
            if (!child.isDirectory()) continue;
            this.visit(names, prefix + child.getName() + "/", child);
        }
    }

    public TestFile assertIsFile() {
        Assert.assertTrue((String)String.format("%s is not a file", this), (boolean)this.isFile());
        return this;
    }

    public TestFile assertIsDirectory() {
        Assert.assertTrue((String)String.format("%s is not a directory", this), (boolean)this.isDirectory());
        return this;
    }

    public TestFile assertIsSymbolicLink() {
        Assert.assertTrue((String)String.format("%s is not a symbolic link", this), (boolean)this.isSymbolicLink());
        return this;
    }

    public TestFile assertIsEmptyDirectory() {
        this.assertIsDirectory();
        this.assertHasDescendants(new String[0]);
        return this;
    }

    public TestFile forceDeleteDir() throws IOException {
        if (this.isDirectory()) {
            if (Files.isSymbolicLink(this.toPath())) {
                if (!this.delete()) {
                    throw new IOException("Unable to delete symlink: " + this.getCanonicalPath());
                }
            } else {
                final ArrayList errorPaths = new ArrayList();
                Files.walkFileTree(this.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (!file.toFile().delete()) {
                            errorPaths.add(file.toFile().getCanonicalPath());
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (!dir.toFile().delete()) {
                            errorPaths.add(dir.toFile().getCanonicalPath());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                if (!errorPaths.isEmpty()) {
                    StringBuilder builder = new StringBuilder().append("Unable to recursively delete directory ").append(this.getCanonicalPath()).append(", failed paths:\n");
                    for (String errorPath : errorPaths) {
                        builder.append("\t- ").append(errorPath).append("\n");
                    }
                    throw new IOException(builder.toString());
                }
            }
        } else if (this.exists() && !this.delete()) {
            throw new IOException("Unable to delete file: " + this.getCanonicalPath());
        }
        return this;
    }

    public TestFile file(Object ... path) {
        try {
            return new TestFile((File)this, path);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Could not locate file '%s' relative to '%s'.", Arrays.toString(path), this), e);
        }
    }

    public TestFile createFile() {
        this.getParentFile().createDirectory();
        try {
            Assert.assertTrue((this.isFile() || this.createNewFile() ? 1 : 0) != 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public TestFile createFile(Object path) {
        return this.file(path).createFile();
    }

    public TestFile createDirectory(Object path) {
        return new TestFile((File)this, path).createDirectory();
    }

    public TestFile createDirectory() {
        if (this.mkdirs()) {
            return this;
        }
        if (this.isDirectory()) {
            return this;
        }
        throw new AssertionError((Object)("Problems creating dir: " + this + ". Diagnostics: exists=" + this.exists() + ", isFile=" + this.isFile() + ", isDirectory=" + this.isDirectory()));
    }

    public TestFile createSymbolicLink(File target) {
        this.getParentFile().createDirectory();
        try {
            Files.createSymbolicLink(this.toPath(), target.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public TestFile createSymbolicLink(String target) {
        return this.createSymbolicLink(new File(target));
    }

    private static File join(File file, Object[] path) {
        File current = file.getAbsoluteFile();
        for (Object p : path) {
            current = new File(current, p.toString());
        }
        try {
            return current.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not canonicalise '%s'.", current), e);
        }
    }

    public TestFile leftShift(Object content) {
        this.getParentFile().mkdirs();
        try {
            ResourceGroovyMethods.leftShift((File)this, (Object)content);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not append to test file '%s'", this), e);
        }
    }

    public TestFile write(Object content) {
        try {
            File parent;
            if (!(this.exists() || (parent = super.getParentFile()) == null || parent.mkdirs() || parent.isDirectory())) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
            Files.write(this.toPath(), content.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not write to test file '%s'", this), e);
        }
        return this;
    }

    public boolean isSelfOrDescendent(File file) {
        if (file.getAbsolutePath().equals(this.getAbsolutePath())) {
            return true;
        }
        return file.getAbsolutePath().startsWith(this.getAbsolutePath() + File.separatorChar);
    }

    @Override
    public TestFile getParentFile() {
        return super.getParentFile() == null ? null : new TestFile(super.getParentFile(), new Object[0]);
    }

    @Override
    public TestFile getAbsoluteFile() {
        return new TestFile(super.getAbsoluteFile(), new Object[0]);
    }

    public String getText() {
        this.assertIsFile();
        try {
            return new String(Files.readAllBytes(this.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not read from test file '%s'", this), e);
        }
    }

    public void setText(String content) {
        this.getParentFile().mkdirs();
        try {
            ResourceGroovyMethods.setText((File)this, (String)content);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not append to test file '%s'", this), e);
        }
    }

    public void copyTo(File target) {
        if (this.isDirectory()) {
            try {
                final Path targetDir = target.toPath();
                final Path sourceDir = this.toPath();
                Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path sourceFile, BasicFileAttributes attributes) throws IOException {
                        Path targetFile = targetDir.resolve(sourceDir.relativize(sourceFile));
                        Files.copy(sourceFile, targetFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
                        Path newDir = targetDir.resolve(sourceDir.relativize(dir));
                        Files.createDirectories(newDir, new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not copy test directory '%s' to '%s'", this, target), e);
            }
        }
        try {
            FileUtils.copyFile((File)this, (File)target);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not copy test file '%s' to '%s'", this, target), e);
        }
    }

    public boolean isSymbolicLink() {
        return Files.isSymbolicLink(this.toPath());
    }

    public ExecOutput exec(Object ... args) {
        CommandLine commandLine = new CommandLine((File)this);
        commandLine.addArguments(Arrays.toString(args));
        DefaultExecutor executor = new DefaultExecutor();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new TeeOutputStream((OutputStream)stdout, (OutputStream)System.out), (OutputStream)new TeeOutputStream((OutputStream)stderr, (OutputStream)System.err)));
        executor.setExitValue(0);
        try {
            int exitCode = executor.execute(commandLine, System.getenv());
            return new ExecOutput(exitCode, stdout.toString(), stderr.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ExecOutput execWithFailure(List<Object> args, List<Object> env) {
        CommandLine commandLine = new CommandLine((File)this);
        commandLine.addArguments(Arrays.toString(args.toArray(new Object[0])));
        DefaultExecutor executor = new DefaultExecutor();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new TeeOutputStream((OutputStream)stdout, (OutputStream)System.out), (OutputStream)new TeeOutputStream((OutputStream)stderr, (OutputStream)System.err)));
        try {
            Map<String, String> environment = env.stream().map(TestFile::toEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            int exitCode = executor.execute(commandLine, environment);
            Assert.assertThat((Object)exitCode, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)0)));
            return new ExecOutput(exitCode, stdout.toString(), stderr.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Map.Entry<String, String> toEntry(Object o) {
        String[] tokens = o.toString().split("=");
        Assert.assertThat((Object)tokens.length, (Matcher)Matchers.equalTo((Object)2));
        return new AbstractMap.SimpleEntry<String, String>(tokens[0], tokens[1]);
    }

    public ExecOutput execute(List<Object> args, List<Object> env) {
        CommandLine commandLine = new CommandLine((File)this);
        commandLine.addArguments(args.stream().map(Objects::toString).collect(Collectors.toList()).toArray(new String[0]));
        DefaultExecutor executor = new DefaultExecutor();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new TeeOutputStream((OutputStream)stdout, (OutputStream)System.out), (OutputStream)new TeeOutputStream((OutputStream)stderr, (OutputStream)System.err)));
        try {
            Map<String, String> environment = env.stream().map(TestFile::toEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            int exitCode = executor.execute(commandLine, environment);
            Assert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
            return new ExecOutput(exitCode, stdout.toString(), stderr.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Snapshot snapshot() {
        this.assertIsFile();
        return new Snapshot(this.lastModified(), TestFile.md5(this));
    }

    public static HashCode md5(File file) {
        HashingOutputStream hashingStream = Hashing.primitiveStreamHasher();
        try {
            Files.copy(file.toPath(), (OutputStream)hashingStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return hashingStream.hash();
    }

    public void assertHasChangedSince(Snapshot snapshot) {
        Snapshot now = this.snapshot();
        Assert.assertTrue((String)String.format("contents or modification time of %s have not changed", this), (now.modTime != snapshot.modTime || !now.hash.equals((Object)snapshot.hash) ? 1 : 0) != 0);
    }

    public void assertContentsHaveChangedSince(Snapshot snapshot) {
        Snapshot now = this.snapshot();
        Assert.assertNotEquals((String)String.format("contents of %s have not changed", this), (Object)snapshot.hash, (Object)now.hash);
    }

    public void assertContentsHaveNotChangedSince(Snapshot snapshot) {
        Snapshot now = this.snapshot();
        Assert.assertEquals((String)String.format("contents of %s has changed", this), (Object)snapshot.hash, (Object)now.hash);
    }

    public void assertHasNotChangedSince(Snapshot snapshot) {
        Snapshot now = this.snapshot();
        Assert.assertEquals((String)String.format("last modified time of %s has changed", this), (long)snapshot.modTime, (long)now.modTime);
        Assert.assertEquals((String)String.format("contents of %s has changed", this), (Object)snapshot.hash, (Object)now.hash);
    }

    public static class Snapshot {
        private final long modTime;
        private final HashCode hash;

        public Snapshot(long modTime, HashCode hash) {
            this.modTime = modTime;
            this.hash = hash;
        }

        public long getModTime() {
            return this.modTime;
        }

        public HashCode getHash() {
            return this.hash;
        }
    }
}

