/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.integtests.fixtures.nativeplatform;

import dev.gradleplugins.integtests.fixtures.AbstractContextualMultiVersionSpecRunner;
import dev.gradleplugins.integtests.fixtures.AbstractMultiTestRunner;
import dev.gradleplugins.integtests.fixtures.nativeplatform.AbstractInstalledToolChainIntegrationSpec;
import dev.gradleplugins.integtests.fixtures.nativeplatform.AvailableToolChains;
import dev.gradleplugins.integtests.fixtures.nativeplatform.RequiresInstalledToolChain;
import dev.gradleplugins.integtests.fixtures.nativeplatform.ToolChainRequirement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public class NativeToolChainTestRunner
extends AbstractContextualMultiVersionSpecRunner<AvailableToolChains.ToolChainCandidate> {
    public NativeToolChainTestRunner(Class<? extends AbstractInstalledToolChainIntegrationSpec> target) {
        super(target);
    }

    @Override
    protected Collection<AvailableToolChains.ToolChainCandidate> getPartialVersions() {
        List<AvailableToolChains.ToolChainCandidate> toolChains = AvailableToolChains.getToolChains();
        HashMap<AvailableToolChains.ToolFamily, AvailableToolChains.ToolChainCandidate> availableByFamily = new HashMap<AvailableToolChains.ToolFamily, AvailableToolChains.ToolChainCandidate>();
        for (AvailableToolChains.ToolChainCandidate toolChain : toolChains) {
            AvailableToolChains.ToolChainCandidate current;
            if (!this.canUseToolChain(toolChain) || (current = (AvailableToolChains.ToolChainCandidate)availableByFamily.get((Object)toolChain.getFamily())) != null && current.getVersion().compareTo(toolChain.getVersion()) >= 0) continue;
            availableByFamily.put(toolChain.getFamily(), toolChain);
        }
        return availableByFamily.values();
    }

    @Override
    protected Collection<AvailableToolChains.ToolChainCandidate> getAllVersions() {
        List<AvailableToolChains.ToolChainCandidate> toolChains = AvailableToolChains.getToolChains();
        return CollectionUtils.filter(toolChains, (Spec)new Spec<AvailableToolChains.ToolChainCandidate>(){

            public boolean isSatisfiedBy(AvailableToolChains.ToolChainCandidate toolChain) {
                return NativeToolChainTestRunner.this.canUseToolChain(toolChain);
            }
        });
    }

    @Override
    protected boolean isAvailable(AvailableToolChains.ToolChainCandidate version) {
        return version.isAvailable();
    }

    @Override
    protected Collection<AbstractMultiTestRunner.Execution> createExecutionsFor(AvailableToolChains.ToolChainCandidate versionedTool) {
        return Collections.singleton(new ToolChainExecution(versionedTool));
    }

    private boolean canUseToolChain(AvailableToolChains.ToolChainCandidate toolChain) {
        RequiresInstalledToolChain toolChainRequirement = this.target.getAnnotation(RequiresInstalledToolChain.class);
        if (toolChainRequirement != null) {
            return toolChain.meets(toolChainRequirement.value());
        }
        return !toolChain.meets(ToolChainRequirement.SWIFTC);
    }

    private static class ToolChainExecution
    extends AbstractMultiTestRunner.Execution {
        private final AvailableToolChains.ToolChainCandidate toolChain;

        public ToolChainExecution(AvailableToolChains.ToolChainCandidate toolChain) {
            this.toolChain = toolChain;
        }

        @Override
        protected String getDisplayName() {
            return this.toolChain.getDisplayName();
        }

        @Override
        protected boolean isTestEnabled(AbstractMultiTestRunner.TestDetails testDetails) {
            RequiresInstalledToolChain toolChainRestriction = testDetails.getAnnotation(RequiresInstalledToolChain.class);
            return toolChainRestriction == null || this.toolChain.meets(toolChainRestriction.value());
        }

        @Override
        protected void assertCanExecute() {
            assert (this.toolChain.isAvailable()) : String.format("Tool chain %s not available", this.toolChain.getDisplayName());
        }

        @Override
        protected void before() {
            System.out.println(String.format("Using tool chain %s", this.toolChain.getDisplayName()));
            AbstractInstalledToolChainIntegrationSpec.setToolChain((AvailableToolChains.InstalledToolChain)this.toolChain);
        }
    }
}

