/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.integtests.fixtures;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.spockframework.runtime.Sputnik;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.NameProvider;
import org.spockframework.runtime.model.SpecInfo;

public abstract class AbstractMultiTestRunner
extends Runner
implements Filterable {
    protected final Class<?> target;
    private final List<Execution> executions = new ArrayList<Execution>();
    private final boolean runAllExecutions;
    private Description description;
    private Description templateDescription;
    private boolean executionsInitialized;

    protected AbstractMultiTestRunner(Class<?> target) {
        this(target, true);
    }

    protected AbstractMultiTestRunner(Class<?> target, boolean runAllExecutions) {
        this.target = target;
        this.runAllExecutions = runAllExecutions;
    }

    public Description getDescription() {
        this.initDescription();
        return this.description;
    }

    public void run(RunNotifier notifier) {
        this.initDescription();
        for (Execution execution : this.executions) {
            execution.run(notifier);
            if (this.runAllExecutions || !execution.hasAnyEnabledTests()) continue;
            break;
        }
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.initExecutions();
        for (Execution execution : this.executions) {
            execution.filter(filter);
        }
        this.invalidateDescription();
    }

    private void initExecutions() {
        if (!this.executionsInitialized) {
            try {
                UnrollAwareSuite descriptionProvider = AbstractMultiTestRunner.createRunnerFor(Collections.singletonList(this.target), Collections.emptyList(), null);
                this.templateDescription = descriptionProvider.getDescription();
            }
            catch (InitializationError initializationError) {
                throw new RuntimeException(initializationError);
            }
            this.createExecutions();
            for (Execution execution : this.executions) {
                execution.init(this.target, this.templateDescription);
            }
            this.executionsInitialized = true;
        }
    }

    private void initDescription() {
        this.initExecutions();
        if (this.description == null) {
            this.description = Description.createSuiteDescription(this.target);
            for (Execution execution : this.executions) {
                execution.addDescriptions(this.description);
            }
        }
    }

    private void invalidateDescription() {
        this.description = null;
        this.templateDescription = null;
    }

    protected abstract void createExecutions();

    protected void add(Execution execution) {
        this.executions.add(execution);
    }

    private static UnrollAwareSuite createRunnerFor(List<? extends Class<?>> targetClasses, final List<Filter> filters, Execution execution) throws InitializationError {
        RunnerBuilder runnerBuilder = new RunnerBuilder(){

            public Runner runnerForClass(Class<?> testClass) throws Throwable {
                for (Class<?> candidate = testClass; candidate != null; candidate = candidate.getSuperclass()) {
                    RunWith runWith = candidate.getAnnotation(RunWith.class);
                    if (runWith == null || AbstractMultiTestRunner.class.isAssignableFrom(runWith.value())) continue;
                    try {
                        Runner r = (Runner)runWith.value().getConstructors()[0].newInstance(testClass);
                        return this.filter(r);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
                return this.filter((Runner)new BlockJUnit4ClassRunner(testClass));
            }

            private Runner filter(Runner r) {
                for (Filter filter : filters) {
                    try {
                        ((Filterable)r).filter(filter);
                    }
                    catch (NoTestsRemainException noTestsRemainException) {}
                }
                return r;
            }
        };
        return new UnrollAwareSuite(runnerBuilder, targetClasses.toArray(new Class[0]), execution);
    }

    private static class TestDescriptionBackedTestDetails
    implements TestDetails {
        private final Description parent;
        private final Description test;

        private TestDescriptionBackedTestDetails(Description parent, Description test) {
            this.parent = parent;
            this.test = test;
        }

        public String toString() {
            return this.test.toString();
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> type) {
            Annotation annotation = this.test.getAnnotation(type);
            if (annotation != null) {
                return (A)annotation;
            }
            return (A)this.parent.getAnnotation(type);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.test.getAnnotations().toArray(new Annotation[0]);
        }
    }

    public static interface TestDetails {
        @Nullable
        public <A extends Annotation> A getAnnotation(Class<A> var1);

        public Annotation[] getAnnotations();
    }

    protected static abstract class Execution
    implements Filterable {
        protected Class<?> target;
        private Description templateDescription;
        private final Map<Description, Description> descriptionTranslations = new HashMap<Description, Description>();
        private final Set<Description> enabledTests = new LinkedHashSet<Description>();
        private final Set<Description> disabledTests = new LinkedHashSet<Description>();
        private final List<Filter> filters = new LinkedList<Filter>();

        protected Execution() {
        }

        final boolean hasAnyEnabledTests() {
            return !this.enabledTests.isEmpty();
        }

        final void init(Class<?> target, Description templateDescription) {
            this.target = target;
            this.templateDescription = templateDescription;
        }

        private Runner createExecutionRunner() throws InitializationError {
            List<? extends Class<?>> targetClasses = this.loadTargetClasses();
            return AbstractMultiTestRunner.createRunnerFor(targetClasses, this.filters, this);
        }

        final void addDescriptions(Description parent) {
            this.map(this.templateDescription, parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void run(RunNotifier notifier) {
            RunNotifier nested = new RunNotifier();
            NestedRunListener nestedListener = new NestedRunListener(notifier);
            nested.addListener((RunListener)nestedListener);
            try {
                this.runEnabledTests(nested);
            }
            finally {
                nestedListener.cleanup();
            }
            for (Description disabledTest : this.disabledTests) {
                nested.fireTestIgnored(disabledTest);
            }
        }

        private void runEnabledTests(RunNotifier nested) {
            Runner runner;
            if (this.enabledTests.isEmpty()) {
                return;
            }
            try {
                runner = this.createExecutionRunner();
            }
            catch (Throwable t) {
                runner = new CannotExecuteRunner(this.getDisplayName(), this.target, t);
            }
            try {
                if (!this.disabledTests.isEmpty()) {
                    ((Filterable)runner).filter(new Filter(){

                        public boolean shouldRun(Description description) {
                            return !disabledTests.contains(description);
                        }

                        public String describe() {
                            return "disabled tests";
                        }
                    });
                }
            }
            catch (NoTestsRemainException e) {
                return;
            }
            runner.run(nested);
        }

        private Description translateDescription(Description description) {
            return this.descriptionTranslations.containsKey(description) ? this.descriptionTranslations.get(description) : description;
        }

        public void filter(Filter filter) throws NoTestsRemainException {
            this.filters.add(filter);
            for (Map.Entry<Description, Description> entry : this.descriptionTranslations.entrySet()) {
                if (filter.shouldRun(entry.getKey())) continue;
                this.enabledTests.remove(entry.getValue());
                this.disabledTests.remove(entry.getValue());
            }
        }

        protected void before() {
        }

        protected void after() {
        }

        private void map(Description source, Description parent) {
            for (Description child : source.getChildren()) {
                Description mappedChild;
                if (child.getMethodName() != null) {
                    mappedChild = Description.createSuiteDescription((String)String.format("%s [%s](%s)", child.getMethodName(), this.getDisplayName(), child.getClassName()), (Annotation[])new Annotation[0]);
                    parent.addChild(mappedChild);
                    if (!this.isTestEnabled(new TestDescriptionBackedTestDetails(source, child))) {
                        this.disabledTests.add(child);
                    } else {
                        this.enabledTests.add(child);
                    }
                } else {
                    mappedChild = Description.createSuiteDescription((String)child.getClassName(), (Annotation[])new Annotation[0]);
                }
                this.descriptionTranslations.put(child, mappedChild);
                this.map(child, parent);
            }
        }

        protected abstract String getDisplayName();

        protected boolean isTestEnabled(TestDetails testDetails) {
            return true;
        }

        protected void assertCanExecute() {
        }

        protected List<? extends Class<?>> loadTargetClasses() {
            return Collections.singletonList(this.target);
        }

        private class NestedRunListener
        extends RunListener {
            private final RunNotifier notifier;
            boolean started;
            boolean complete;

            public NestedRunListener(RunNotifier notifier) {
                this.notifier = notifier;
            }

            public void testStarted(Description description) {
                Description translated = Execution.this.translateDescription(description);
                this.notifier.fireTestStarted(translated);
                if (!this.started && !this.complete) {
                    try {
                        Execution.this.assertCanExecute();
                        this.started = true;
                        Execution.this.before();
                    }
                    catch (Throwable t) {
                        this.notifier.fireTestFailure(new Failure(translated, t));
                    }
                }
            }

            public void testFailure(Failure failure) {
                Description translated = Execution.this.translateDescription(failure.getDescription());
                this.notifier.fireTestFailure(new Failure(translated, failure.getException()));
            }

            public void testAssumptionFailure(Failure failure) {
                Description translated = Execution.this.translateDescription(failure.getDescription());
                this.notifier.fireTestAssumptionFailed(new Failure(translated, failure.getException()));
            }

            public void testIgnored(Description description) {
                Description translated = Execution.this.translateDescription(description);
                this.notifier.fireTestIgnored(translated);
            }

            public void testFinished(Description description) {
                Description translated = Execution.this.translateDescription(description);
                this.notifier.fireTestFinished(translated);
            }

            public void cleanup() {
                if (this.started) {
                    Execution.this.after();
                }
                this.complete = true;
            }
        }

        private static class CannotExecuteRunner
        extends Runner {
            private final Description description;
            private final Throwable failure;

            public CannotExecuteRunner(String displayName, Class<?> testClass, Throwable failure) {
                this.description = Description.createSuiteDescription((String)String.format("%s(%s)", displayName, testClass.getName()), (Annotation[])new Annotation[0]);
                this.failure = failure;
            }

            public Description getDescription() {
                return this.description;
            }

            public void run(RunNotifier notifier) {
                Description description = this.getDescription();
                notifier.fireTestStarted(description);
                notifier.fireTestFailure(new Failure(description, this.failure));
                notifier.fireTestFinished(description);
            }
        }
    }

    private static class UnrollAwareSuite
    extends Suite {
        private static final Method SPEC_METHOD;

        public UnrollAwareSuite(RunnerBuilder builder, Class<?>[] classes, Execution execution) throws InitializationError {
            super(builder, (Class[])classes);
            if (execution != null) {
                this.fixupNameProvider(execution);
            }
        }

        private void fixupNameProvider(final Execution execution) {
            for (Runner child : this.getChildren()) {
                if (!(child instanceof Sputnik) || SPEC_METHOD == null) continue;
                try {
                    Description childDescription = child.getDescription();
                    SpecInfo spec = (SpecInfo)SPEC_METHOD.invoke((Object)child, new Object[0]);
                    List allFeatures = spec.getAllFeatures();
                    Iterator iterator = allFeatures.iterator();
                    while (iterator.hasNext()) {
                        FeatureInfo feature;
                        feature.setSkipped((feature = (FeatureInfo)iterator.next()).isSkipped() || !execution.isTestEnabled(new TestDescriptionBackedTestDetails(childDescription, feature.getDescription())));
                        final NameProvider provider = feature.getIterationNameProvider();
                        if (provider == null) continue;
                        feature.setIterationNameProvider((NameProvider)new NameProvider<IterationInfo>(){

                            public String getName(IterationInfo iterationInfo) {
                                return provider.getName((Object)iterationInfo) + " [" + execution.getDisplayName() + "]";
                            }
                        });
                    }
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                }
            }
        }

        static {
            Method spec = null;
            try {
                spec = Sputnik.class.getDeclaredMethod("getSpec", new Class[0]);
                spec.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                spec = null;
            }
            finally {
                SPEC_METHOD = spec;
            }
        }
    }
}

