/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.integtests.fixtures;

import com.google.common.collect.Iterables;
import dev.gradleplugins.integtests.fixtures.AbstractMultiTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public abstract class AbstractContextualMultiVersionSpecRunner<T extends VersionedTool>
extends AbstractMultiTestRunner {
    public static final String VERSIONS_SYSPROP_NAME = "org.gradle.integtest.versions";

    protected abstract Collection<T> getAllVersions();

    protected Collection<T> getQuickVersions() {
        for (VersionedTool next : this.getAllVersions()) {
            if (!this.isAvailable(next)) continue;
            return Collections.singleton(next);
        }
        return Collections.emptyList();
    }

    protected Collection<T> getPartialVersions() {
        T lastAvailable;
        Collection<T> allVersions = this.getAllVersions();
        HashSet<T> partialVersions = new HashSet<T>();
        T firstAvailable = this.getFirstAvailable(allVersions);
        if (firstAvailable != null) {
            partialVersions.add(firstAvailable);
        }
        if ((lastAvailable = this.getLastAvailable(allVersions)) != null) {
            partialVersions.add(lastAvailable);
        }
        return partialVersions;
    }

    private Collection<T> getAvailableVersions() {
        HashSet allAvailable = new HashSet();
        CollectionUtils.filter(this.getAllVersions(), allAvailable, (Spec)new Spec<T>(){

            public boolean isSatisfiedBy(T version) {
                return AbstractContextualMultiVersionSpecRunner.this.isAvailable(version);
            }
        });
        return allAvailable;
    }

    private T getFirstAvailable(Collection<T> versions) {
        for (VersionedTool next : versions) {
            if (!this.isAvailable(next)) continue;
            return (T)next;
        }
        return null;
    }

    private T getLastAvailable(Collection<T> versions) {
        VersionedTool lastAvailable = null;
        for (VersionedTool next : versions) {
            if (!this.isAvailable(next)) continue;
            lastAvailable = next;
        }
        return (T)lastAvailable;
    }

    protected abstract boolean isAvailable(T var1);

    protected abstract Collection<AbstractMultiTestRunner.Execution> createExecutionsFor(T var1);

    public AbstractContextualMultiVersionSpecRunner(Class<?> target) {
        super(target);
    }

    @Override
    protected void createExecutions() {
        String versions = System.getProperty(VERSIONS_SYSPROP_NAME, CoverageContext.DEFAULT.selector);
        CoverageContext coverageContext = CoverageContext.from(versions);
        if (coverageContext == CoverageContext.UNKNOWN) {
            ArrayList<String> selectionCriteria = new ArrayList<String>(Arrays.asList(versions.split(",")));
            this.createSelectedExecutions(selectionCriteria);
        } else {
            this.createExecutionsForContext(coverageContext);
        }
    }

    protected void createExecutionsForContext(CoverageContext coverageContext) {
        HashSet<T> versionsUnderTest = new HashSet<T>();
        switch (coverageContext) {
            case DEFAULT: 
            case LATEST: {
                versionsUnderTest.addAll(this.getQuickVersions());
                break;
            }
            case PARTIAL: {
                versionsUnderTest.addAll(this.getPartialVersions());
                break;
            }
            case FULL: {
                versionsUnderTest.addAll(this.getAvailableVersions());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        for (VersionedTool version : versionsUnderTest) {
            for (AbstractMultiTestRunner.Execution execution : this.createExecutionsFor(version)) {
                this.add(execution);
            }
        }
    }

    private void createSelectedExecutions(List<String> selectionCriteria) {
        Collection<T> possibleVersions = this.getAllVersions();
        HashSet<Object> versionsUnderTest = new HashSet<Object>();
        for (String string : selectionCriteria) {
            if ("latest".equals(string)) {
                versionsUnderTest.add(Iterables.getLast(possibleVersions));
                continue;
            }
            for (VersionedTool version : possibleVersions) {
                if (!this.isAvailable(version) || !version.matches(string)) continue;
                versionsUnderTest.add(version);
            }
        }
        for (VersionedTool versionedTool : versionsUnderTest) {
            for (AbstractMultiTestRunner.Execution execution : this.createExecutionsFor(versionedTool)) {
                this.add(execution);
            }
        }
    }

    public static interface VersionedTool {
        public boolean matches(String var1);
    }

    protected static enum CoverageContext {
        DEFAULT("default"),
        LATEST("latest"),
        PARTIAL("partial"),
        FULL("all"),
        UNKNOWN(null);

        final String selector;

        private CoverageContext(String selector) {
            this.selector = selector;
        }

        static CoverageContext from(String requested) {
            for (CoverageContext context : CoverageContext.values()) {
                if (context == UNKNOWN || !context.selector.equals(requested)) continue;
                return context;
            }
            return UNKNOWN;
        }
    }
}

