/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.integtests.fixtures.nativeplatform;

import com.google.common.collect.ImmutableSet;
import dev.gradleplugins.integtests.fixtures.AbstractMultiVersionSpecRunner;
import dev.gradleplugins.integtests.fixtures.nativeplatform.ExecutableFixture;
import dev.gradleplugins.integtests.fixtures.nativeplatform.LinkerOptionsFixture;
import dev.gradleplugins.integtests.fixtures.nativeplatform.NativeBinaryFixture;
import dev.gradleplugins.integtests.fixtures.nativeplatform.SharedLibraryFixture;
import dev.gradleplugins.integtests.fixtures.nativeplatform.StaticLibraryFixture;
import dev.gradleplugins.integtests.fixtures.nativeplatform.ToolChainRequirement;
import dev.gradleplugins.integtests.fixtures.nativeplatform.internal.NativeServicesTestFixture;
import dev.gradleplugins.integtests.fixtures.nativeplatform.internal.TestFiles;
import dev.gradleplugins.integtests.fixtures.nativeplatform.msvcpp.VisualStudioLocatorTestFixture;
import dev.gradleplugins.integtests.fixtures.nativeplatform.msvcpp.VisualStudioVersion;
import dev.gradleplugins.runnerkit.GradleRunner;
import dev.gradleplugins.test.fixtures.file.TestFile;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.specs.Spec;
import org.gradle.internal.FileUtils;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.Swiftc;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccMetadata;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccMetadataProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCpp;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioInstall;
import org.gradle.nativeplatform.toolchain.internal.swift.metadata.SwiftcMetadata;
import org.gradle.nativeplatform.toolchain.internal.swift.metadata.SwiftcMetadataProvider;
import org.gradle.nativeplatform.toolchain.plugins.ClangCompilerPlugin;
import org.gradle.nativeplatform.toolchain.plugins.GccCompilerPlugin;
import org.gradle.nativeplatform.toolchain.plugins.MicrosoftVisualCppCompilerPlugin;
import org.gradle.nativeplatform.toolchain.plugins.SwiftCompilerPlugin;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;
import org.gradle.util.VersionNumber;

public class AvailableToolChains {
    private static final Comparator<ToolChainCandidate> LATEST_RELEASED_FIRST = Collections.reverseOrder(new Comparator<ToolChainCandidate>(){

        @Override
        public int compare(ToolChainCandidate toolchain1, ToolChainCandidate toolchain2) {
            return toolchain1.getVersion().compareTo(toolchain2.getVersion());
        }
    });
    private static List<ToolChainCandidate> toolChains;

    @Nullable
    public static InstalledToolChain getDefaultToolChain() {
        for (ToolChainCandidate toolChain : AvailableToolChains.getToolChains()) {
            if (!toolChain.isAvailable()) continue;
            return (InstalledToolChain)toolChain;
        }
        return null;
    }

    @Nullable
    public static InstalledToolChain getToolChain(ToolChainRequirement requirement) {
        for (ToolChainCandidate toolChainCandidate : AvailableToolChains.getToolChains()) {
            if (!toolChainCandidate.meets(requirement)) continue;
            assert (toolChainCandidate.isAvailable());
            return (InstalledToolChain)toolChainCandidate;
        }
        return null;
    }

    public static List<ToolChainCandidate> getToolChains() {
        if (toolChains == null) {
            ArrayList<ToolChainCandidate> compilers = new ArrayList<ToolChainCandidate>();
            if (OperatingSystem.current().isWindows()) {
                compilers.addAll(AvailableToolChains.findVisualCpps());
                compilers.add(AvailableToolChains.findMinGW());
                compilers.add(AvailableToolChains.findCygwin());
            } else if (OperatingSystem.current().isMacOsX()) {
                compilers.addAll(AvailableToolChains.findClangs(true));
                compilers.addAll(AvailableToolChains.findGccs(false));
                compilers.addAll(AvailableToolChains.findSwiftcs());
            } else {
                compilers.addAll(AvailableToolChains.findGccs(true));
                compilers.addAll(AvailableToolChains.findClangs(false));
                compilers.addAll(AvailableToolChains.findSwiftcs());
            }
            toolChains = compilers;
        }
        return toolChains;
    }

    private static List<ToolChainCandidate> findClangs(boolean mustFind) {
        ArrayList<ToolChainCandidate> toolChains = new ArrayList<ToolChainCandidate>();
        if (OperatingSystem.current().isMacOsX()) {
            toolChains.addAll(AvailableToolChains.findXcodes().stream().map(InstalledXcode::getClang).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        } else {
            GccMetadataProvider versionDeterminer = GccMetadataProvider.forClang((ExecActionFactory)TestFiles.execActionFactory());
            Set<File> clangCandidates = Collections.unmodifiableSet(new HashSet(OperatingSystem.current().findAllInPath("clang")));
            if (!clangCandidates.isEmpty()) {
                File firstInPath = clangCandidates.iterator().next();
                for (File candidate : clangCandidates) {
                    SearchResult version = versionDeterminer.getCompilerMetaData(Collections.emptyList(), spec -> spec.executable(candidate));
                    if (!version.isAvailable()) continue;
                    InstalledClang clang = new InstalledClang(((GccMetadata)version.getComponent()).getVersion());
                    if (!candidate.equals(firstInPath)) {
                        clang.inPath(candidate.getParentFile());
                    }
                    toolChains.add(clang);
                }
            }
        }
        if (mustFind && toolChains.isEmpty()) {
            toolChains.add(new UnavailableToolChain(ToolFamily.CLANG));
        }
        toolChains.sort(LATEST_RELEASED_FIRST);
        return toolChains;
    }

    private static boolean isTestableVisualStudioVersion(VersionNumber version) {
        return AvailableToolChains.getVisualStudioVersion(version) != null;
    }

    private static VisualStudioVersion getVisualStudioVersion(final VersionNumber version) {
        return (VisualStudioVersion)((Object)CollectionUtils.findFirst((Object[])VisualStudioVersion.values(), (Spec)new Spec<VisualStudioVersion>(){

            public boolean isSatisfiedBy(VisualStudioVersion candidate) {
                return candidate.getVersion().getMajor() == version.getMajor();
            }
        }));
    }

    private static List<ToolChainCandidate> findVisualCpps() {
        List searchResults = VisualStudioLocatorTestFixture.getVisualStudioLocator().locateAllComponents();
        ArrayList<ToolChainCandidate> toolChains = new ArrayList<ToolChainCandidate>();
        for (VisualStudioInstall install : searchResults) {
            if (!AvailableToolChains.isTestableVisualStudioVersion(install.getVersion())) continue;
            toolChains.add(new InstalledVisualCpp(AvailableToolChains.getVisualStudioVersion(install.getVersion())).withInstall(install));
        }
        if (toolChains.isEmpty()) {
            toolChains.add(new UnavailableToolChain(ToolFamily.VISUAL_CPP));
        }
        toolChains.sort(LATEST_RELEASED_FIRST);
        return toolChains;
    }

    private static ToolChainCandidate findMinGW() {
        File compiler32Exe;
        File compiler64Exe = new File("C:/mingw64/bin/g++.exe");
        if (compiler64Exe.isFile() && (compiler32Exe = new File("C:/mingw32/bin/g++.exe")).isFile()) {
            return new InstalledMingwGcc(VersionNumber.UNKNOWN).inPath(compiler64Exe.getParentFile(), compiler32Exe.getParentFile());
        }
        return new UnavailableToolChain(ToolFamily.MINGW_GCC);
    }

    private static ToolChainCandidate findCygwin() {
        File compiler64Exe = new File("C:/cygwin64/bin/g++.exe");
        if (compiler64Exe.isFile()) {
            File compiler32Exe = new File("C:/cygwin64/bin/i686-pc-cygwin-gcc.exe");
            if (compiler32Exe.isFile()) {
                File cygwin32RuntimePath = new File(compiler32Exe.getParentFile().getParentFile(), "usr/i686-pc-cygwin/sys-root/usr/bin");
                return new InstalledCygwinGcc(VersionNumber.UNKNOWN).inPath(compiler64Exe.getParentFile(), cygwin32RuntimePath);
            }
            return new UnavailableToolChain(ToolFamily.CYGWIN_GCC);
        }
        return new UnavailableToolChain(ToolFamily.CYGWIN_GCC);
    }

    private static List<ToolChainCandidate> findGccs(boolean mustFind) {
        GccMetadataProvider versionDeterminer = GccMetadataProvider.forGcc((ExecActionFactory)TestFiles.execActionFactory());
        ImmutableSet gppCandidates = ImmutableSet.builder().addAll((Iterable)OperatingSystem.current().findAllInPath("g++")).addAll((Iterable)OperatingSystem.current().findAllInPath("g++-8")).build();
        ArrayList<ToolChainCandidate> toolChains = new ArrayList<ToolChainCandidate>();
        if (!gppCandidates.isEmpty()) {
            File firstInPath = (File)gppCandidates.iterator().next();
            for (File candidate : gppCandidates) {
                SearchResult version = versionDeterminer.getCompilerMetaData(Collections.emptyList(), spec -> spec.executable(candidate));
                if (!version.isAvailable()) continue;
                InstalledGcc gcc = new InstalledGcc(ToolFamily.GCC, ((GccMetadata)version.getComponent()).getVersion());
                if (!candidate.equals(firstInPath)) {
                    gcc.inPath(candidate.getParentFile());
                }
                if (!candidate.getName().equals("g++") && !candidate.getName().startsWith("g++.")) {
                    String suffix = FileUtils.removeExtension((String)candidate.getName()).substring("g++".length());
                    gcc = gcc.withSuffix(suffix);
                }
                toolChains.add(gcc);
            }
        }
        if (mustFind && toolChains.isEmpty()) {
            toolChains.add(new UnavailableToolChain(ToolFamily.GCC));
        }
        toolChains.sort(LATEST_RELEASED_FIRST);
        return toolChains;
    }

    static List<ToolChainCandidate> findSwiftcs() {
        File[] swiftCandidates;
        ArrayList<ToolChainCandidate> toolChains = new ArrayList<ToolChainCandidate>();
        SwiftcMetadataProvider versionDeterminer = new SwiftcMetadataProvider(TestFiles.execActionFactory());
        File rootSwiftInstall = new File("/opt/swift");
        for (File swiftInstall : swiftCandidates = (File[])GUtil.elvis((Object)rootSwiftInstall.listFiles(new FileFilter(){

            @Override
            public boolean accept(File swiftInstall) {
                return swiftInstall.isDirectory() && !swiftInstall.getName().equals("latest");
            }
        }), (Object)new File[0])) {
            File swiftc = new File(swiftInstall, "/usr/bin/swiftc");
            SearchResult version = versionDeterminer.getCompilerMetaData(Collections.emptyList(), spec -> spec.executable(swiftc));
            if (!version.isAvailable()) continue;
            File binDir = swiftc.getParentFile();
            toolChains.add(new InstalledSwiftc(binDir, ((SwiftcMetadata)version.getComponent()).getVersion()).inPath(binDir, new File("/usr/bin")));
        }
        toolChains.addAll(AvailableToolChains.findXcodes().stream().map(InstalledXcode::getSwiftc).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        List swiftcCandidates = OperatingSystem.current().findAllInPath("swiftc");
        for (File candidate : swiftcCandidates) {
            SearchResult version = versionDeterminer.getCompilerMetaData(Collections.emptyList(), spec -> spec.executable(candidate));
            if (!version.isAvailable()) continue;
            File binDir = candidate.getParentFile();
            InstalledSwiftc swiftc = new InstalledSwiftc(binDir, ((SwiftcMetadata)version.getComponent()).getVersion());
            swiftc.inPath(binDir, new File("/usr/bin"));
            toolChains.add(swiftc);
        }
        if (toolChains.isEmpty()) {
            toolChains.add(new UnavailableToolChain(ToolFamily.SWIFTC));
        } else {
            toolChains.sort(LATEST_RELEASED_FIRST);
        }
        return toolChains;
    }

    static List<InstalledXcode> findXcodes() {
        ArrayList<InstalledXcode> xcodes = new ArrayList<InstalledXcode>();
        File rootXcodeInstall = new File("/opt/xcode");
        ArrayList<Object> xcodeCandidates = new ArrayList<Object>(Arrays.asList((Object[])GUtil.elvis((Object)rootXcodeInstall.listFiles(xcodeInstall -> xcodeInstall.isDirectory()), (Object)new File[0])));
        xcodeCandidates.add(new File("/Applications/Xcode.app"));
        xcodeCandidates.stream().filter(File::exists).forEach(xcodeInstall -> {
            TestFile xcodebuild = new TestFile("/usr/bin/xcodebuild");
            String output = xcodebuild.execute(Collections.singletonList("-version"), Collections.singletonList("DEVELOPER_DIR=" + xcodeInstall.getAbsolutePath())).getOut();
            Pattern versionRegex = Pattern.compile("Xcode (\\d+\\.\\d+(\\.\\d+)?)");
            Matcher matcher = versionRegex.matcher(output);
            if (matcher.find()) {
                VersionNumber version = VersionNumber.parse((String)matcher.group(1));
                xcodes.add(new InstalledXcode((File)xcodeInstall, version));
            }
        });
        return xcodes;
    }

    public static class UnavailableToolChain
    extends ToolChainCandidate {
        private final ToolFamily family;

        public UnavailableToolChain(ToolFamily family) {
            this.family = family;
        }

        @Override
        public boolean meets(ToolChainRequirement requirement) {
            return false;
        }

        @Override
        public String getDisplayName() {
            return this.family.displayName;
        }

        @Override
        public ToolFamily getFamily() {
            return this.family;
        }

        @Override
        public VersionNumber getVersion() {
            return VersionNumber.UNKNOWN;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void initialiseEnvironment() {
            throw new UnsupportedOperationException("Toolchain is not available");
        }

        @Override
        public void resetEnvironment() {
            throw new UnsupportedOperationException("Toolchain is not available");
        }

        @Override
        public boolean matches(String criteria) {
            return false;
        }
    }

    public static class InstalledClang
    extends GccCompatibleToolChain {
        public InstalledClang(VersionNumber versionNumber) {
            super(ToolFamily.CLANG, versionNumber);
        }

        @Override
        public boolean meets(ToolChainRequirement requirement) {
            switch (requirement) {
                case AVAILABLE: 
                case CLANG: 
                case GCC_COMPATIBLE: {
                    return true;
                }
                case SUPPORTS_32: 
                case SUPPORTS_32_AND_64: {
                    return !OperatingSystem.current().isMacOsX() || this.getVersion().compareTo(VersionNumber.parse((String)"10.0.0")) < 0;
                }
            }
            return false;
        }

        @Override
        public String getBuildScriptConfig() {
            String config = String.format("%s(%s)\n", this.getId(), this.getImplementationClass());
            for (File pathEntry : this.getPathEntries()) {
                config = config + String.format("%s.path file('%s')\n", this.getId(), pathEntry.toURI());
            }
            return config;
        }

        @Override
        public File getCppCompiler() {
            return this.find("clang++");
        }

        @Override
        public File getCCompiler() {
            return this.find("clang");
        }

        @Override
        public String getInstanceDisplayName() {
            return String.format("Tool chain '%s' (Clang)", this.getId());
        }

        @Override
        public String getImplementationClass() {
            return Clang.class.getSimpleName();
        }

        @Override
        public String getPluginClass() {
            return ClangCompilerPlugin.class.getSimpleName();
        }
    }

    public static class InstalledVisualCpp
    extends InstalledToolChain {
        private final String displayVersion;
        private VersionNumber version;
        private File installDir;
        private File cppCompiler;

        public InstalledVisualCpp(VisualStudioVersion version) {
            super(ToolFamily.VISUAL_CPP, version.getVersion());
            this.displayVersion = version.getYear() + " (" + version.getVersion().toString() + ")";
        }

        @Override
        public String getDisplayName() {
            return this.getFamily().displayName + " " + this.displayVersion;
        }

        @Override
        public String getId() {
            return "visualCpp";
        }

        public InstalledVisualCpp withInstall(VisualStudioInstall install) {
            DefaultNativePlatform targetPlatform = new DefaultNativePlatform("default");
            this.installDir = install.getVisualStudioDir();
            this.version = install.getVersion();
            VisualCpp visualCpp = install.getVisualCpp().forPlatform((NativePlatformInternal)targetPlatform);
            this.cppCompiler = visualCpp.getCompilerExecutable();
            this.pathEntries.addAll(visualCpp.getPath());
            return this;
        }

        @Override
        public boolean meets(ToolChainRequirement requirement) {
            switch (requirement) {
                case SUPPORTS_32: 
                case SUPPORTS_32_AND_64: 
                case AVAILABLE: 
                case VISUALCPP: {
                    return true;
                }
                case VISUALCPP_2012_OR_NEWER: {
                    return this.version.compareTo(VisualStudioVersion.VISUALSTUDIO_2012.getVersion()) >= 0;
                }
                case VISUALCPP_2013: {
                    return this.version.equals((Object)VisualStudioVersion.VISUALSTUDIO_2013.getVersion());
                }
                case VISUALCPP_2013_OR_NEWER: {
                    return this.version.compareTo(VisualStudioVersion.VISUALSTUDIO_2013.getVersion()) >= 0;
                }
                case VISUALCPP_2015: {
                    return this.version.equals((Object)VisualStudioVersion.VISUALSTUDIO_2015.getVersion());
                }
                case VISUALCPP_2015_OR_NEWER: {
                    return this.version.compareTo(VisualStudioVersion.VISUALSTUDIO_2015.getVersion()) >= 0;
                }
                case VISUALCPP_2017: {
                    return this.version.equals((Object)VisualStudioVersion.VISUALSTUDIO_2017.getVersion());
                }
                case VISUALCPP_2017_OR_NEWER: {
                    return this.version.compareTo(VisualStudioVersion.VISUALSTUDIO_2017.getVersion()) >= 0;
                }
                case VISUALCPP_2019: {
                    return this.version.equals((Object)VisualStudioVersion.VISUALSTUDIO_2019.getVersion());
                }
                case VISUALCPP_2019_OR_NEWER: {
                    return this.version.compareTo(VisualStudioVersion.VISUALSTUDIO_2019.getVersion()) >= 0;
                }
            }
            return false;
        }

        @Override
        public String getBuildScriptConfig() {
            String config = String.format("%s(%s)\n", this.getId(), this.getImplementationClass());
            if (this.installDir != null) {
                config = config + String.format("%s.installDir = file('%s')", this.getId(), this.installDir.toURI());
            }
            return config;
        }

        @Override
        public String getImplementationClass() {
            return org.gradle.nativeplatform.toolchain.VisualCpp.class.getSimpleName();
        }

        @Override
        public String getInstanceDisplayName() {
            return String.format("Tool chain '%s' (Visual Studio)", this.getId());
        }

        @Override
        public String getPluginClass() {
            return MicrosoftVisualCppCompilerPlugin.class.getSimpleName();
        }

        @Override
        public boolean isVisualCpp() {
            return true;
        }

        @Override
        public VersionNumber getVersion() {
            return this.version;
        }

        public File getCppCompiler() {
            return this.cppCompiler;
        }

        @Override
        public TestFile objectFile(Object path) {
            return new TestFile(path.toString() + ".obj");
        }

        @Override
        public String getUnitTestPlatform() {
            switch (this.version.getMajor()) {
                case 12: {
                    return "vs2013";
                }
                case 14: {
                    return "vs2015";
                }
            }
            return "UNKNOWN";
        }
    }

    public static class InstalledXcode {
        private static final ProcessEnvironment PROCESS_ENVIRONMENT = (ProcessEnvironment)NativeServicesTestFixture.getInstance().get(ProcessEnvironment.class);
        private final File xcodeDir;
        private final VersionNumber version;
        private String originalDeveloperDir;

        public InstalledXcode(File xcodeDir, VersionNumber version) {
            this.xcodeDir = xcodeDir;
            this.version = version;
        }

        private List<String> getRuntimeEnv() {
            return Collections.singletonList("DEVELOPER_DIR=" + this.xcodeDir.getAbsolutePath());
        }

        private void initialiseEnvironment() {
            this.originalDeveloperDir = System.getenv("DEVELOPER_DIR");
            System.out.println(String.format("Using DEVELOPER_DIR %s", this.xcodeDir.getAbsolutePath()));
            PROCESS_ENVIRONMENT.setEnvironmentVariable("DEVELOPER_DIR", this.xcodeDir.getAbsolutePath());
        }

        private void resetEnvironment() {
            if (this.originalDeveloperDir != null) {
                PROCESS_ENVIRONMENT.setEnvironmentVariable("DEVELOPER_DIR", this.xcodeDir.getAbsolutePath());
            }
        }

        private GradleRunner configureExecuter(GradleRunner executer) {
            return executer.withEnvironmentVariable("DEVELOPER_DIR", this.xcodeDir.getAbsolutePath());
        }

        public Optional<InstalledToolChain> getSwiftc() {
            SwiftcMetadataProvider versionDeterminer = new SwiftcMetadataProvider(TestFiles.execActionFactory());
            File swiftc = new File("/usr/bin/swiftc");
            SearchResult version = versionDeterminer.getCompilerMetaData(Collections.emptyList(), spec -> spec.executable(swiftc).environment("DEVELOPER_DIR", this.xcodeDir.getAbsolutePath()));
            if (!version.isAvailable()) {
                return Optional.empty();
            }
            return Optional.of(new InstalledSwiftc(new File("/usr/bin"), ((SwiftcMetadata)version.getComponent()).getVersion()){

                @Override
                public List<String> getRuntimeEnv() {
                    ArrayList<String> result = new ArrayList<String>();
                    result.addAll(super.getRuntimeEnv());
                    result.addAll(this.getRuntimeEnv());
                    return result;
                }

                @Override
                public void initialiseEnvironment() {
                    super.initialiseEnvironment();
                    this.initialiseEnvironment();
                }

                @Override
                public void resetEnvironment() {
                    this.resetEnvironment();
                    super.resetEnvironment();
                }

                @Override
                public GradleRunner configureExecuter(GradleRunner executer) {
                    return this.configureExecuter(super.configureExecuter(executer));
                }
            });
        }

        public Optional<InstalledToolChain> getClang() {
            GccMetadataProvider versionDeterminer = GccMetadataProvider.forClang((ExecActionFactory)TestFiles.execActionFactory());
            File clang = new File("/usr/bin/clang");
            SearchResult version = versionDeterminer.getCompilerMetaData(Collections.emptyList(), spec -> spec.executable(clang).environment("DEVELOPER_DIR", this.xcodeDir.getAbsolutePath()));
            if (!version.isAvailable()) {
                return Optional.empty();
            }
            return Optional.of(new InstalledClang(((GccMetadata)version.getComponent()).getVersion()){

                @Override
                public List<String> getRuntimeEnv() {
                    ArrayList<String> result = new ArrayList<String>();
                    result.addAll(super.getRuntimeEnv());
                    result.addAll(this.getRuntimeEnv());
                    return result;
                }

                @Override
                public void initialiseEnvironment() {
                    super.initialiseEnvironment();
                    this.initialiseEnvironment();
                }

                @Override
                public void resetEnvironment() {
                    this.resetEnvironment();
                    super.resetEnvironment();
                }

                @Override
                public GradleRunner configureExecuter(GradleRunner executer) {
                    return this.configureExecuter(super.configureExecuter(executer));
                }

                @Override
                public boolean meets(ToolChainRequirement requirement) {
                    if (ToolChainRequirement.SUPPORTS_32.equals((Object)requirement) || ToolChainRequirement.SUPPORTS_32_AND_64.equals((Object)requirement)) {
                        return version.getMajor() < 10;
                    }
                    return super.meets(requirement);
                }
            });
        }
    }

    public static class InstalledSwiftc
    extends InstalledToolChain {
        private final File binDir;
        private final VersionNumber compilerVersion;

        public InstalledSwiftc(File binDir, VersionNumber compilerVersion) {
            super(ToolFamily.SWIFTC, compilerVersion);
            this.binDir = binDir;
            this.compilerVersion = compilerVersion;
        }

        public File tool(String name) {
            return new File(this.binDir, name);
        }

        @Override
        public List<String> getRuntimeEnv() {
            return this.toRuntimeEnv();
        }

        @Override
        public String getInstanceDisplayName() {
            return String.format("Tool chain '%s' (Swiftc)", this.getId());
        }

        @Override
        public String getBuildScriptConfig() {
            String config = String.format("%s(%s)\n", this.getId(), this.getImplementationClass());
            for (File pathEntry : this.getPathEntries()) {
                config = config + String.format("%s.path file('%s')\n", this.getId(), pathEntry.toURI());
            }
            return config;
        }

        @Override
        public String getImplementationClass() {
            return Swiftc.class.getSimpleName();
        }

        @Override
        public String getPluginClass() {
            return SwiftCompilerPlugin.class.getSimpleName();
        }

        @Override
        public String getUnitTestPlatform() {
            return null;
        }

        @Override
        public boolean meets(ToolChainRequirement requirement) {
            switch (requirement) {
                case AVAILABLE: {
                    return true;
                }
                case SWIFTC: {
                    return true;
                }
                case SWIFTC_3: {
                    return this.getVersion().getMajor() == 3;
                }
                case SWIFTC_4: {
                    return this.getVersion().getMajor() == 4;
                }
                case SWIFTC_5: {
                    return this.getVersion().getMajor() == 5;
                }
                case SWIFTC_4_OR_OLDER: {
                    return this.getVersion().getMajor() < 5;
                }
            }
            return false;
        }
    }

    public static class InstalledMingwGcc
    extends InstalledWindowsGcc {
        public InstalledMingwGcc(VersionNumber version) {
            super(ToolFamily.MINGW_GCC, version);
        }

        @Override
        public String platformSpecificToolChainConfiguration() {
            String config = "     eachPlatform { platformToolChain ->\n";
            config = config + "         if (platformToolChain.platform.architecture.isI386() || platformToolChain.platform.architecture.isArm()) {\n";
            config = config + "             platformToolChain.cCompiler.executable='i686-w64-mingw32-gcc.exe'\n";
            config = config + "             platformToolChain.cppCompiler.executable='i686-w64-mingw32-g++.exe'\n";
            config = config + "             platformToolChain.linker.executable='i686-w64-mingw32-g++.exe'\n";
            config = config + "             platformToolChain.assembler.executable='i686-w64-mingw32-gcc.exe'\n";
            config = config + "             platformToolChain.staticLibArchiver.executable='i686-w64-mingw32-gcc-ar.exe'\n";
            config = config + "         }\n";
            config = config + "     }\n";
            return config;
        }

        @Override
        public String getUnitTestPlatform() {
            return "mingw";
        }
    }

    public static class InstalledCygwinGcc
    extends InstalledWindowsGcc {
        public InstalledCygwinGcc(VersionNumber version) {
            super(ToolFamily.CYGWIN_GCC, version);
        }

        @Override
        public String platformSpecificToolChainConfiguration() {
            String config = "     eachPlatform { platformToolChain ->\n";
            config = config + "         if (platformToolChain.platform.architecture.isI386() || platformToolChain.platform.architecture.isArm()) {\n";
            config = config + "             platformToolChain.cCompiler.executable='i686-pc-cygwin-gcc.exe'\n";
            config = config + "             platformToolChain.cppCompiler.executable='i686-pc-cygwin-g++.exe'\n";
            config = config + "             platformToolChain.linker.executable='i686-pc-cygwin-g++.exe'\n";
            config = config + "             platformToolChain.assembler.executable='i686-pc-cygwin-gcc.exe'\n";
            config = config + "             platformToolChain.staticLibArchiver.executable='i686-pc-cygwin-ar.exe'\n";
            config = config + "         }\n";
            config = config + "     }\n";
            return config;
        }

        @Override
        public String getUnitTestPlatform() {
            return "cygwin";
        }
    }

    public static class InstalledWindowsGcc
    extends InstalledGcc {
        public InstalledWindowsGcc(ToolFamily family, VersionNumber version) {
            super(family, version);
        }

        @Override
        public List<String> getRuntimeEnv() {
            return this.toRuntimeEnv();
        }

        @Override
        public String getBuildScriptConfig() {
            String config = String.format("%s(%s) {\n", this.getId(), this.getImplementationClass());
            for (File pathEntry : this.getPathEntries()) {
                config = config + String.format("     path file('%s')\n", pathEntry.toURI());
            }
            config = config + this.platformSpecificToolChainConfiguration();
            config = config + "}\n";
            return config;
        }

        @Override
        public boolean meets(ToolChainRequirement requirement) {
            switch (requirement) {
                case SUPPORTS_32: 
                case WINDOWS_GCC: 
                case SUPPORTS_32_AND_64: {
                    return true;
                }
            }
            return super.meets(requirement);
        }

        @Override
        public String getId() {
            return this.getDisplayName().replaceAll("\\W", "");
        }
    }

    public static class InstalledGcc
    extends GccCompatibleToolChain {
        public InstalledGcc(ToolFamily family, VersionNumber version) {
            super(family, version);
        }

        @Override
        public boolean meets(ToolChainRequirement requirement) {
            return requirement == ToolChainRequirement.GCC || requirement == ToolChainRequirement.GCC_COMPATIBLE || requirement == ToolChainRequirement.AVAILABLE || requirement == ToolChainRequirement.SUPPORTS_32 || requirement == ToolChainRequirement.SUPPORTS_32_AND_64;
        }

        @Override
        public String getBuildScriptConfig() {
            String config = String.format("'%s'(%s) {\n", this.getId(), this.getImplementationClass());
            for (File pathEntry : this.getPathEntries()) {
                config = config + String.format("path file('%s')\n", pathEntry.toURI());
            }
            if (!this.suffix.isEmpty()) {
                config = config + "    eachPlatform { platformToolChain ->\n";
                config = config + String.format("        platformToolChain.cCompiler.executable='%s'\n", "gcc" + this.suffix);
                config = config + String.format("        platformToolChain.cppCompiler.executable='%s'\n", "g++" + this.suffix);
                config = config + String.format("        platformToolChain.objcCompiler.executable='%s'\n", "gcc" + this.suffix);
                config = config + String.format("        platformToolChain.objcppCompiler.executable='%s'\n", "g++" + this.suffix);
                config = config + String.format("        platformToolChain.assembler.executable='%s'\n", "gcc" + this.suffix);
                config = config + String.format("        platformToolChain.linker.executable='%s'\n", "g++" + this.suffix);
                config = config + String.format("        platformToolChain.staticLibArchiver.executable='%s'\n", "gcc-ar" + this.suffix);
                config = config + "    }\n";
            }
            config = config + "}\n";
            return config;
        }

        @Override
        public File getCppCompiler() {
            return this.find("g++" + this.suffix);
        }

        @Override
        public File getCCompiler() {
            return this.find("gcc" + this.suffix);
        }

        @Override
        public String getInstanceDisplayName() {
            return String.format("Tool chain '%s' (GNU GCC)", this.getId());
        }

        @Override
        public String getImplementationClass() {
            return Gcc.class.getSimpleName();
        }

        @Override
        public String getPluginClass() {
            return GccCompilerPlugin.class.getSimpleName();
        }

        @Override
        public String getId() {
            return "gcc" + this.suffix;
        }

        public InstalledGcc withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }
    }

    public static abstract class GccCompatibleToolChain
    extends InstalledToolChain {
        protected String suffix = "";

        protected GccCompatibleToolChain(ToolFamily family, VersionNumber version) {
            super(family, version);
        }

        protected File find(String tool) {
            if (this.getPathEntries().isEmpty()) {
                return OperatingSystem.current().findInPath(tool);
            }
            return new File(this.getPathEntries().get(0), tool);
        }

        public File getLinker() {
            return this.getCCompiler();
        }

        public File getStaticLibArchiver() {
            return this.find("ar" + this.suffix);
        }

        public abstract File getCppCompiler();

        public abstract File getCCompiler();

        @Override
        public String getUnitTestPlatform() {
            if (OperatingSystem.current().isMacOsX()) {
                return "osx";
            }
            if (OperatingSystem.current().isLinux()) {
                return "linux";
            }
            return "UNKNOWN";
        }
    }

    public static abstract class InstalledToolChain
    extends ToolChainCandidate {
        private static final ProcessEnvironment PROCESS_ENVIRONMENT = (ProcessEnvironment)NativeServicesTestFixture.getInstance().get(ProcessEnvironment.class);
        protected final List<File> pathEntries = new ArrayList<File>();
        private final ToolFamily family;
        private final VersionNumber version;
        protected final String pathVarName;
        private final String objectFileNameSuffix;
        private String originalPath;

        public InstalledToolChain(ToolFamily family, VersionNumber version) {
            this.family = family;
            this.version = version;
            this.pathVarName = OperatingSystem.current().getPathVar();
            this.objectFileNameSuffix = OperatingSystem.current().isWindows() ? ".obj" : ".o";
        }

        InstalledToolChain inPath(File ... pathEntries) {
            Collections.addAll(this.pathEntries, pathEntries);
            return this;
        }

        @Override
        public String getDisplayName() {
            return this.family.displayName + (this.version == VersionNumber.UNKNOWN ? "" : " " + this.version.toString());
        }

        @Override
        public ToolFamily getFamily() {
            return this.family;
        }

        @Override
        public VersionNumber getVersion() {
            return this.version;
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        public String getTypeDisplayName() {
            return this.getDisplayName().replaceAll("\\s+\\d+(\\.\\d+)*(\\s+\\(\\d+(\\.\\d+)*\\))?$", "");
        }

        public abstract String getInstanceDisplayName();

        public ExecutableFixture executable(Object path) {
            return new ExecutableFixture(new TestFile(OperatingSystem.current().getExecutableName(path.toString())), this);
        }

        public LinkerOptionsFixture linkerOptionsFor(Object path) {
            return new LinkerOptionsFixture(new TestFile(path.toString()));
        }

        public TestFile objectFile(Object path) {
            return new TestFile(path.toString() + this.objectFileNameSuffix);
        }

        public SharedLibraryFixture sharedLibrary(Object path) {
            return new SharedLibraryFixture(new TestFile(OperatingSystem.current().getSharedLibraryName(path.toString())), this);
        }

        public StaticLibraryFixture staticLibrary(Object path) {
            return new StaticLibraryFixture(new TestFile(OperatingSystem.current().getStaticLibraryName(path.toString())), this);
        }

        public NativeBinaryFixture resourceOnlyLibrary(Object path) {
            return new NativeBinaryFixture(new TestFile(OperatingSystem.current().getSharedLibraryName(path.toString())), this);
        }

        @Override
        public void initialiseEnvironment() {
            String compilerPath = this.pathEntries.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
            if (compilerPath.length() > 0) {
                this.originalPath = System.getenv(this.pathVarName);
                String path = compilerPath + File.pathSeparator + this.originalPath;
                System.out.println(String.format("Using path %s", path));
                PROCESS_ENVIRONMENT.setEnvironmentVariable(this.pathVarName, path);
            }
        }

        @Override
        public void resetEnvironment() {
            if (this.originalPath != null) {
                PROCESS_ENVIRONMENT.setEnvironmentVariable(this.pathVarName, this.originalPath);
            }
        }

        public abstract String getBuildScriptConfig();

        public abstract String getImplementationClass();

        public abstract String getPluginClass();

        public boolean isVisualCpp() {
            return false;
        }

        public List<File> getPathEntries() {
            return this.pathEntries;
        }

        public List<String> getRuntimeEnv() {
            return Collections.emptyList();
        }

        protected List<String> toRuntimeEnv() {
            if (this.pathEntries.isEmpty()) {
                return Collections.emptyList();
            }
            String path = this.pathEntries.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)) + File.pathSeparator + System.getenv(this.pathVarName);
            return Collections.singletonList(this.pathVarName + "=" + path);
        }

        public String getId() {
            return this.getDisplayName().replaceAll("\\W", "");
        }

        public abstract String getUnitTestPlatform();

        @Override
        public boolean matches(String criteria) {
            throw new UnsupportedOperationException();
        }

        public String platformSpecificToolChainConfiguration() {
            return "";
        }

        public GradleRunner configureExecuter(GradleRunner executer) {
            return executer;
        }
    }

    public static abstract class ToolChainCandidate
    implements AbstractMultiVersionSpecRunner.VersionedTool {
        public String toString() {
            return this.getDisplayName();
        }

        public abstract String getDisplayName();

        public abstract ToolFamily getFamily();

        public abstract VersionNumber getVersion();

        public abstract boolean isAvailable();

        public abstract boolean meets(ToolChainRequirement var1);

        public abstract void initialiseEnvironment();

        public abstract void resetEnvironment();
    }

    public static enum ToolFamily {
        GCC("gcc"),
        CLANG("clang"),
        VISUAL_CPP("visual c++"),
        MINGW_GCC("mingw"),
        CYGWIN_GCC("gcc cygwin"),
        SWIFTC("swiftc");

        private final String displayName;

        private ToolFamily(String displayName) {
            this.displayName = displayName;
        }
    }
}

