/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.maven;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.runnerkit.GradleRunner;
import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.maven.MavenLocalRepository;
import java.io.File;
import java.nio.file.LinkOption;
import java.util.function.UnaryOperator;
import org.junit.Assert;

public class M2Installation
implements UnaryOperator<GradleRunner> {
    private final File testDirectory;
    private boolean initialized = false;
    private File userHomeDirectory;
    private File userM2Directory;
    private File userSettingsFile;
    private File globalMavenDirectory;
    private File globalSettingsFile;
    private File isolatedMavenRepoForLeakageChecks;
    private boolean isolateMavenLocal = true;

    public M2Installation(File testDirectory) {
        this.testDirectory = testDirectory;
    }

    private void init() {
        if (!this.initialized) {
            this.userHomeDirectory = FileSystemUtils.createDirectory((File)FileSystemUtils.file((File)this.testDirectory, (Object[])new Object[]{"maven_home"}));
            this.userM2Directory = FileSystemUtils.createDirectory((File)FileSystemUtils.file((File)this.userHomeDirectory, (Object[])new Object[]{".m2"}));
            this.userSettingsFile = FileSystemUtils.file((File)this.userM2Directory, (Object[])new Object[]{"settings.xml"});
            this.globalMavenDirectory = FileSystemUtils.createDirectory((File)FileSystemUtils.file((File)this.userHomeDirectory, (Object[])new Object[]{"m2_home"}));
            this.globalSettingsFile = FileSystemUtils.file((File)this.globalMavenDirectory, (Object[])new Object[]{"conf/settings.xml"});
            System.out.println("M2 home: " + this.userHomeDirectory);
            this.initialized = true;
        }
    }

    public TestFile getUserHomeDir() {
        this.init();
        return TestFile.of(this.userHomeDirectory, new LinkOption[0]);
    }

    public TestFile getUserM2Directory() {
        this.init();
        return TestFile.of(this.userM2Directory, new LinkOption[0]);
    }

    public TestFile getUserSettingsFile() {
        this.init();
        return TestFile.of(this.userSettingsFile, new LinkOption[0]);
    }

    public TestFile getGlobalMavenDirectory() {
        this.init();
        return TestFile.of(this.globalMavenDirectory, new LinkOption[0]);
    }

    public TestFile getGlobalSettingsFile() {
        this.init();
        return TestFile.of(this.globalSettingsFile, new LinkOption[0]);
    }

    public MavenLocalRepository mavenRepo() {
        this.init();
        return new MavenLocalRepository(TestFile.of(FileSystemUtils.file((File)this.userM2Directory, (Object[])new Object[]{"repository"}), new LinkOption[0]));
    }

    public M2Installation generateUserSettingsFile(MavenLocalRepository userRepository) {
        this.init();
        TestFile.of(this.userSettingsFile, new LinkOption[0]).write("<settings>\n    <localRepository>${userRepository.rootDir.absolutePath}</localRepository>\n</settings>");
        return this;
    }

    public M2Installation generateGlobalSettingsFile() {
        return this.generateGlobalSettingsFile(this.mavenRepo());
    }

    public M2Installation generateGlobalSettingsFile(MavenLocalRepository globalRepository) {
        this.init();
        TestFile.of(FileSystemUtils.createFile((File)this.globalSettingsFile), new LinkOption[0]).write("<settings>\n    <localRepository>${globalRepository.rootDir.absolutePath}</localRepository>\n</settings>");
        return this;
    }

    @Override
    public GradleRunner apply(GradleRunner gradleExecuter) {
        this.init();
        GradleRunner result = gradleExecuter.withUserHomeDirectory(this.userHomeDirectory);
        this.isolateMavenLocal = false;
        if (this.globalMavenDirectory.exists()) {
            result = result.withEnvironmentVariable("M2_HOME", this.globalMavenDirectory.getAbsolutePath());
        }
        return result;
    }

    public GradleRunner isolateMavenLocalRepo(GradleRunner gradleExecuter) {
        gradleExecuter = gradleExecuter.beforeExecute(executer -> {
            if (this.isolateMavenLocal) {
                this.isolatedMavenRepoForLeakageChecks = FileSystemUtils.createDirectory((File)FileSystemUtils.file((File)executer.getWorkingDirectory(), (Object[])new Object[]{"m2-home-should-not-be-filled"}));
                return M2Installation.setMavenLocalLocation(executer, this.isolatedMavenRepoForLeakageChecks);
            }
            return executer;
        });
        gradleExecuter = gradleExecuter.afterExecute(executer -> {
            if (this.isolateMavenLocal) {
                Assert.assertTrue((String)String.format("%s is not an empty directory.", this.isolatedMavenRepoForLeakageChecks), (boolean)FileSystemUtils.isEmptyDirectory((File)this.isolatedMavenRepoForLeakageChecks));
            }
        });
        return gradleExecuter;
    }

    private static GradleRunner setMavenLocalLocation(GradleRunner runner, File destination) {
        return runner.withArgument("-Dmaven.repo.local=" + destination.getAbsolutePath());
    }
}

