/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.internal.streams.SafeStreams;

public class ProcessFixture {
    public final Long pid;

    public ProcessFixture(Long pid) {
        this.pid = pid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAlive() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("ps", "-p", String.valueOf(this.pid));
        builder.redirectErrorStream(true);
        builder.directory(new File(".").getAbsoluteFile());
        Process process = builder.start();
        process.getOutputStream().close();
        Thread pumperStdout = new Thread(() -> {
            try {
                IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)output);
                process.getInputStream().close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        pumperStdout.start();
        int exitCode = process.waitFor();
        try {
            if (exitCode == 0) {
                boolean bl = true;
                return bl;
            }
            if (exitCode != 1) throw new RuntimeException("Error while checking process state");
            boolean bl = false;
            return bl;
        }
        finally {
            pumperStdout.join();
        }
    }

    public void kill(boolean killTree) {
        System.out.println("Killing process with pid: " + this.pid);
        if (this.pid == null) {
            throw new RuntimeException("Unable to force kill the process because provided pid is null!");
        }
        if (!OperatingSystem.current().isUnix() && !OperatingSystem.current().isWindows()) {
            throw new RuntimeException("This implementation does not know how to forcefully kill a process on os: " + OperatingSystem.current());
        }
        this.execute(ProcessFixture.killArgs(this.pid, killTree), ProcessFixture.killScript(this.pid, killTree));
    }

    public String[] getChildProcesses() {
        if (this.pid == null) {
            throw new RuntimeException("Unable to get child processes because provided pid is null!");
        }
        if (!OperatingSystem.current().isUnix()) {
            throw new RuntimeException("This implementation does not know how to get child processes on os: " + OperatingSystem.current());
        }
        return this.bash("ps -o pid,ppid -ax | awk '{ if ( $2 == " + this.pid + " ) { print $1 }}'").split("\n");
    }

    public String[] getProcessInfo(String[] pids) {
        if (pids == null || pids.length == 0) {
            throw new RuntimeException("Unable to get process info because provided pids are null or empty!");
        }
        if (!OperatingSystem.current().isUnix()) {
            throw new RuntimeException("This implementation does not know how to get process info on os: " + OperatingSystem.current());
        }
        return this.bash("ps -o pid,ppid,args -p " + String.join((CharSequence)" -p ", pids)).split("\n");
    }

    private String bash(String commands) {
        return this.execute(new Object[]{"bash"}, new ByteArrayInputStream(commands.getBytes()));
    }

    private String execute(Object[] commandLine, InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(Arrays.stream(commandLine).map(Object::toString).collect(Collectors.toList()));
        builder.redirectErrorStream(true);
        builder.directory(new File(".").getAbsoluteFile());
        Process process = builder.start();
        Thread pumperStdin = new Thread(() -> {
            try {
                IOUtils.copy((InputStream)input, (OutputStream)process.getOutputStream());
                process.getOutputStream().flush();
                process.getOutputStream().close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        Thread pumperStdout = new Thread(() -> {
            try {
                IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)output);
                process.getInputStream().close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        pumperStdin.start();
        pumperStdout.start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new RuntimeException("Exit non-zero");
        }
        pumperStdin.join();
        pumperStdout.join();
        return output.toString();
    }

    private static Object[] killArgs(Long pid, boolean killTree) {
        if (OperatingSystem.current().isUnix()) {
            return new Object[]{"bash"};
        }
        if (OperatingSystem.current().isWindows()) {
            if (killTree) {
                return new Object[]{"taskkill.exe", "/F", "/T", "/PID", pid};
            }
            return new Object[]{"taskkill.exe", "/F", "/PID", pid};
        }
        throw new IllegalStateException();
    }

    private static InputStream killScript(Long pid, boolean killTree) {
        if (OperatingSystem.current().isUnix()) {
            String killScript = "killtree() {\n    local _pid=$1\n    for _child in $(ps -o pid,ppid -ax | awk \"{ if ( \\$2 == ${_pid} ) { print \\$1 }}\"); do\n        killtree ${_child}\n    done\n    kill -9 ${_pid}\n}\n";
            killScript = killScript + (killTree ? "\nkilltree " + pid + "\n" : "\nkill -9 " + pid + "\n");
            return new ByteArrayInputStream(killScript.getBytes());
        }
        if (OperatingSystem.current().isWindows()) {
            return SafeStreams.emptyInput();
        }
        throw new IllegalStateException();
    }
}

