/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.integtests.fixtures;

import com.google.common.collect.ImmutableSet;
import dev.gradleplugins.integtests.fixtures.AbstractGradleCompatibilityTestRunner;
import dev.gradleplugins.integtests.fixtures.AbstractGradleSpecification;
import dev.gradleplugins.integtests.fixtures.AbstractMultiTestRunner;
import dev.gradleplugins.integtests.fixtures.AbstractMultiVersionSpecRunner;
import dev.gradleplugins.integtests.fixtures.GradleDistributionTool;
import dev.gradleplugins.integtests.fixtures.IgnoreVersions;
import dev.gradleplugins.integtests.fixtures.TargetVersions;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.versions.ReleasedVersionDistributions;
import groovy.lang.Closure;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;
import org.gradle.util.VersionNumber;

public class GradleCompatibilityTestRunner
extends AbstractGradleCompatibilityTestRunner {
    public static final String VERSIONS_SYSPROP_NAME = "dev.gradleplugins.gradleVersions";
    public static final String MINIMUM_VERSION_SYSPROP_NAME = "dev.gradleplugins.minimumGradleVersion";
    public static final AbstractMultiVersionSpecRunner.CoverageContext DEFAULT = new AbstractMultiVersionSpecRunner.CoverageContext("default");
    public static final AbstractMultiVersionSpecRunner.CoverageContext LATEST_NIGHTLY = new AbstractMultiVersionSpecRunner.CoverageContext("latestNightly");
    public static final AbstractMultiVersionSpecRunner.CoverageContext LATEST_MINOR = new AbstractMultiVersionSpecRunner.CoverageContext("latestMinor");
    public static final AbstractMultiVersionSpecRunner.CoverageContext MINIMUM = new AbstractMultiVersionSpecRunner.CoverageContext("minimum");
    public static final AbstractMultiVersionSpecRunner.CoverageContext FULL = new AbstractMultiVersionSpecRunner.CoverageContext("all");
    private final Class<? extends AbstractGradleSpecification> target;

    public GradleCompatibilityTestRunner(Class<? extends AbstractGradleSpecification> target) {
        super(target, (Set<AbstractMultiVersionSpecRunner.CoverageContext>)ImmutableSet.of((Object)DEFAULT, (Object)LATEST_NIGHTLY, (Object)LATEST_MINOR, (Object)MINIMUM, (Object)FULL));
        this.target = target;
    }

    @Override
    protected List<GradleDistribution> chooseVersionsToTest(ReleasedVersionDistributions releasedVersions) {
        GradleVersion minimumGradleVersion = GradleVersion.version((String)System.getProperty(MINIMUM_VERSION_SYSPROP_NAME, null));
        return releasedVersions.getAll().stream().filter((? super T it) -> it.getVersion().compareTo(minimumGradleVersion) >= 0).sorted(Comparator.comparing(GradleDistribution::getVersion)).collect(Collectors.toList());
    }

    @Override
    protected String getVersions() {
        return System.getProperty(VERSIONS_SYSPROP_NAME, DEFAULT.getSelector());
    }

    @Override
    protected Collection<GradleDistributionTool> versionUnderTestForContext(AbstractMultiVersionSpecRunner.CoverageContext coverageContext) {
        if (coverageContext == DEFAULT) {
            return Collections.singleton(this.getMinimumVersion());
        }
        if (coverageContext == LATEST_NIGHTLY) {
            return Collections.singleton(this.versionedToolFrom(this.releasedVersions.getMostRecentSnapshot()));
        }
        if (coverageContext == LATEST_MINOR) {
            return this.getLatestMinorVersions();
        }
        if (coverageContext == MINIMUM) {
            return Collections.singleton(this.getMinimumVersion());
        }
        if (coverageContext == FULL) {
            return this.getAllVersions();
        }
        throw new IllegalArgumentException();
    }

    private Collection<GradleDistributionTool> getLatestMinorVersions() {
        Map groupedGradleReleases = this.getAllVersions().stream().collect(Collectors.groupingBy(GradleCompatibilityTestRunner::toVersionGroup, Collectors.toList()));
        return groupedGradleReleases.values().stream().map(it -> it.stream().max(Comparator.comparing(dist -> dist.getDistribution().getVersion())).get()).collect(Collectors.toList());
    }

    private GradleDistributionTool getMinimumVersion() {
        String minimumGradleVersion = System.getProperty(MINIMUM_VERSION_SYSPROP_NAME, null);
        return this.getAllVersions().stream().filter((? super T it) -> it.matches(minimumGradleVersion)).findFirst().get();
    }

    @Override
    protected boolean isAvailable(GradleDistributionTool version) {
        return true;
    }

    @Override
    protected Collection<AbstractMultiTestRunner.Execution> createDistributionExecutionsFor(GradleDistributionTool versionedTool) {
        GradleDistribution distribution = versionedTool.getDistribution();
        return Collections.singleton(new GradleVersionExecution(distribution, this.isEnabled(distribution)));
    }

    protected boolean isEnabled(GradleDistribution previousVersion) {
        String[] targetGradleVersions;
        Closure<Object> ignoreVersions = GradleCompatibilityTestRunner.getAnnotationClosure(this.target, IgnoreVersions.class, new Closure<Object>(null){

            public Object call(Object ... args) {
                return null;
            }
        });
        if (GUtil.isTrue((Object)ignoreVersions.call((Object)previousVersion))) {
            return false;
        }
        TargetVersions versionsAnnotation = this.target.getAnnotation(TargetVersions.class);
        if (versionsAnnotation == null) {
            return true;
        }
        for (String targetGradleVersion : targetGradleVersions = versionsAnnotation.value()) {
            if (!GradleCompatibilityTestRunner.isMatching(targetGradleVersion, previousVersion.getVersion().getVersion())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMatching(String targetGradleVersion, String candidate) {
        if (targetGradleVersion.endsWith("+")) {
            String minVersion = targetGradleVersion.substring(0, targetGradleVersion.length() - 1);
            return GradleVersion.version((String)minVersion).compareTo(GradleVersion.version((String)candidate)) <= 0;
        }
        return targetGradleVersion.equals(candidate);
    }

    private static Closure<Object> getAnnotationClosure(Class<?> target, Class<IgnoreVersions> annotation, Closure<Object> defaultValue) {
        IgnoreVersions a = target.getAnnotation(annotation);
        try {
            return a != null ? a.value().getConstructor(Class.class, Class.class).newInstance(target, target) : defaultValue;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toVersionGroup(GradleDistributionTool it) {
        VersionNumber version = VersionNumber.parse((String)it.getDistribution().getVersion().getVersion());
        return String.valueOf(version.getMajor());
    }

    private static class GradleVersionExecution
    extends AbstractMultiTestRunner.Execution {
        final GradleDistribution previousVersion;
        final boolean enabled;

        GradleVersionExecution(GradleDistribution previousVersion, boolean enabled) {
            this.previousVersion = previousVersion;
            this.enabled = enabled;
        }

        @Override
        protected String getDisplayName() {
            return this.previousVersion.getVersion().getVersion();
        }

        @Override
        protected void before() {
            AbstractGradleSpecification.useGradleDistribution(this.previousVersion);
        }

        @Override
        protected boolean isTestEnabled(AbstractMultiTestRunner.TestDetails testDetails) {
            return this.enabled;
        }
    }
}

