/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionResult;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.AbstractGradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.CurrentGradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.ForkingGradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecuterBuildContext;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecutionParameters;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.OutputScrapingExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.OutputScrapingExecutionResult;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.TestKitGradleExecuterBuildContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.GradleRunner;
import org.gradle.testkit.runner.TaskOutcome;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@Deprecated
public class GradleRunnerExecuter
extends AbstractGradleExecuter {
    public GradleRunnerExecuter(GradleDistribution distribution, TestFile testDirectory) {
        this(distribution, testDirectory, TestKitGradleExecuterBuildContext.INSTANCE);
    }

    public GradleRunnerExecuter(GradleDistribution distribution, TestFile testDirectory, GradleExecuterBuildContext buildContext) {
        super(distribution, testDirectory, buildContext);
    }

    private GradleRunnerExecuter(TestFile testDirectory, GradleExecutionParameters configuration) {
        super(testDirectory, configuration);
    }

    @Override
    protected GradleExecuter newInstance(TestFile testDirectory, GradleExecutionParameters configuration) {
        return new GradleRunnerExecuter(testDirectory, configuration);
    }

    @Override
    public GradleExecuter withDebuggerAttached() {
        return this.newInstance(this.configuration.withDebuggerAttached(true));
    }

    @Override
    public GradleExecuter withPluginClasspath() {
        return this.newInstance(this.configuration.withPluginClasspath(true));
    }

    @Override
    public GradleExecuter requireGradleDistribution() {
        return new ForkingGradleExecuter(this.getTestDirectory(), this.configuration);
    }

    @Override
    public boolean usesGradleDistribution() {
        return false;
    }

    @Override
    public GradleExecuter withWelcomeMessageEnabled() {
        throw new UnsupportedOperationException("TestKit always suppress the welcome message");
    }

    @Override
    protected List<String> getDaemonArguments() {
        return Collections.emptyList();
    }

    @Override
    public ExecutionResult doRun() {
        return new GradleRunnerExecutionResult(this.configureExecuter().build());
    }

    @Override
    public ExecutionFailure doRunWithFailure() {
        return new GradleRunnerExecutionFailure(this.configureExecuter().buildAndFail());
    }

    private GradleRunner configureExecuter() {
        GradleRunner runner = GradleRunner.create();
        runner.forwardOutput();
        if (this.configuration.isPluginClasspath()) {
            runner.withPluginClasspath();
        }
        runner.withProjectDir(this.getWorkingDirectory());
        if (this.configuration.isDebuggerAttached()) {
            System.out.println("WARNING: Gradle TestKit has some class loader issue that may result in runtime failures - such as NoClassDefFoundError for groovy/util/AntBuilder (see https://github.com/gradle/gradle/issues/1687).");
            runner.withDebug(true);
        }
        if (this.configuration.getDistribution() != null && !(this.configuration.getDistribution() instanceof CurrentGradleDistribution)) {
            runner.withGradleVersion(this.configuration.getDistribution().getVersion().getVersion());
        } else if (this.configuration.getGradleVersion() != null) {
            runner.withGradleVersion(this.configuration.getGradleVersion());
        }
        if (!this.configuration.getEnvironment().isEmpty()) {
            HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
            environment.putAll(this.configuration.getEnvironment().getAsMap());
            runner.withEnvironment(environment);
        }
        runner.withArguments(this.getAllArguments());
        return runner;
    }

    @Deprecated
    public GradleExecuter usingGradleVersion(String gradleVersion) {
        System.out.println("WARNING: Stop using this method, we are modeling the GradleDistribution better to have a cross-executor solution");
        return this.newInstance(this.configuration.withGradleVersion(gradleVersion));
    }

    private static class GradleRunnerExecutionFailure
    extends GradleRunnerExecutionResult
    implements ExecutionFailure {
        private final OutputScrapingExecutionFailure delegate;

        GradleRunnerExecutionFailure(BuildResult result) {
            super(result);
            this.delegate = OutputScrapingExecutionFailure.from(result.getOutput(), result.getOutput());
        }

        @Override
        public ExecutionFailure assertHasCause(String description) {
            return this.delegate.assertHasCause(description);
        }

        @Override
        public ExecutionFailure assertThatCause(Matcher<? super String> matcher) {
            return this.delegate.assertThatCause(matcher);
        }

        @Override
        public ExecutionFailure assertHasDescription(String context) {
            return this.delegate.assertHasDescription(context);
        }

        @Override
        public void assertResultVisited() {
            super.assertResultVisited();
            this.delegate.assertResultVisited();
        }
    }

    private static class GradleRunnerExecutionResult
    implements ExecutionResult {
        private final BuildResult result;
        private final OutputScrapingExecutionResult delegate;
        private static final List<TaskOutcome> SKIPPED_TASK_OUTCOMES = Arrays.asList(TaskOutcome.FROM_CACHE, TaskOutcome.NO_SOURCE, TaskOutcome.SKIPPED, TaskOutcome.UP_TO_DATE);

        GradleRunnerExecutionResult(BuildResult result) {
            this.result = result;
            this.delegate = OutputScrapingExecutionResult.from(result.getOutput(), "");
        }

        private static List<String> flattenTaskPaths(Object[] taskPaths) {
            ArrayList<String> result = new ArrayList<String>();
            GradleRunnerExecutionResult.flattenTaskPaths(Arrays.asList(taskPaths), result);
            return result;
        }

        private static void flattenTaskPaths(Collection<? super Object> taskPaths, List<String> flattenTaskPaths) {
            taskPaths.stream().forEach(it -> {
                if (it instanceof Collection) {
                    GradleRunnerExecutionResult.flattenTaskPaths((Collection)it, flattenTaskPaths);
                } else {
                    flattenTaskPaths.add(it.toString());
                }
            });
        }

        @Override
        public String getPlainTextOutput() {
            return this.delegate.getPlainTextOutput();
        }

        @Override
        public String getOutput() {
            return this.delegate.getOutput();
        }

        @Override
        public ExecutionResult assertTaskNotExecuted(String taskPath) {
            Set<String> actualTasks = this.findExecutedTasksInOrderStarted();
            if (actualTasks.contains(taskPath)) {
                this.failOnMissingElement("Build output does contains unexpected task.", taskPath, actualTasks);
            }
            return this;
        }

        private void failOnMissingElement(String message, String expected, Set<String> actual) {
            this.failureOnUnexpectedOutput(String.format("%s%nExpected: %s%nActual: %s", message, expected, actual));
        }

        @Override
        public ExecutionResult assertTasksExecuted(Object ... taskPaths) {
            Set<String> actualTasks;
            TreeSet<String> expectedTasks = new TreeSet<String>(GradleRunnerExecutionResult.flattenTaskPaths(taskPaths));
            if (!expectedTasks.equals(actualTasks = this.findExecutedTasksInOrderStarted())) {
                this.failOnDifferentSets("Build output does not contain the expected tasks.", expectedTasks, actualTasks);
            }
            return this;
        }

        @Override
        public ExecutionResult assertTasksExecutedAndNotSkipped(Object ... taskPaths) {
            this.assertTasksExecuted(taskPaths);
            return this.assertTasksNotSkipped(taskPaths);
        }

        @Override
        public ExecutionResult assertTasksNotSkipped(Object ... taskPaths) {
            TreeSet<String> tasks;
            TreeSet<String> expectedTasks = new TreeSet<String>(GradleRunnerExecutionResult.flattenTaskPaths(taskPaths));
            if (!expectedTasks.equals(tasks = new TreeSet<String>(this.getNotSkippedTasks()))) {
                this.failOnDifferentSets("Build output does not contain the expected non skipped tasks.", expectedTasks, tasks);
            }
            return this;
        }

        @Override
        public ExecutionResult assertTasksSkipped(Object ... taskPaths) {
            Set<String> skippedTasks;
            TreeSet<String> expectedTasks = new TreeSet<String>(GradleRunnerExecutionResult.flattenTaskPaths(taskPaths));
            if (!expectedTasks.equals(skippedTasks = this.getSkippedTasks())) {
                this.failOnDifferentSets("Build output does not contain the expected skipped tasks.", expectedTasks, skippedTasks);
            }
            return this;
        }

        private void failOnDifferentSets(String message, Set<String> expected, Set<String> actual) {
            this.failureOnUnexpectedOutput(String.format("%s%nExpected: %s%nActual: %s", message, expected, actual));
        }

        private void failureOnUnexpectedOutput(String message) {
            throw new AssertionError((Object)this.unexpectedOutputMessage(message));
        }

        private String unexpectedOutputMessage(String message) {
            return String.format("%s%nOutput:%n=======%n%s%nError:%n======%n%s", message, this.getOutput(), "Using TestKit Runner which mixin both error output");
        }

        @Override
        public ExecutionResult assertOutputContains(String expectedOutput) {
            this.delegate.assertOutputContains(expectedOutput);
            return this;
        }

        @Override
        public ExecutionResult assertNotOutput(String expectedOutput) {
            this.delegate.assertNotOutput(expectedOutput);
            return this;
        }

        @Override
        public ExecutionResult assertHasPostBuildOutput(String expectedOutput) {
            this.delegate.assertHasPostBuildOutput(expectedOutput);
            return this;
        }

        private Set<String> findExecutedTasksInOrderStarted() {
            return this.result.getTasks().stream().map(BuildTask::getPath).collect(Collectors.toCollection(TreeSet::new));
        }

        private Set<String> getSkippedTasks() {
            return this.result.getTasks().stream().filter(it -> SKIPPED_TASK_OUTCOMES.contains(it.getOutcome())).map(BuildTask::getPath).collect(Collectors.toCollection(TreeSet::new));
        }

        private List<String> getExecutedTasks() {
            return new ArrayList<String>(this.findExecutedTasksInOrderStarted());
        }

        private Collection<String> getNotSkippedTasks() {
            TreeSet<String> all = new TreeSet<String>(this.getExecutedTasks());
            Set<String> skipped = this.getSkippedTasks();
            all.removeAll(skipped);
            return all;
        }

        @Override
        public ExecutionResult assertTaskNotSkipped(String taskPath) {
            Assert.assertThat(this.getExecutedTasks(), (Matcher)CoreMatchers.hasItem((Object)taskPath));
            return this;
        }

        @Override
        public ExecutionResult assertTaskSkipped(String taskPath) {
            Assert.assertThat(this.getSkippedTasks(), (Matcher)CoreMatchers.hasItem((Object)taskPath));
            return this;
        }

        @Override
        public ExecutionResult assertThatOutput(Matcher<? super String> matcher) {
            return this.delegate.assertThatOutput(matcher);
        }

        @Override
        public void assertResultVisited() {
            this.delegate.assertResultVisited();
        }
    }
}

