/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import dev.gradleplugins.fixtures.runnerkit.BuildResultMatchers;
import dev.gradleplugins.runnerkit.BuildResult;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public final class ExecutionResultImpl
implements ExecutionResult,
ExecutionFailure {
    private final BuildResult delegate;

    public ExecutionResultImpl(BuildResult delegate) {
        this.delegate = delegate;
    }

    @Override
    public ExecutionFailure assertHasCause(String description) {
        MatcherAssert.assertThat((Object)this.delegate, (Matcher)BuildResultMatchers.hasFailureCause((String)description));
        return this;
    }

    @Override
    public ExecutionFailure assertThatCause(Matcher<? super String> matcher) {
        MatcherAssert.assertThat((Object)this.delegate, (Matcher)BuildResultMatchers.hasFailureCause(matcher));
        return this;
    }

    @Override
    public ExecutionFailure assertHasDescription(String context) {
        MatcherAssert.assertThat((Object)this.delegate, (Matcher)BuildResultMatchers.hasFailureDescription((String)context));
        return this;
    }

    @Override
    public String getOutput() {
        return this.delegate.getOutput();
    }

    @Override
    public String getPlainTextOutput() {
        return this.delegate.getOutput();
    }

    @Override
    public ExecutionResult assertTaskNotExecuted(String taskPath) {
        MatcherAssert.assertThat((String)"Build output does contains unexpected task.", (Object)this.delegate.getExecutedTaskPaths(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)taskPath)));
        return this;
    }

    @Override
    public ExecutionResult assertTaskNotSkipped(String taskPath) {
        MatcherAssert.assertThat((String)"Build output does not contain the expected non skipped task.", (Object)this.delegate.getSkippedTaskPaths(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)taskPath)));
        return this;
    }

    @Override
    public ExecutionResult assertTaskSkipped(String taskPath) {
        MatcherAssert.assertThat((String)"Build output does not contain the expected skipped task.", (Object)this.delegate.getSkippedTaskPaths(), (Matcher)Matchers.hasItem((Object)taskPath));
        return this;
    }

    @Override
    public ExecutionResult assertTasksExecutedAndNotSkipped(Object ... taskPaths) {
        MatcherAssert.assertThat((Object)this.delegate, (Matcher)BuildResultMatchers.tasksExecutedAndNotSkipped((Object[])taskPaths));
        return this;
    }

    @Override
    public ExecutionResult assertTasksExecuted(Object ... taskPaths) {
        MatcherAssert.assertThat((Object)this.delegate, (Matcher)BuildResultMatchers.tasksExecuted((Object[])taskPaths));
        return this;
    }

    @Override
    public ExecutionResult assertTasksSkipped(Object ... taskPaths) {
        MatcherAssert.assertThat((Object)this.delegate, (Matcher)BuildResultMatchers.tasksSkipped((Object[])taskPaths));
        return this;
    }

    @Override
    public ExecutionResult assertTasksNotSkipped(Object ... taskPaths) {
        MatcherAssert.assertThat((Object)this.delegate, (Matcher)Matchers.not((Matcher)BuildResultMatchers.tasksSkipped((Object[])taskPaths)));
        return this;
    }

    @Override
    public ExecutionResult assertOutputContains(String expectedOutput) {
        MatcherAssert.assertThat((Object)this.delegate.getOutput(), (Matcher)Matchers.containsString((String)expectedOutput));
        return this;
    }

    @Override
    public ExecutionResult assertThatOutput(Matcher<? super String> matcher) {
        MatcherAssert.assertThat((Object)this.delegate.getOutput(), matcher);
        return this;
    }

    @Override
    public ExecutionResult assertNotOutput(String expectedOutput) {
        MatcherAssert.assertThat((Object)this.delegate.getOutput(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)expectedOutput)));
        return this;
    }

    @Override
    public ExecutionResult assertHasPostBuildOutput(String expectedOutput) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void assertResultVisited() {
    }
}

