/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.executer.internal;

import com.google.common.collect.ImmutableList;
import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonLogsAnalyzer;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionFailure;
import dev.gradleplugins.test.fixtures.gradle.executer.ExecutionResult;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecuterBuildContext;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.GradleExecutionParameters;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.BuildScriptParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.CharacterEncodingParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.ConsoleTypeParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.DaemonBaseDirectory;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.DaemonBaseDirectoryParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.DaemonIdleTimeoutParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.DeprecationChecksParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.GradleUserHomeDirectory;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.GradleUserHomeDirectoryParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.LocaleParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.MissingSettingsFilePolicy;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.ProjectDirectory;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.ProjectDirectoryParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.SettingsFileParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.StacktraceParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.TemporaryDirectory;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.TemporaryDirectoryParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.UserHomeDirectory;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.UserHomeDirectoryParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.WelcomeMessageParameter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.WorkingDirectory;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.parameters.WorkingDirectoryParameter;
import dev.gradleplugins.test.fixtures.gradle.logging.ConsoleOutput;
import dev.gradleplugins.test.fixtures.scan.GradleEnterpriseBuildScan;
import java.io.File;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

@Deprecated
public abstract class AbstractGradleExecuter
implements GradleExecuter {
    protected GradleExecutionParameters configuration;
    private final TestFile testDirectory;

    public AbstractGradleExecuter(@NonNull GradleDistribution distribution, @NonNull TestFile testDirectory, @NonNull GradleExecuterBuildContext buildContext) {
        this(testDirectory, new GradleExecutionParameters(distribution, buildContext).withGradleUserHomeDirectory(GradleUserHomeDirectoryParameter.of(GradleUserHomeDirectory.of(buildContext.getGradleUserHomeDirectory()))).withDaemonBaseDirectory(DaemonBaseDirectoryParameter.of(DaemonBaseDirectory.of(buildContext.getDaemonBaseDirectory()))));
        if (distribution == null) {
            throw new NullPointerException("distribution is marked non-null but is null");
        }
        if (testDirectory == null) {
            throw new NullPointerException("testDirectory is marked non-null but is null");
        }
        if (buildContext == null) {
            throw new NullPointerException("buildContext is marked non-null but is null");
        }
    }

    protected AbstractGradleExecuter(TestFile testDirectory, GradleExecutionParameters configuration) {
        this.configuration = configuration;
        this.testDirectory = testDirectory;
    }

    protected GradleExecuter newInstance(GradleExecutionParameters configuration) {
        return this.newInstance(this.testDirectory, configuration);
    }

    protected abstract GradleExecuter newInstance(TestFile var1, GradleExecutionParameters var2);

    @Override
    public GradleDistribution getDistribution() {
        return this.configuration.getDistribution();
    }

    @Override
    public TestFile getTestDirectory() {
        return this.testDirectory;
    }

    @Override
    public File getWorkingDirectory() {
        return this.configuration.getWorkingDirectory().orElse(WorkingDirectory.of(this.testDirectory)).getAsFile();
    }

    @Override
    public GradleExecuter inDirectory(File directory) {
        return this.newInstance(this.configuration.withWorkingDirectory(WorkingDirectoryParameter.of(WorkingDirectory.of(directory))));
    }

    @Override
    public GradleExecuter withUserHomeDirectory(File userHomeDirectory) {
        return this.newInstance(this.configuration.withUserHomeDirectory(UserHomeDirectoryParameter.of(UserHomeDirectory.of(userHomeDirectory))));
    }

    @Override
    public GradleExecuter withGradleUserHomeDirectory(File gradleUserHomeDirectory) {
        return this.newInstance(this.configuration.withGradleUserHomeDirectory(GradleUserHomeDirectoryParameter.of(GradleUserHomeDirectory.of(gradleUserHomeDirectory))));
    }

    @Override
    public GradleExecuter requireOwnGradleUserHomeDirectory() {
        return this.newInstance(this.configuration.withGradleUserHomeDirectory(GradleUserHomeDirectoryParameter.of(GradleUserHomeDirectory.of(this.testDirectory.createDirectory("user-home")))));
    }

    @Override
    public GradleExecuter withStacktraceDisabled() {
        return this.newInstance(this.configuration.withShowStacktrace(StacktraceParameter.hide()));
    }

    @Override
    public GradleExecuter usingSettingsFile(File settingsFile) {
        return this.newInstance(this.configuration.withSettingsFile(SettingsFileParameter.of(settingsFile)));
    }

    @Override
    public GradleExecuter ignoresMissingSettingsFile() {
        return this.newInstance(this.configuration.withMissingSettingsFilePolicy(MissingSettingsFilePolicy.ignores()));
    }

    @Override
    public GradleExecuter usingBuildScript(File buildScript) {
        return this.newInstance(this.configuration.withBuildScript(BuildScriptParameter.of(buildScript)));
    }

    @Override
    public GradleExecuter usingInitScript(File initScript) {
        return this.newInstance(this.configuration.withInitScripts(this.configuration.getInitScripts().plus(() -> initScript)));
    }

    @Override
    public GradleExecuter usingProjectDirectory(File projectDirectory) {
        return this.newInstance(this.configuration.withProjectDirectory(ProjectDirectoryParameter.of(ProjectDirectory.of(projectDirectory))));
    }

    @Override
    public GradleExecuter withBuildCacheEnabled() {
        return this.withArgument("--build-cache");
    }

    @Override
    public GradleExecuter withArguments(String ... args) {
        return this.withArguments(Arrays.asList(args));
    }

    @Override
    public GradleExecuter withArguments(List<String> args) {
        return this.newInstance(this.configuration.withArguments(args));
    }

    @Override
    public GradleExecuter withArgument(String arg) {
        return this.newInstance(this.configuration.withArguments((List<String>)ImmutableList.builder().addAll(this.configuration.getArguments()).add((Object)arg).build()));
    }

    @Override
    public GradleExecuter withTasks(String ... tasks) {
        return this.withTasks(Arrays.asList(tasks));
    }

    @Override
    public GradleExecuter withTasks(List<String> tasks) {
        return this.newInstance(this.configuration.withTasks((List<String>)ImmutableList.builder().addAll(this.configuration.getTasks()).addAll(tasks).build()));
    }

    @Override
    public GradleExecuter beforeExecute(Function<? super GradleExecuter, GradleExecuter> action) {
        return this.newInstance(this.configuration.withBeforeExecute((List<Function<? super GradleExecuter, GradleExecuter>>)ImmutableList.builder().addAll(this.configuration.getBeforeExecute()).add(action).build()));
    }

    private GradleExecuter fireBeforeExecute() {
        GradleExecuter executer = this.newInstance(this.configuration.withBeforeExecute((List<Function<? super GradleExecuter, GradleExecuter>>)ImmutableList.of()));
        for (Function<? super GradleExecuter, GradleExecuter> it : this.configuration.getBeforeExecute()) {
            executer = it.apply(executer);
        }
        return executer;
    }

    @Override
    public GradleExecuter afterExecute(Consumer<? super GradleExecuter> action) {
        return this.newInstance(this.configuration.withAfterExecute((List<Consumer<? super GradleExecuter>>)ImmutableList.builder().addAll(this.configuration.getAfterExecute()).add(action).build()));
    }

    private void fireAfterExecute() {
        this.configuration.getAfterExecute().forEach(it -> it.accept(this));
    }

    @Override
    public GradleExecuter withConsole(ConsoleOutput consoleType) {
        return this.newInstance(this.configuration.withConsoleType(ConsoleTypeParameter.of(consoleType)));
    }

    @Override
    public GradleExecuter withEnvironmentVars(Map<String, ?> environment) {
        return this.newInstance(this.configuration.withEnvironment(this.configuration.getEnvironment().plus(environment)));
    }

    @Override
    public GradleExecuter withoutDeprecationChecks() {
        return this.newInstance(this.configuration.withDeprecationChecks(DeprecationChecksParameter.ignores()));
    }

    @Override
    public GradleExecuter requireIsolatedDaemons() {
        return this.withDaemonBaseDirectory(this.getTestDirectory().file("daemon"));
    }

    @Override
    public GradleExecuter withDaemonBaseDirectory(File daemonBaseDirectory) {
        return this.newInstance(this.configuration.withDaemonBaseDirectory(DaemonBaseDirectoryParameter.of(DaemonBaseDirectory.of(daemonBaseDirectory))));
    }

    @Override
    public GradleExecuter withDaemonIdleTimeout(Duration daemonIdleTimeout) {
        return this.newInstance(this.configuration.withDaemonIdleTimeout(DaemonIdleTimeoutParameter.of(daemonIdleTimeout)));
    }

    @Override
    public GradleExecuter requireDaemon() {
        return this.newInstance(this.configuration.withRequireDaemon(true));
    }

    @Override
    public boolean usesDaemon() {
        CliDaemonArgument cliDaemonArgument = this.resolveCliDaemonArgument();
        if (cliDaemonArgument == CliDaemonArgument.NO_DAEMON || cliDaemonArgument == CliDaemonArgument.FOREGROUND) {
            return false;
        }
        return this.configuration.isRequireDaemon() || cliDaemonArgument == CliDaemonArgument.DAEMON;
    }

    protected CliDaemonArgument resolveCliDaemonArgument() {
        for (int i = this.configuration.getArguments().size() - 1; i >= 0; --i) {
            String arg = this.configuration.getArguments().get(i);
            if (arg.equals("--daemon")) {
                return CliDaemonArgument.DAEMON;
            }
            if (arg.equals("--no-daemon")) {
                return CliDaemonArgument.NO_DAEMON;
            }
            if (!arg.equals("--foreground")) continue;
            return CliDaemonArgument.FOREGROUND;
        }
        return CliDaemonArgument.NOT_DEFINED;
    }

    private boolean noDaemonArgumentGiven() {
        return this.resolveCliDaemonArgument() == CliDaemonArgument.NOT_DEFINED;
    }

    @Override
    public boolean usesSharedDaemons() {
        return this.isSharedDaemons();
    }

    protected boolean isSharedDaemons() {
        return ((DaemonBaseDirectory)this.configuration.getDaemonBaseDirectory().get()).getAsFile().equals(this.configuration.getBuildContext().getDaemonBaseDirectory());
    }

    @Override
    public GradleExecuter withoutDaemonCrashChecks() {
        return this.newInstance(this.configuration.withDaemonCrashChecks(false));
    }

    public void cleanup() {
        this.cleanupIsolatedDaemons();
        for (ExecutionResult result : this.configuration.getExecutionResults()) {
            result.assertResultVisited();
        }
    }

    private void cleanupIsolatedDaemons() {
        ArrayList<DaemonLogsAnalyzer> analyzers = new ArrayList<DaemonLogsAnalyzer>();
        for (File directory : this.configuration.getIsolatedDaemonBaseDirectories()) {
            try {
                DaemonLogsAnalyzer analyzer = new DaemonLogsAnalyzer(directory, this.configuration.getDistribution().getVersion().getVersion());
                analyzers.add(analyzer);
                analyzer.killAll();
            }
            catch (Exception e) {
                System.out.println("Problem killing isolated daemons of Gradle version " + this.configuration.getDistribution().getVersion().getVersion() + " in " + directory);
                e.printStackTrace();
            }
        }
        if (this.configuration.isDaemonCrashChecks()) {
            analyzers.forEach(DaemonLogsAnalyzer::assertNoCrashedDaemon);
        }
    }

    @Override
    public GradleExecuter withoutExplicitTemporaryDirectory() {
        return this.newInstance(this.configuration.withTemporaryDirectory(TemporaryDirectoryParameter.explicit(TemporaryDirectory.of(this.configuration.getBuildContext().getTemporaryDirectory()))));
    }

    @Override
    public GradleExecuter withDefaultCharacterEncoding(Charset defaultCharacterEncoding) {
        return this.newInstance(this.configuration.withDefaultCharacterEncoding(CharacterEncodingParameter.of(defaultCharacterEncoding)));
    }

    @Override
    public GradleExecuter withDefaultLocale(Locale defaultLocale) {
        return this.newInstance(this.configuration.withDefaultLocale(LocaleParameter.of(defaultLocale)));
    }

    @Override
    public GradleExecuter withWelcomeMessageEnabled() {
        return this.newInstance(this.configuration.withRenderWelcomeMessage(WelcomeMessageParameter.enabled()));
    }

    @Override
    public GradleExecuter withBuildScanEnabled() {
        return new GradleEnterpriseBuildScan().apply(this);
    }

    @Override
    public ExecutionResult run() {
        this.beforeBuildSetup();
        if (this.configuration.getBeforeExecute().isEmpty()) {
            try {
                ExecutionResult result = this.doRun();
                this.afterBuildCleanup(result);
                ExecutionResult executionResult = result;
                return executionResult;
            }
            finally {
                this.finished();
            }
        }
        return this.fireBeforeExecute().run();
    }

    private void afterBuildCleanup(ExecutionResult result) {
        this.fireAfterExecute();
        this.configuration = this.configuration.withExecutionResults((List<ExecutionResult>)ImmutableList.builder().addAll(this.configuration.getExecutionResults()).add((Object)result).build());
    }

    protected abstract ExecutionResult doRun();

    @Override
    public ExecutionFailure runWithFailure() {
        this.beforeBuildSetup();
        if (this.configuration.getBeforeExecute().isEmpty()) {
            try {
                ExecutionFailure result = this.doRunWithFailure();
                this.afterBuildCleanup(result);
                ExecutionFailure executionFailure = result;
                return executionFailure;
            }
            finally {
                this.finished();
            }
        }
        return this.fireBeforeExecute().runWithFailure();
    }

    private void beforeBuildSetup() {
        this.collectStateBeforeExecution();
    }

    private void collectStateBeforeExecution() {
        if (!this.isSharedDaemons()) {
            this.configuration = this.configuration.withIsolatedDaemonBaseDirectories((List<File>)ImmutableList.builder().addAll(this.configuration.getIsolatedDaemonBaseDirectories()).add((Object)((DaemonBaseDirectory)this.configuration.getDaemonBaseDirectory().get()).getAsFile()).build());
        }
    }

    protected abstract ExecutionFailure doRunWithFailure();

    private void finished() {
    }

    protected List<String> getAllArguments() {
        ArrayList<String> allArguments = new ArrayList<String>();
        allArguments.addAll(this.getImplicitJvmSystemProperties().entrySet().stream().map(entry -> String.format("-D%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.toList()));
        allArguments.addAll(this.configuration.getBuildScript().getAsArguments());
        allArguments.addAll(this.configuration.getProjectDirectory().getAsArguments());
        allArguments.addAll(this.configuration.getInitScripts().getAsArguments());
        allArguments.addAll(this.configuration.getSettingsFile().getAsArguments());
        if (this.noDaemonArgumentGiven()) {
            allArguments.addAll(this.getDaemonArguments());
        }
        allArguments.addAll(this.configuration.getShowStacktrace().getAsArguments());
        this.configuration.getMissingSettingsFilePolicy().ensureAvailable(() -> this.getTestDirectory(), WorkingDirectory.of(this.getWorkingDirectory()));
        allArguments.addAll(this.configuration.getGradleUserHomeDirectory().getAsArguments());
        allArguments.addAll(this.configuration.getConsoleType().getAsArguments());
        allArguments.addAll(this.configuration.getDeprecationChecks().getAsArguments());
        allArguments.addAll(this.configuration.getArguments());
        allArguments.addAll(this.configuration.getTasks());
        return allArguments;
    }

    protected List<String> getDaemonArguments() {
        if (this.usesDaemon()) {
            return ImmutableList.of((Object)"--daemon");
        }
        return ImmutableList.of((Object)"--no-daemon");
    }

    protected Map<String, String> getImplicitJvmSystemProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.putAll(this.configuration.getUserHomeDirectory().getAsJvmSystemProperties());
        properties.putAll(this.configuration.getDaemonIdleTimeout().getAsJvmSystemProperties());
        properties.putAll(this.configuration.getDaemonBaseDirectory().getAsJvmSystemProperties());
        if (!this.configuration.getTemporaryDirectory().hasWhitespace() || this.getDistribution().isSupportsSpacesInGradleAndJavaOpts() && this.supportsWhiteSpaceInEnvVars()) {
            properties.putAll(this.configuration.getTemporaryDirectory().getAsJvmSystemProperties());
        }
        properties.putAll(this.configuration.getDefaultCharacterEncoding().getAsJvmSystemProperties());
        properties.putAll(this.configuration.getDefaultLocale().getAsJvmSystemProperties());
        properties.putAll(this.configuration.getRenderWelcomeMessage().getAsJvmSystemProperties());
        this.configuration.getRenderWelcomeMessage().apply((GradleUserHomeDirectory)this.configuration.getGradleUserHomeDirectory().get(), this.configuration.getDistribution().getVersion());
        return properties;
    }

    protected boolean supportsWhiteSpaceInEnvVars() {
        return true;
    }

    static enum CliDaemonArgument {
        NOT_DEFINED,
        DAEMON,
        NO_DAEMON,
        FOREGROUND;

    }
}

