/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.daemon;

import dev.gradleplugins.test.fixtures.gradle.daemon.AbstractDaemonFixture;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonLogFileStateProbe;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonRegistryStateProbe;
import java.io.File;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.Time;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;

public class TestableDaemon
extends AbstractDaemonFixture {
    private final DaemonLogFileStateProbe logFileProbe;
    private final DaemonRegistryStateProbe registryProbe;

    public TestableDaemon(File daemonLog, DaemonRegistry registry) {
        super(daemonLog);
        this.logFileProbe = new DaemonLogFileStateProbe(daemonLog, this.context);
        this.registryProbe = new DaemonRegistryStateProbe(registry, this.context);
    }

    @Override
    protected void waitForState(DaemonStateControl.State state) throws InterruptedException {
        CountdownTimer timer = Time.startCountdownTimer((long)20000L);
        DaemonStateControl.State lastRegistryState = this.registryProbe.getCurrentState();
        DaemonStateControl.State lastLogState = this.logFileProbe.getCurrentState();
        while (!(timer.hasExpired() || lastRegistryState == state && lastLogState == state)) {
            Thread.sleep(200L);
            lastRegistryState = this.registryProbe.getCurrentState();
            lastLogState = this.logFileProbe.getCurrentState();
        }
        if (lastRegistryState == state && lastLogState == state) {
            return;
        }
        throw new AssertionError((Object)String.format("Timeout waiting for daemon with pid %d to reach state %s.%nCurrent registry state is %s and current log state is %s.", this.context.getPid(), state, lastRegistryState, lastLogState));
    }

    @Override
    protected void assertHasState(DaemonStateControl.State state) {
        assert (this.logFileProbe.getCurrentState() == state);
        assert (this.registryProbe.getCurrentState() == state);
    }

    @Override
    public void assertRegistryNotWorldReadable() {
        this.registryProbe.assertRegistryNotWorldReadable();
    }

    @Override
    public void changeTokenVisibleToClient() {
        this.registryProbe.resetToken();
    }

    @Override
    public String getLog() {
        return this.logFileProbe.getLog();
    }

    @Override
    public File getLogFile() {
        return this.logFileProbe.getLogFile();
    }

    @Override
    public int getPort() {
        return this.logFileProbe.getPort();
    }
}

