/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.gradle.daemon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.gradleplugins.test.fixtures.gradle.NativeServicesTestFixture;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonFixture;
import dev.gradleplugins.test.fixtures.gradle.daemon.DaemonsFixture;
import dev.gradleplugins.test.fixtures.gradle.daemon.LegacyDaemon;
import dev.gradleplugins.test.fixtures.gradle.daemon.TestableDaemon;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.gradle.api.JavaVersion;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.BasicGlobalScopeServices;
import org.gradle.launcher.daemon.client.DaemonClientGlobalServices;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonRegistryServices;
import org.gradle.util.GradleVersion;
import org.junit.Assert;

public class DaemonLogsAnalyzer
implements DaemonsFixture {
    private final File daemonLogsDir;
    private final File daemonBaseDir;
    private final DaemonRegistry registry;
    private final String version;

    public DaemonLogsAnalyzer(File daemonBaseDirectory) {
        this(daemonBaseDirectory, GradleVersion.current().getVersion());
    }

    public DaemonLogsAnalyzer(File daemonBaseDir, String version) {
        this.version = version;
        this.daemonBaseDir = daemonBaseDir;
        this.daemonLogsDir = new File(daemonBaseDir, version);
        ServiceRegistry services = ServiceRegistryBuilder.builder().parent((ServiceRegistry)LoggingServiceRegistry.newEmbeddableLogging()).parent((ServiceRegistry)NativeServicesTestFixture.getInstance()).provider((Object)new BasicGlobalScopeServices()).provider((Object)new DaemonClientGlobalServices()).provider((Object)new DaemonRegistryServices(daemonBaseDir)).build();
        this.registry = (DaemonRegistry)services.get(DaemonRegistry.class);
    }

    public static DaemonsFixture newAnalyzer(File daemonBaseDirectory) {
        return DaemonLogsAnalyzer.newAnalyzer(daemonBaseDirectory, GradleVersion.current().getVersion());
    }

    public static DaemonsFixture newAnalyzer(File daemonBaseDir, String version) {
        return new DaemonLogsAnalyzer(daemonBaseDir, version);
    }

    public DaemonRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void killAll() {
        this.getAllDaemons().forEach(DaemonFixture::kill);
    }

    public List<DaemonFixture> getDaemons() {
        return this.getAllDaemons().stream().filter(it -> DaemonLogsAnalyzer.daemonStoppedWithSocketExceptionOnWindows(it) || it.logContains("Starting build in new daemon")).collect(Collectors.toList());
    }

    public List<DaemonFixture> getAllDaemons() {
        if (!this.daemonLogsDir.exists() || !this.daemonLogsDir.isDirectory()) {
            return ImmutableList.of();
        }
        return Arrays.stream(this.daemonLogsDir.listFiles()).filter(it -> it.getName().endsWith(".log") && !it.getName().startsWith("hs_err")).map(this::daemonForLogFile).collect(Collectors.toList());
    }

    public List<DaemonFixture> getVisible() {
        return this.registry.getAll().stream().map(it -> this.daemonForLogFile(new File(this.daemonLogsDir, String.format("daemon-%d.out.log", it.getPid())))).collect(Collectors.toList());
    }

    public DaemonFixture daemonForLogFile(File logFile) {
        if (this.version.equals(GradleVersion.current().getVersion())) {
            return new TestableDaemon(logFile, this.registry);
        }
        return new LegacyDaemon(logFile, this.version);
    }

    @Override
    public DaemonFixture getDaemon() {
        List<DaemonFixture> daemons = this.getDaemons();
        assert (daemons.size() == 1);
        return daemons.get(0);
    }

    @Override
    public File getDaemonBaseDir() {
        return this.daemonBaseDir;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void assertNoCrashedDaemon() {
        List<File> crashLogs = Arrays.stream(this.daemonLogsDir.listFiles()).filter(it -> it.getName().endsWith(".log") && it.getName().startsWith("hs_err")).collect(Collectors.toList());
        crashLogs.forEach(it -> {
            try {
                System.out.println(FileUtils.readFileToString((File)it, (Charset)Charset.defaultCharset()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        Assert.assertTrue((String)("Found crash los: " + crashLogs), (boolean)crashLogs.isEmpty());
    }

    static boolean daemonStoppedWithSocketExceptionOnWindows(DaemonFixture daemon) {
        return DaemonLogsAnalyzer.runsOnWindowsAndJava7or8() && (daemon.logContains("java.net.SocketException: Socket operation on nonsocket:") || daemon.logContains("java.io.IOException: An operation was attempted on something that is not a socket") || daemon.logContains("java.io.IOException: An existing connection was forcibly closed by the remote host"));
    }

    static boolean runsOnWindowsAndJava7or8() {
        return SystemUtils.IS_OS_WINDOWS && ImmutableSet.of((Object)JavaVersion.VERSION_1_7, (Object)JavaVersion.VERSION_1_8).contains((Object)JavaVersion.current());
    }
}

