/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.file;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.test.fixtures.file.ExecOutput;
import dev.gradleplugins.test.fixtures.file.TestFileHelper;
import dev.gradleplugins.test.fixtures.util.RetryUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.junit.Assert;

public class TestFile
extends File {
    private boolean useNativeTools = false;

    public TestFile(File file, Object ... path) {
        super(FileSystemUtils.file((File)file, (Object[])path).getAbsolutePath());
    }

    public TestFile(String path) {
        this(new File(path), new Object[0]);
    }

    private TestFile(File file, boolean followLinks) {
        super(file.getAbsolutePath());
    }

    public static TestFile of(File file, LinkOption ... options) {
        if (Arrays.asList(options).contains(LinkOption.NOFOLLOW_LINKS)) {
            return new TestFile(file, false);
        }
        return new TestFile(file, new Object[0]);
    }

    public TestFile usingNativeTools() {
        this.useNativeTools = true;
        return this;
    }

    public TestFile assertExists() {
        Assert.assertTrue((String)String.format("%s does not exist", this), (boolean)this.exists());
        return this;
    }

    public TestFile assertDoesNotExist() {
        Assert.assertFalse((String)String.format("%s should not exist", this), (boolean)this.exists());
        return this;
    }

    public TestFile assertHasDescendants(String ... descendants) {
        this.assertIsDirectory();
        Set actual = FileSystemUtils.getDescendants((File)this);
        TreeSet<String> expected = new TreeSet<String>(Arrays.asList(descendants));
        TreeSet extras = new TreeSet(actual);
        extras.removeAll(expected);
        TreeSet<String> missing = new TreeSet<String>((Collection<String>)expected);
        missing.removeAll(actual);
        Assert.assertEquals((String)String.format("For dir: %s\n extra files: %s, missing files: %s, expected: %s", this, extras, missing, expected), expected, (Object)actual);
        return this;
    }

    public TestFile assertIsFile() {
        Assert.assertTrue((String)String.format("%s is not a file", this), (boolean)this.isFile());
        return this;
    }

    public TestFile assertIsDirectory() {
        Assert.assertTrue((String)String.format("%s is not a directory", this), (boolean)this.isDirectory());
        return this;
    }

    public TestFile assertIsSymbolicLink() {
        Assert.assertTrue((String)String.format("%s is not a symbolic link", this), (boolean)this.isSymbolicLink());
        return this;
    }

    public TestFile assertIsEmptyDirectory() {
        assert (FileSystemUtils.isEmptyDirectory((File)this));
        return this;
    }

    public TestFile cleanDirectory() throws IOException {
        this.assertIsDirectory();
        File[] files = this.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    TestFile.of(file, new LinkOption[0]).forceDeleteDirectory();
                    continue;
                }
                file.delete();
            }
        }
        return this;
    }

    @Deprecated
    public TestFile forceDeleteDir() throws IOException {
        return this.forceDeleteDirectory();
    }

    public TestFile forceDeleteDirectory() throws IOException {
        FileSystemUtils.forceDeleteDirectory((File)this);
        return this;
    }

    public TestFile file(Object ... path) {
        try {
            return new TestFile((File)this, path);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Could not locate file '%s' relative to '%s'.", Arrays.toString(path), this), e);
        }
    }

    public TestFile createFile() {
        FileSystemUtils.createFile((File)this);
        return this;
    }

    public TestFile createFile(Object path) {
        return this.file(path).createFile();
    }

    public TestFile createDirectory(Object path) {
        return new TestFile((File)this, path).createDirectory();
    }

    public TestFile createDirectory() {
        FileSystemUtils.createDirectory((File)this);
        return this;
    }

    public TestFile createSymbolicLink(File target) {
        this.getParentFile().createDirectory();
        try {
            Files.createSymbolicLink(this.toPath(), target.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public TestFile createSymbolicLink(String target) {
        return this.createSymbolicLink(new File(target));
    }

    public TestFile leftShift(Object content) {
        this.getParentFile().mkdirs();
        try {
            ResourceGroovyMethods.leftShift((File)this, (Object)content);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not append to test file '%s'", this), e);
        }
    }

    public TestFile write(Object content) {
        try {
            File parent;
            if (!(this.exists() || (parent = super.getParentFile()) == null || parent.mkdirs() || parent.isDirectory())) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
            Files.write(this.toPath(), content.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not write to test file '%s'", this), e);
        }
        return this;
    }

    public boolean isSelfOrDescendent(File file) {
        return FileSystemUtils.isSelfOrDescendent((File)this, (File)file);
    }

    @Override
    public TestFile getParentFile() {
        return super.getParentFile() == null ? null : new TestFile(super.getParentFile(), new Object[0]);
    }

    @Override
    public TestFile getAbsoluteFile() {
        return new TestFile(super.getAbsoluteFile(), new Object[0]);
    }

    public String getText() {
        this.assertIsFile();
        try {
            return new String(Files.readAllBytes(this.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not read from test file '%s'", this), e);
        }
    }

    public void setText(String content) {
        this.getParentFile().mkdirs();
        try {
            ResourceGroovyMethods.setText((File)this, (String)content);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not append to test file '%s'", this), e);
        }
    }

    public void copyTo(File target) {
        if (this.isDirectory()) {
            try {
                final Path targetDir = target.toPath();
                final Path sourceDir = this.toPath();
                Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path sourceFile, BasicFileAttributes attributes) throws IOException {
                        Path targetFile = targetDir.resolve(sourceDir.relativize(sourceFile));
                        Files.copy(sourceFile, targetFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
                        Path newDir = targetDir.resolve(sourceDir.relativize(dir));
                        Files.createDirectories(newDir, new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Could not copy test directory '%s' to '%s'", this, target), e);
            }
        }
        try {
            FileUtils.copyFile((File)this, (File)target);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not copy test file '%s' to '%s'", this, target), e);
        }
    }

    public boolean isSymbolicLink() {
        return Files.isSymbolicLink(this.toPath());
    }

    public ExecOutput exec(Object ... args) {
        return new TestFileHelper(this).exec(Arrays.asList(args));
    }

    public ExecOutput execWithFailure(List<?> args, List<?> env) {
        return new TestFileHelper(this).executeFailure(args, env);
    }

    public ExecOutput execute(List<?> args, List<?> env) {
        return new TestFileHelper(this).execute(args, env);
    }

    public void copyFrom(File target) {
        new TestFile(target, new Object[0]).copyTo(this);
    }

    public void copyFrom(final URL resource) {
        final TestFile testFile = this;
        try {
            RetryUtil.retry(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileUtils.copyURLToFile((URL)resource, (File)testFile);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void unzipTo(File target) {
        this.assertIsFile();
        new TestFileHelper(this).unzipTo(target, this.useNativeTools);
    }

    public TestFile withExtension(String extension) {
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        if (FilenameUtils.isExtension((String)this.getName(), (String)extension)) {
            return this;
        }
        return this.getParentFile().file(FilenameUtils.removeExtension((String)this.getName()) + '.' + extension);
    }

    public Snapshot snapshot() {
        this.assertIsFile();
        return new Snapshot(this.lastModified(), TestFile.md5(this));
    }

    public static HashCode md5(File file) {
        HashFunction hf = Hashing.md5();
        HashingOutputStream hashingStream = new HashingOutputStream(hf, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        try {
            Files.copy(file.toPath(), (OutputStream)hashingStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return hashingStream.hash();
    }

    public void assertHasChangedSince(Snapshot snapshot) {
        Snapshot now = this.snapshot();
        Assert.assertTrue((String)String.format("contents or modification time of %s have not changed", this), (now.modTime != snapshot.modTime || !now.hash.equals((Object)snapshot.hash) ? 1 : 0) != 0);
    }

    public void assertContentsHaveChangedSince(Snapshot snapshot) {
        Snapshot now = this.snapshot();
        Assert.assertNotEquals((String)String.format("contents of %s have not changed", this), (Object)snapshot.hash, (Object)now.hash);
    }

    public void assertContentsHaveNotChangedSince(Snapshot snapshot) {
        Snapshot now = this.snapshot();
        Assert.assertEquals((String)String.format("contents of %s has changed", this), (Object)snapshot.hash, (Object)now.hash);
    }

    public void assertHasNotChangedSince(Snapshot snapshot) {
        Snapshot now = this.snapshot();
        Assert.assertEquals((String)String.format("last modified time of %s has changed", this), (long)snapshot.modTime, (long)now.modTime);
        Assert.assertEquals((String)String.format("contents of %s has changed", this), (Object)snapshot.hash, (Object)now.hash);
    }

    public static class Snapshot {
        private final long modTime;
        private final HashCode hash;

        public Snapshot(long modTime, HashCode hash) {
            this.modTime = modTime;
            this.hash = hash;
        }

        public long getModTime() {
            return this.modTime;
        }

        public HashCode getHash() {
            return this.hash;
        }
    }
}

