/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.test.fixtures.file;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.gradle.api.JavaVersion;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassFile {
    public boolean hasSourceFile;
    public boolean hasLineNumbers;
    public boolean hasLocalVars;
    public int classFileVersion;

    public ClassFile(File file) {
        this(ClassFile.newInputStream(file));
    }

    private static InputStream newInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ClassFile(InputStream inputStream) {
        final MethodVisitor methodVisitor = new MethodVisitor(458752){

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                ClassFile.this.hasLocalVars = true;
            }

            public void visitLineNumber(int line, Label start) {
                ClassFile.this.hasLineNumbers = true;
            }
        };
        ClassVisitor visitor = new ClassVisitor(458752){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                ClassFile.this.classFileVersion = version;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return methodVisitor;
            }

            public void visitSource(String source, String debug) {
                ClassFile.this.hasSourceFile = true;
            }
        };
        try {
            byte[] classData = ByteStreams.toByteArray((InputStream)inputStream);
            new ClassReader(classData).accept(visitor, 0);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JavaVersion getJavaVersion() {
        return JavaVersion.forClassVersion((int)this.classFileVersion);
    }

    public boolean getDebugIncludesSourceFile() {
        return this.hasSourceFile;
    }

    public boolean getDebugIncludesLineNumbers() {
        return this.hasLineNumbers;
    }

    public boolean getDebugIncludesLocalVariables() {
        return this.hasLocalVars;
    }
}

