/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.fixtures.vcs;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.fixtures.vcs.GitRepository;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class GitFileRepository
implements GitRepository,
AutoCloseable {
    private final String repositoryName;
    private final File parentDirectory;
    private Git git;

    public GitFileRepository(String repositoryName, File parentDirectory) {
        this.repositoryName = repositoryName;
        this.parentDirectory = parentDirectory;
    }

    public GitFileRepository(File parentDirectory) {
        this("repo", parentDirectory);
    }

    public Git getGit() {
        return this.git;
    }

    public String getName() {
        return this.repositoryName;
    }

    public static GitFileRepository init(File repositoryDirectory) throws GitAPIException {
        GitFileRepository repo = new GitFileRepository(repositoryDirectory);
        repo.createGitRepo(repositoryDirectory);
        return repo;
    }

    public static GitFileRepository open(File repositoryDirectory) throws IOException {
        GitFileRepository repo = new GitFileRepository(repositoryDirectory);
        repo.openGitRepo(repositoryDirectory);
        return repo;
    }

    private void createGitRepo(File repositoryDirectory) throws GitAPIException {
        this.git = Git.init().setDirectory(repositoryDirectory).call();
    }

    private void openGitRepo(File repositoryDirectory) throws IOException {
        this.git = Git.open((File)repositoryDirectory);
    }

    @Override
    public void close() {
        this.git.close();
    }

    public RevCommit addSubmodule(GitFileRepository submoduleRepo) throws GitAPIException {
        try (Repository submodule = this.git.submoduleAdd().setURI(submoduleRepo.getWorkTree().toString()).setPath(submoduleRepo.getName()).call();){
            RevCommit revCommit = this.commit("add submodule " + submoduleRepo.getName(), submoduleRepo.getName());
            return revCommit;
        }
    }

    public List<URI> getRemotes() throws GitAPIException, URISyntaxException {
        ArrayList<URI> list = new ArrayList<URI>();
        for (RemoteConfig it : this.git.remoteList().call()) {
            for (URIish urIish : it.getURIs()) {
                URI uri = new URI(urIish.toString());
                list.add(uri);
            }
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RevCommit updateSubmodulesToLatest() throws GitAPIException {
        ArrayList<String> submodulePaths = new ArrayList<String>();
        try (SubmoduleWalk walker = SubmoduleWalk.forIndex((Repository)this.git.getRepository());){
            while (walker.next()) {
                Repository submodule;
                block24: {
                    submodule = walker.getRepository();
                    Throwable throwable = null;
                    try {
                        submodulePaths.add(walker.getPath());
                        Git.wrap((Repository)submodule).pull().call();
                        if (submodule == null) continue;
                        if (throwable == null) break block24;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (submodule == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    submodule.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            submodule.close();
                            throw throwable3;
                        }
                    }
                    try {
                        submodule.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                submodule.close();
            }
            return this.commit("update submodules", submodulePaths.toArray(new String[0]));
        }
        catch (IOException e) {
            return (RevCommit)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public RevCommit commit(String message, String ... paths) throws GitAPIException {
        AddCommand add = this.git.add();
        for (String path : paths) {
            add.addFilepattern(path);
        }
        add.call();
        return this.commit(message);
    }

    @Override
    public RevCommit commit(String message) throws GitAPIException {
        AddCommand add = this.git.add();
        for (File file : FileUtils.listFiles((File)this.getWorkTree(), null, (boolean)true)) {
            add.addFilepattern(this.relativePath(file));
        }
        add.call();
        CommitCommand commit = this.git.commit();
        commit.setSign(Boolean.valueOf(false));
        return commit.setMessage(message).call();
    }

    @Override
    public Ref createBranch(String branchName) throws GitAPIException {
        return this.git.branchCreate().setName(branchName).call();
    }

    @Override
    public Ref checkout(String branchName) throws GitAPIException {
        return this.git.checkout().setName(branchName).call();
    }

    @Override
    public Ref createLightWeightTag(String tagName) throws GitAPIException {
        return this.git.tag().setName(tagName).call();
    }

    public Ref createAnnotatedTag(String tagName, String message) throws GitAPIException {
        return this.git.tag().setName(tagName).setAnnotated(true).setMessage(message).call();
    }

    public Ref getHead() throws IOException {
        return this.git.getRepository().findRef("HEAD");
    }

    @Override
    public File getWorkTree() {
        return this.git.getRepository().getWorkTree();
    }

    @Override
    public File file(Object ... path) {
        return FileSystemUtils.file((File)this.getWorkTree(), (Object[])path);
    }

    @Override
    public URI getUrl() {
        return this.getWorkTree().toURI();
    }

    private String relativePath(File file) {
        return this.getUrl().relativize(file.toURI()).toString();
    }

    public String getId() {
        return "git-repo:" + this.getUrl().toASCIIString();
    }
}

