/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.fixtures.sources;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public final class SourceKind {
    public static final SourceKind C = new SourceKind("c", "c");
    public static final SourceKind CPP = new SourceKind("cpp", "cpp", "cc", "cxx");
    public static final SourceKind OBJECTIVE_C = new SourceKind("objective-c", "m");
    public static final SourceKind OBJECTIVE_CPP = new SourceKind("objective-cpp", "mm");
    public static final SourceKind SWIFT = new SourceKind("swift", "swift");
    public static final SourceKind JAVA = new SourceKind("java", "java");
    public static final SourceKind HEADER = new SourceKind("header", "h", "hpp");
    public static final SourceKind UNKNOWN = new SourceKind("unknown", new String[0]);
    private static final Set<SourceKind> DEFAULT_KINDS = ImmutableSet.of((Object)C, (Object)CPP, (Object)OBJECTIVE_C, (Object)OBJECTIVE_CPP, (Object)SWIFT, (Object)JAVA, (Object[])new SourceKind[]{HEADER});
    private final String identifier;
    private final Set<String> fileExtensions;

    private SourceKind(String identifier, String ... fileExtensions) {
        this.identifier = identifier;
        this.fileExtensions = ImmutableSet.copyOf((Object[])fileExtensions);
    }

    public static SourceKind of(String identifier) {
        return new SourceKind(identifier, new String[0]);
    }

    public static SourceKind valueOf(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        return DEFAULT_KINDS.stream().filter(it -> it.fileExtensions.contains(extension)).findFirst().orElse(UNKNOWN);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceKind)) {
            return false;
        }
        SourceKind other = (SourceKind)o;
        String this$identifier = this.identifier;
        String other$identifier = other.identifier;
        return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.identifier;
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        return result;
    }
}

