/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.fixtures.sources;

import dev.gradleplugins.fixtures.sources.SourceElement;
import dev.gradleplugins.fixtures.sources.SourceFile;
import dev.gradleplugins.fixtures.sources.SourceKind;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class NativeSourceElement
extends SourceElement {
    public SourceElement getHeaders() {
        return NativeSourceElement.empty();
    }

    public abstract SourceElement getSources();

    @Override
    public List<SourceFile> getFiles() {
        ArrayList<SourceFile> files = new ArrayList<SourceFile>();
        files.addAll(this.getSources().getFiles());
        files.addAll(this.getHeaders().getFiles());
        return files;
    }

    public static SourceElement ofHeaders(SourceElement element) {
        return NativeSourceElement.ofFiles(element.getFiles().stream().filter(it -> it.getKind().equals(SourceKind.HEADER)).collect(Collectors.toList()));
    }

    public static SourceElement ofSources(SourceElement element) {
        return NativeSourceElement.ofFiles(element.getFiles().stream().filter(it -> !it.getKind().equals(SourceKind.HEADER)).collect(Collectors.toList()));
    }

    public List<String> getSourceFileNamesWithoutHeaders() {
        return this.getSourceFileNames().stream().filter(sourceFileName -> !sourceFileName.endsWith(".h")).collect(Collectors.toList());
    }

    public static NativeSourceElement ofNativeElements(final NativeSourceElement ... elements) {
        return new NativeSourceElement(){

            @Override
            public SourceElement getHeaders() {
                return 1.ofElements(Arrays.stream(elements).map(NativeSourceElement::getHeaders).collect(Collectors.toList()));
            }

            @Override
            public SourceElement getSources() {
                return 1.ofElements(Arrays.stream(elements).map(NativeSourceElement::getSources).collect(Collectors.toList()));
            }

            @Override
            public List<SourceFile> getFiles() {
                ArrayList<SourceFile> files = new ArrayList<SourceFile>();
                for (NativeSourceElement element : elements) {
                    files.addAll(((SourceElement)element).getFiles());
                }
                return files;
            }

            @Override
            public void writeToProject(File projectDir) {
                for (NativeSourceElement element : elements) {
                    element.writeToProject(projectDir);
                }
            }
        };
    }
}

