/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.fixtures.sources;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.fixtures.sources.Element;
import dev.gradleplugins.fixtures.sources.SourceFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class SourceElement
extends Element {
    public abstract List<SourceFile> getFiles();

    public String getSourceSetName() {
        return "main";
    }

    public void writeToProject(File projectDir) {
        File srcDir = FileSystemUtils.file((File)projectDir, (Object[])new Object[]{"src/" + this.getSourceSetName()});
        for (SourceFile sourceFile : this.getFiles()) {
            sourceFile.writeToDirectory(srcDir);
        }
    }

    public void writeToSourceDir(File sourceDir) {
        for (SourceFile sourceFile : this.getFiles()) {
            sourceFile.writeToFile(FileSystemUtils.file((File)sourceDir, (Object[])new Object[]{sourceFile.getName()}));
        }
    }

    public static SourceElement empty() {
        return new SourceElement(){

            @Override
            public List<SourceFile> getFiles() {
                return Collections.emptyList();
            }
        };
    }

    public static SourceElement ofElements(SourceElement ... elements) {
        return SourceElement.ofElements(Arrays.asList(elements));
    }

    public static SourceElement ofElements(final Iterable<SourceElement> elements) {
        return new SourceElement(){

            @Override
            public List<SourceFile> getFiles() {
                ArrayList<SourceFile> files = new ArrayList<SourceFile>();
                for (SourceElement element : elements) {
                    files.addAll(element.getFiles());
                }
                return files;
            }

            @Override
            public void writeToProject(File projectDir) {
                for (SourceElement element : elements) {
                    element.writeToProject(projectDir);
                }
            }
        };
    }

    public static SourceElement ofFiles(final SourceFile ... files) {
        return new SourceElement(){

            @Override
            public List<SourceFile> getFiles() {
                return Arrays.asList(files);
            }
        };
    }

    public static SourceElement ofFiles(final List<SourceFile> files) {
        return new SourceElement(){

            @Override
            public List<SourceFile> getFiles() {
                return files;
            }
        };
    }

    public List<String> getSourceFileNames() {
        return this.getFiles().stream().map(SourceFile::getName).collect(Collectors.toList());
    }
}

