/*
 * Copyright 2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.buildtree;

import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.internal.build.BuildLifecycleController;

import java.util.function.Consumer;

public class DefaultBuildTreeWorkExecutor implements BuildTreeWorkExecutor {
    private final IncludedBuildControllers includedBuildControllers;
    private final BuildLifecycleController buildController;

    public DefaultBuildTreeWorkExecutor(IncludedBuildControllers includedBuildControllers, BuildLifecycleController buildController) {
        this.includedBuildControllers = includedBuildControllers;
        this.buildController = buildController;
    }

    @Override
    public void execute(Consumer<? super Throwable> failures) {
        includedBuildControllers.startTaskExecution();
        try {
            buildController.executeTasks();
        } catch (Exception e) {
            failures.accept(e);
        }
        includedBuildControllers.awaitTaskCompletion(failures);
    }
}
