/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.integtests.samples.dependencymanagement

import org.gradle.integtests.fixtures.AbstractIntegrationSpec
import org.gradle.integtests.fixtures.Sample
import org.gradle.integtests.fixtures.UsesSample
import org.junit.Rule

class SamplesDeclaringRepositoriesIntegrationTest extends AbstractIntegrationSpec {

    @Rule
    Sample sample = new Sample(testDirectoryProvider)

    def setup() {
        useRepositoryMirrors()
    }

    @UsesSample("userguide/dependencyManagement/declaringRepositories/publicRepository")
    def "can declare JCenter repository and resolve binary dependency"() {
        executer.inDirectory(sample.dir)

        when:
        succeeds('copyLibs')

        then:
        sample.dir.file('build/libs/guava-23.0.jar').isFile()
    }

    @UsesSample("userguide/dependencyManagement/declaringRepositories/customRepository")
    def "can declare repository with custom URL"() {
        executer.inDirectory(sample.dir)

        expect:
        succeeds('checkRepositories')
    }

    @UsesSample("userguide/dependencyManagement/declaringRepositories/multipleRepositories")
    def "can declare multiple repositories and resolve binary dependency"() {
        executer.inDirectory(sample.dir)

        when:
        succeeds('copyLibs')

        then:
        sample.dir.file('build/libs/commons-2.0.0.jar').isFile()
    }
}
