/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.model;

import dev.gradleplugins.documentationkit.model.Attachable;
import dev.gradleplugins.documentationkit.model.ClassMetaDataRepository;
import groovy.lang.Closure;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.UnknownDomainObjectException;

public class SimpleClassMetaDataRepository<T extends Attachable<T>>
implements ClassMetaDataRepository<T> {
    private final Map<String, T> classes = new TreeMap<String, T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File repoFile) {
        try (FileInputStream inputStream = new FileInputStream(repoFile);){
            ObjectInputStream objInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
            this.classes.clear();
            this.classes.putAll((Map)objInputStream.readObject());
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not load meta-data from %s.", repoFile), (Throwable)e);
        }
    }

    public void store(File repoFile) {
        try (FileOutputStream outputStream = new FileOutputStream(repoFile);){
            ObjectOutputStream objOutputStream = new ObjectOutputStream(new BufferedOutputStream(outputStream));
            objOutputStream.writeObject(this.classes);
            objOutputStream.close();
        }
        catch (IOException e) {
            throw new GradleException(String.format("Could not write meta-data to %s.", repoFile), (Throwable)e);
        }
    }

    @Override
    public T get(String fullyQualifiedClassName) {
        Object t = this.find(fullyQualifiedClassName);
        if (t == null) {
            throw new UnknownDomainObjectException(String.format("No meta-data is available for class '%s'. Did you mean? %s", fullyQualifiedClassName, this.findPossibleMatches(fullyQualifiedClassName)));
        }
        return (T)t;
    }

    @Override
    public T find(String fullyQualifiedClassName) {
        Attachable t = (Attachable)this.classes.get(fullyQualifiedClassName);
        if (t != null) {
            t.attach(this);
        }
        return (T)t;
    }

    private List<String> findPossibleMatches(String fullyQualifiedClassName) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (String className : this.classes.keySet()) {
            if (StringUtils.getLevenshteinDistance((CharSequence)fullyQualifiedClassName, (CharSequence)className) >= 8) continue;
            candidates.add(className);
        }
        return candidates;
    }

    @Override
    public void put(String fullyQualifiedClassName, T metaData) {
        this.classes.put(fullyQualifiedClassName, metaData);
    }

    @Override
    public void each(Closure cl) {
        for (Map.Entry<String, T> entry : this.classes.entrySet()) {
            cl.call(new Object[]{entry.getKey(), entry.getValue()});
        }
    }

    public void each(Action<? super T> action) {
        for (Attachable t : this.classes.values()) {
            action.execute((Object)t);
        }
    }
}

