/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.internal;

import com.google.common.collect.ImmutableList;
import dev.gradleplugins.documentationkit.DslContent;
import dev.gradleplugins.documentationkit.DslContentModelElementRegistrationFactory;
import dev.gradleplugins.documentationkit.DslMetaData;
import dev.gradleplugins.documentationkit.DslMetaDataModelElementRegistrationFactory;
import dev.gradleplugins.documentationkit.DslReferenceDocumentation;
import dev.gradleplugins.documentationkit.DslReferenceDocumentationDependenciesModelElementRegistrationFactory;
import dev.gradleplugins.documentationkit.DslReferenceDocumentationModelElementRegistrationFactory;
import dev.gradleplugins.documentationkit.TaskNamingScheme;
import dev.gradleplugins.documentationkit.TaskRegistry;
import dev.gradleplugins.documentationkit.dsl.docbook.AssembleDslDocTask;
import dev.gradleplugins.documentationkit.dsl.source.ExtractDslMetaDataTask;
import dev.nokee.model.DomainObjectProvider;
import dev.nokee.model.KnownDomainObject;
import dev.nokee.model.internal.core.ModelAction;
import dev.nokee.model.internal.core.ModelActions;
import dev.nokee.model.internal.core.ModelNodes;
import dev.nokee.model.internal.core.NodePredicate;
import dev.nokee.model.internal.core.NodeRegistration;
import dev.nokee.model.internal.core.NodeRegistrationFactoryRegistry;
import dev.nokee.model.internal.type.ModelType;
import dev.nokee.platform.base.ComponentContainer;
import dev.nokee.platform.base.internal.ComponentName;
import dev.nokee.platform.base.internal.dependencies.ConfigurationDescriptionScheme;
import dev.nokee.platform.base.internal.dependencies.ConfigurationNamingScheme;
import dev.nokee.platform.base.internal.dependencies.ConsumableDependencyBucketRegistrationFactory;
import dev.nokee.platform.base.internal.dependencies.ProjectConfigurationActions;
import dev.nokee.platform.base.internal.dependencies.ProjectConfigurationRegistry;
import dev.nokee.platform.base.internal.dependencies.ResolvableDependencyBucketRegistrationFactory;
import dev.nokee.platform.base.internal.plugins.ComponentModelBasePlugin;
import dev.nokee.utils.TransformerUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;

public class DslReferenceDocumentationPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
        ComponentContainer components = (ComponentContainer)project.getExtensions().getByType(ComponentContainer.class);
        ((NodeRegistrationFactoryRegistry)ModelNodes.of((Object)components).get(NodeRegistrationFactoryRegistry.class)).registerFactory(ModelType.of(DslReferenceDocumentation.class), name -> DslReferenceDocumentationPlugin.buildLanguageReference(name, project));
        DomainObjectProvider dslReference = components.register("dslReference", DslReferenceDocumentation.class, component -> {
            component.getPermalink().set((Object)"dsl");
            component.getClassDocbookDirectory().set(project.file((Object)"src/docs/dsl"));
        });
        ProjectConfigurationRegistry configurationRegistry = ProjectConfigurationRegistry.forProject((Project)project);
        configurationRegistry.createIfAbsent("contentElements", (Action)ProjectConfigurationActions.asConsumable().andThen(ProjectConfigurationActions.forUsage((String)"jbake-content")).andThen(ProjectConfigurationActions.attribute((Attribute)DocsType.DOCS_TYPE_ATTRIBUTE, (ProjectConfigurationActions.AttributeFactory)ProjectConfigurationActions.named((String)"jbake-content")))).getOutgoing().artifact((Object)dslReference.flatMap(component -> component.getDslContent().getContentDirectory()));
    }

    public static NodeRegistration<DslReferenceDocumentation> buildLanguageReference(String name, Project project) {
        ProjectConfigurationRegistry configurationRegistry = ProjectConfigurationRegistry.forProject((Project)project);
        ConfigurationNamingScheme namingScheme = ConfigurationNamingScheme.forComponent((ComponentName)ComponentName.of((String)name));
        ConfigurationDescriptionScheme descriptionScheme = ConfigurationDescriptionScheme.forComponent((ComponentName)ComponentName.of((String)name));
        ResolvableDependencyBucketRegistrationFactory resolvableBucketRegistrationFactory = new ResolvableDependencyBucketRegistrationFactory(configurationRegistry, namingScheme, descriptionScheme);
        ConsumableDependencyBucketRegistrationFactory consumableBucketRegistrationFactory = new ConsumableDependencyBucketRegistrationFactory(configurationRegistry, namingScheme, descriptionScheme);
        TaskRegistry taskRegistry = new TaskRegistry(project.getTasks(), TaskNamingScheme.forComponent(name));
        PluginManager pluginManager = project.getPluginManager();
        ConfigurationContainer configurations = project.getConfigurations();
        ProjectLayout projectLayout = project.getLayout();
        DslReferenceDocumentationModelElementRegistrationFactory factory = new DslReferenceDocumentationModelElementRegistrationFactory(new DslMetaDataModelElementRegistrationFactory(project.getObjects()), new DslContentModelElementRegistrationFactory(project.getObjects()), new DslReferenceDocumentationDependenciesModelElementRegistrationFactory(project.getObjects(), resolvableBucketRegistrationFactory, consumableBucketRegistrationFactory), project.getObjects());
        return factory.create(name).action(NodePredicate.self((Predicate)ModelNodes.discover()).apply(node -> {
            node.getDescendant("dslContent").applyTo(NodePredicate.self((ModelAction)ModelActions.discover(context -> {
                KnownDomainObject artifact = context.projectionOf(ModelType.of(DslContent.class));
                TaskProvider<AssembleDslDocTask> generateTask = taskRegistry.register("generate", AssembleDslDocTask.class, task -> {
                    task.getClassMetaDataFiles().from(new Object[]{artifact.flatMap(DslReferenceDocumentationPlugin.elementsOf(DslContent::getClassMetaDataFiles))});
                    task.getPluginsMetaDataFile().convention(projectLayout.getProjectDirectory().file("src/docs/dsl/plugins.xml"));
                    task.getClassNames().convention(artifact.flatMap(DslContent::getClassNames));
                    task.getClassDocbookDirectories().from(new Object[]{artifact.flatMap(DslReferenceDocumentationPlugin.elementsOf(DslContent::getClassDocbookDirectories))});
                    task.getTemplateFile().convention(artifact.flatMap(DslContent::getTemplateFile));
                    task.getDestinationDirectory().convention(projectLayout.getBuildDirectory().dir("tmp/" + task.getName()));
                });
                TaskProvider<Sync> stageTask = taskRegistry.register("stageDsl", Sync.class, task -> {
                    task.from((Object)generateTask.flatMap(AssembleDslDocTask::getDestinationDirectory), spec -> spec.into((Object)artifact.flatMap(DslContent::getPermalink)));
                    task.setDestinationDir(((Directory)projectLayout.getBuildDirectory().dir("tmp/" + task.getName()).get()).getAsFile());
                });
                artifact.configure(it -> it.getContentDirectory().fileProvider(stageTask.map(Sync::getDestinationDir)).disallowChanges());
            })));
            node.getDescendant("dslMetaData").applyTo(NodePredicate.self((ModelAction)ModelActions.discover(context -> {
                KnownDomainObject artifact = context.projectionOf(ModelType.of(DslMetaData.class));
                TaskProvider<ExtractDslMetaDataTask> extractTask = taskRegistry.register("dslMetaData", ExtractDslMetaDataTask.class, task -> {
                    task.source(new Object[]{artifact.flatMap(it -> it.getSources().getAsFileTree().getElements())});
                    task.getDestinationFile().set(projectLayout.getBuildDirectory().file("tmp/" + task.getName() + "/dslMetaData.bin"));
                });
                TaskProvider<Sync> assembleTask = taskRegistry.register("stage", Sync.class, task -> {
                    task.from(new Object[]{extractTask.flatMap(ExtractDslMetaDataTask::getDestinationFile)});
                    task.from((Object)artifact.flatMap(DslReferenceDocumentationPlugin.elementsOf(DslMetaData::getClassDocbookFiles)), spec -> spec.into((Object)"dslMetaDataClasses"));
                    task.setDestinationDir(((Directory)projectLayout.getBuildDirectory().dir("tmp/" + task.getName()).get()).getAsFile());
                });
                artifact.configure(it -> it.getExtractedMetaDataFile().fileProvider(assembleTask.map(Sync::getDestinationDir)).disallowChanges());
            })));
        })).action(NodePredicate.self((ModelAction)ModelActions.mutate((ModelType)ModelType.of(DslReferenceDocumentation.class), component -> {
            if (pluginManager.hasPlugin("java")) {
                ((DslReferenceDocumentation.Dependencies)component.getDependencies()).getDslMetaData().getAsConfiguration().extendsFrom(new Configuration[]{configurations.getByName("implementation")});
                ((DslReferenceDocumentation.Dependencies)component.getDependencies()).getDslMetaDataElements().getAsConfiguration().extendsFrom(new Configuration[]{configurations.getByName("implementation")});
            }
            component.getDslMetaData().getSources().from(new Object[]{DslReferenceDocumentationPlugin.mainJavaSourcesIfAvailable(project.getExtensions())});
            component.getDslMetaData().getClassDocbookFiles().from(new Object[]{component.getClassDocbookDirectory()});
            ((DslReferenceDocumentation.Dependencies)component.getDependencies()).getDslMetaDataElements().artifact((Object)component.getDslMetaData().getExtractedMetaDataFile());
            component.getDslContent().getPermalink().set(component.getPermalink());
            component.getDslContent().getClassNames().set(component.getClassDocbookDirectory().map(directory -> {
                if (directory.getAsFile().exists()) {
                    return Arrays.asList(directory.getAsFile().list()).stream().filter(it -> it.endsWith(".json")).map(FilenameUtils::removeExtension).collect(Collectors.toList());
                }
                return ImmutableList.of();
            }));
            component.getDslContent().getClassMetaDataFiles().from(new Object[]{component.getDslMetaData().getExtractedMetaDataFile().file("dslMetaData.bin").map(it -> {
                if (it.getAsFile().exists()) {
                    return it;
                }
                return ImmutableList.of();
            })}).from(new Object[]{((DslReferenceDocumentation.Dependencies)component.getDependencies()).getDslMetaData().getAsLenientFileCollection().getElements().map((Transformer)TransformerUtils.transformEach(it -> new File(it.getAsFile(), "dslMetaData.bin")))});
            component.getDslContent().getClassDocbookDirectories().from(new Object[]{component.getClassDocbookDirectory()});
            component.getDslContent().getClassDocbookDirectories().from(new Object[]{((DslReferenceDocumentation.Dependencies)component.getDependencies()).getDslMetaData().getAsLenientFileCollection().getElements().map((Transformer)TransformerUtils.transformEach(it -> new File(it.getAsFile(), "dslMetaDataClasses")))});
        })));
    }

    private static Callable<Object> mainJavaSourcesIfAvailable(ExtensionContainer extensions) {
        return () -> {
            SourceSet mainSourceSet;
            SourceSetContainer sourceSets = (SourceSetContainer)extensions.findByType(SourceSetContainer.class);
            if (sourceSets != null && (mainSourceSet = (SourceSet)sourceSets.findByName("main")) != null) {
                return mainSourceSet.getJava().getAsFileTree();
            }
            return ImmutableList.of();
        };
    }

    private static <IN> Transformer<Provider<Set<FileSystemLocation>>, IN> elementsOf(final Function<IN, ? extends FileCollection> mapper) {
        return new Transformer<Provider<Set<FileSystemLocation>>, IN>(){

            public Provider<Set<FileSystemLocation>> transform(IN in) {
                return ((FileCollection)mapper.apply(in)).getElements();
            }
        };
    }
}

