/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.internal;

import com.google.common.collect.ImmutableList;
import dev.gradleplugins.documentationkit.ApiReferenceDocumentation;
import dev.gradleplugins.documentationkit.ApiReferenceDocumentationDependenciesModelElementRegistrationFactory;
import dev.gradleplugins.documentationkit.ApiReferenceDocumentationModelElementRegistrationFactory;
import dev.gradleplugins.documentationkit.ApiReferenceManifest;
import dev.gradleplugins.documentationkit.ApiReferenceManifestModelElementRegistrationFactory;
import dev.gradleplugins.documentationkit.TaskNamingScheme;
import dev.gradleplugins.documentationkit.TaskRegistry;
import dev.gradleplugins.documentationkit.tasks.GenerateDependenciesManifestTask;
import dev.gradleplugins.documentationkit.tasks.GenerateRepositoriesManifestTask;
import dev.nokee.model.KnownDomainObject;
import dev.nokee.model.internal.core.ModelAction;
import dev.nokee.model.internal.core.ModelActions;
import dev.nokee.model.internal.core.ModelNode;
import dev.nokee.model.internal.core.ModelNodes;
import dev.nokee.model.internal.core.NodePredicate;
import dev.nokee.model.internal.core.NodeRegistration;
import dev.nokee.model.internal.core.NodeRegistrationFactoryRegistry;
import dev.nokee.model.internal.type.ModelType;
import dev.nokee.platform.base.ComponentContainer;
import dev.nokee.platform.base.internal.ComponentName;
import dev.nokee.platform.base.internal.dependencies.ConfigurationDescriptionScheme;
import dev.nokee.platform.base.internal.dependencies.ConfigurationNamingScheme;
import dev.nokee.platform.base.internal.dependencies.ConsumableDependencyBucketRegistrationFactory;
import dev.nokee.platform.base.internal.dependencies.DeclarableDependencyBucketRegistrationFactory;
import dev.nokee.platform.base.internal.dependencies.ProjectConfigurationRegistry;
import dev.nokee.platform.base.internal.dependencies.ResolvableDependencyBucketRegistrationFactory;
import dev.nokee.platform.base.internal.plugins.ComponentModelBasePlugin;
import dev.nokee.platform.base.internal.tasks.TaskName;
import dev.nokee.utils.ProviderUtils;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.UrlArtifactRepository;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;

public class ApiReferenceDocumentationPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
        ComponentContainer components = (ComponentContainer)project.getExtensions().getByType(ComponentContainer.class);
        ((NodeRegistrationFactoryRegistry)ModelNodes.of((Object)components).get(NodeRegistrationFactoryRegistry.class)).registerFactory(ModelType.of(ApiReferenceDocumentation.class), name -> ApiReferenceDocumentationPlugin.apiReference(name, project));
        components.register("apiReference", ApiReferenceDocumentation.class);
    }

    private static NodeRegistration<ApiReferenceDocumentation> apiReference(String name, Project project) {
        ProjectConfigurationRegistry configurationRegistry = ProjectConfigurationRegistry.forProject((Project)project);
        ConfigurationNamingScheme namingScheme = ConfigurationNamingScheme.forComponent((ComponentName)ComponentName.of((String)name));
        ConfigurationDescriptionScheme descriptionScheme = ConfigurationDescriptionScheme.forComponent((ComponentName)ComponentName.of((String)name));
        ResolvableDependencyBucketRegistrationFactory resolvableBucketRegistrationFactory = new ResolvableDependencyBucketRegistrationFactory(configurationRegistry, namingScheme, descriptionScheme);
        ConsumableDependencyBucketRegistrationFactory consumableBucketRegistrationFactory = new ConsumableDependencyBucketRegistrationFactory(configurationRegistry, namingScheme, descriptionScheme);
        DeclarableDependencyBucketRegistrationFactory declarableBucketRegistrationFactory = new DeclarableDependencyBucketRegistrationFactory(configurationRegistry, namingScheme, descriptionScheme);
        TaskRegistry taskRegistry = new TaskRegistry(project.getTasks(), TaskNamingScheme.forComponent(name));
        ProjectLayout projectLayout = project.getLayout();
        final ConfigurationContainer configurations = project.getConfigurations();
        final PluginManager pluginManager = project.getPluginManager();
        final RepositoryHandler repositories = project.getRepositories();
        final ExtensionContainer extensions = project.getExtensions();
        ObjectFactory objects = project.getObjects();
        ApiReferenceDocumentationModelElementRegistrationFactory factory = new ApiReferenceDocumentationModelElementRegistrationFactory(new ApiReferenceManifestModelElementRegistrationFactory(project.getObjects()), new ApiReferenceDocumentationDependenciesModelElementRegistrationFactory(consumableBucketRegistrationFactory, resolvableBucketRegistrationFactory, declarableBucketRegistrationFactory));
        return factory.create(name).action(NodePredicate.self((Predicate)ModelNodes.discover()).apply(node -> {
            node.getDescendant("manifest").applyTo(NodePredicate.self((ModelAction)ModelActions.discover(context -> {
                KnownDomainObject artifact = context.projectionOf(ModelType.of(ApiReferenceManifest.class));
                TaskProvider<GenerateDependenciesManifestTask> dependenciesManifestTask = taskRegistry.register(TaskName.of((String)"generate", (String)"dependenciesManifest"), GenerateDependenciesManifestTask.class, task -> {
                    task.getDependencies().set(artifact.flatMap(ApiReferenceManifest::getDependencies));
                    task.getManifestFile().set(projectLayout.getBuildDirectory().file("tmp/" + task.getName() + "/dependencies.manifest"));
                });
                TaskProvider<GenerateRepositoriesManifestTask> repositoriesManifestTask = taskRegistry.register(TaskName.of((String)"generate", (String)"repositoriesManifest"), GenerateRepositoriesManifestTask.class, task -> {
                    task.getRepositories().set(artifact.flatMap(ApiReferenceManifest::getRepositories));
                    task.getManifestFile().set(projectLayout.getBuildDirectory().file("tmp/" + task.getName() + "/repositories.manifest"));
                });
                TaskProvider<Sync> syncTask = taskRegistry.register(TaskName.of((String)"assemble", (String)"manifest"), Sync.class, task -> {
                    task.from((Object)artifact.map(ApiReferenceManifest::getSources), spec -> spec.into((Object)"sources"));
                    task.from(new Object[]{dependenciesManifestTask.flatMap(GenerateDependenciesManifestTask::getManifestFile)});
                    task.from(new Object[]{repositoriesManifestTask.flatMap(GenerateRepositoriesManifestTask::getManifestFile)});
                    task.setDestinationDir(((Directory)projectLayout.getBuildDirectory().dir("tmp/" + task.getName()).get()).getAsFile());
                });
                artifact.configure(it -> it.getDestinationLocation().fileProvider(syncTask.map(Sync::getDestinationDir)).disallowChanges());
            })));
            node.getDescendant("manifest").applyTo(NodePredicate.self((ModelAction)ModelActions.mutate((ModelType)ModelType.of(ApiReferenceManifest.class), (Consumer)new Consumer<ApiReferenceManifest>(){

                @Override
                public void accept(ApiReferenceManifest artifact) {
                    artifact.getRepositories().addAll(ApiReferenceDocumentationPlugin.forCallable(this::repositoryUrls));
                    artifact.getSources().from(new Object[]{ApiReferenceDocumentationPlugin.asCallable(this::mainJavaSourcesIfAvailable)});
                    artifact.getDependencies().addAll(ApiReferenceDocumentationPlugin.forCallable(this::externalCompileClasspathDependenciesIfAvailable));
                }

                private Iterable<URI> repositoryUrls() {
                    return repositories.stream().filter(UrlArtifactRepository.class::isInstance).map(UrlArtifactRepository.class::cast).map(UrlArtifactRepository::getUrl).collect(Collectors.toList());
                }

                private List<FileTree> mainJavaSourcesIfAvailable() {
                    if (pluginManager.hasPlugin("java")) {
                        return ImmutableList.of((Object)((SourceSet)((SourceSetContainer)extensions.getByType(SourceSetContainer.class)).getByName("main")).getJava().getAsFileTree());
                    }
                    return ImmutableList.of();
                }

                private Iterable<Dependency> externalCompileClasspathDependenciesIfAvailable() {
                    if (pluginManager.hasPlugin("java")) {
                        return configurations.getByName("compileClasspath").getAllDependencies().stream().filter(ExternalDependency.class::isInstance).collect(Collectors.toList());
                    }
                    return ImmutableList.of();
                }
            })));
            ModelNode apiNode = node.getDescendant("dependencies").getDescendant("api");
            node.getDescendant("dependencies").getDescendant("manifestElements").applyTo(NodePredicate.self((Predicate)ModelNodes.discover()).apply(ModelActions.executeUsingProjection((ModelType)ModelType.of(Configuration.class), c -> {
                c.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "api-reference-manifest"));
                c.extendsFrom(new Configuration[]{(Configuration)apiNode.get(Configuration.class)});
            })));
            node.getDescendant("dependencies").getDescendant("manifest").applyTo(NodePredicate.self((Predicate)ModelNodes.discover()).apply(ModelActions.executeUsingProjection((ModelType)ModelType.of(Configuration.class), c -> {
                c.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "api-reference-manifest"));
                c.extendsFrom(new Configuration[]{(Configuration)apiNode.get(Configuration.class)});
            })));
        })).action(NodePredicate.self((ModelAction)ModelActions.mutate((ModelType)ModelType.of(ApiReferenceDocumentation.class), component -> ((ApiReferenceDocumentation.Dependencies)component.getDependencies()).getManifestElements().artifact((Object)component.getManifest().getDestinationLocation()))));
    }

    private static <T> Callable<T> asCallable(Callable<T> callable) {
        return callable;
    }

    private static <T> Provider<T> forCallable(Callable<T> callable) {
        return ProviderUtils.supplied(callable);
    }
}

