/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.source.model;

import dev.gradleplugins.documentationkit.dsl.source.model.AbstractLanguageElement;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.MethodMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeContainer;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeMetaData;
import java.io.Serializable;
import org.gradle.api.Action;

public class PropertyMetaData
extends AbstractLanguageElement
implements Serializable,
TypeContainer {
    private TypeMetaData type;
    private final String name;
    private final ClassMetaData ownerClass;
    private MethodMetaData setter;
    private MethodMetaData getter;

    public PropertyMetaData(String name, ClassMetaData ownerClass) {
        this.name = name;
        this.ownerClass = ownerClass;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s.%s", this.ownerClass, this.name);
    }

    public TypeMetaData getType() {
        return this.type;
    }

    public void setType(TypeMetaData type) {
        this.type = type;
    }

    public boolean isWriteable() {
        return this.setter != null;
    }

    public boolean isReadable() {
        return this.getter != null;
    }

    public boolean isProviderApi() {
        return this.setter == null && (this.getType().getName().contains("Provider") || this.getType().getName().contains("Property"));
    }

    public ClassMetaData getOwnerClass() {
        return this.ownerClass;
    }

    public String getSignature() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type.getSignature());
        builder.append(' ');
        builder.append(this.name);
        return builder.toString();
    }

    public MethodMetaData getGetter() {
        return this.getter;
    }

    public void setGetter(MethodMetaData getter) {
        this.getter = getter;
    }

    public MethodMetaData getSetter() {
        return this.setter;
    }

    public void setSetter(MethodMetaData setter) {
        this.setter = setter;
    }

    public PropertyMetaData getOverriddenProperty() {
        MethodMetaData overriddenMethod = null;
        if (this.getter != null) {
            overriddenMethod = this.getter.getOverriddenMethod();
        }
        if (overriddenMethod == null && this.setter != null) {
            overriddenMethod = this.setter.getOverriddenMethod();
        }
        if (overriddenMethod != null) {
            return overriddenMethod.getOwnerClass().findDeclaredProperty(this.name);
        }
        return null;
    }

    @Override
    public void visitTypes(Action<TypeMetaData> action) {
        action.execute((Object)this.type);
    }
}

