/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.dsl.source.model;

import dev.gradleplugins.documentationkit.dsl.source.model.AbstractLanguageElement;
import dev.gradleplugins.documentationkit.dsl.source.model.ClassMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.ParameterMetaData;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeContainer;
import dev.gradleplugins.documentationkit.dsl.source.model.TypeMetaData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Action;

public class MethodMetaData
extends AbstractLanguageElement
implements Serializable,
TypeContainer {
    private final String name;
    private final ClassMetaData ownerClass;
    private final List<ParameterMetaData> parameters = new ArrayList<ParameterMetaData>();
    private TypeMetaData returnType;

    public MethodMetaData(String name, ClassMetaData ownerClass) {
        this.name = name;
        this.ownerClass = ownerClass;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s.%s()", this.ownerClass, this.name);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodMetaData that = (MethodMetaData)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.ownerClass.getClassName(), that.ownerClass.getClassName()) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.returnType, that.returnType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.ownerClass, this.parameters, this.returnType);
    }

    public ClassMetaData getOwnerClass() {
        return this.ownerClass;
    }

    public TypeMetaData getReturnType() {
        return this.returnType;
    }

    public void setReturnType(TypeMetaData returnType) {
        this.returnType = returnType;
    }

    public MethodMetaData getOverriddenMethod() {
        LinkedList<ClassMetaData> queue = new LinkedList<ClassMetaData>();
        queue.add(this.ownerClass.getSuperClass());
        queue.addAll(this.ownerClass.getInterfaces());
        String overrideSignature = this.getOverrideSignature();
        while (!queue.isEmpty()) {
            ClassMetaData cl = (ClassMetaData)queue.removeFirst();
            if (cl == null) continue;
            MethodMetaData overriddenMethod = cl.findDeclaredMethod(overrideSignature);
            if (overriddenMethod != null) {
                return overriddenMethod;
            }
            queue.add(cl.getSuperClass());
            queue.addAll(cl.getInterfaces());
        }
        return null;
    }

    public List<ParameterMetaData> getParameters() {
        return this.parameters;
    }

    public ParameterMetaData addParameter(String name, TypeMetaData type) {
        ParameterMetaData param = new ParameterMetaData(name);
        param.setType(type);
        this.parameters.add(param);
        return param;
    }

    public String getSignature() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.returnType.getSignature());
        builder.append(' ');
        builder.append(this.name);
        builder.append('(');
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterMetaData param = this.parameters.get(i);
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(param.getSignature());
        }
        builder.append(')');
        return builder.toString();
    }

    public String getOverrideSignature() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append('(');
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterMetaData param = this.parameters.get(i);
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(param.getType().getRawType().getSignature());
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void visitTypes(Action<TypeMetaData> action) {
        action.execute((Object)this.returnType);
        for (ParameterMetaData parameter : this.parameters) {
            parameter.visitTypes(action);
        }
    }
}

